/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.blueocean_bitbucket_pipeline.cloud.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.jenkins.blueocean.blueocean_bitbucket_pipeline.model.BbPage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BbCloudPage<T>
extends BbPage<T> {
    private final int pageLength;
    private final int page;
    private final int size;
    private final String next;
    private final List<T> values;

    public BbCloudPage(@JsonProperty(value="pagelen") int pageLength, @JsonProperty(value="page") int page, @JsonProperty(value="size") int size, @JsonProperty(value="next") @Nullable String next, @JsonProperty(value="values") @NonNull List<T> values) {
        this.pageLength = pageLength;
        this.page = page;
        this.size = size;
        this.next = next;
        this.values = Collections.unmodifiableList(new ArrayList<T>(values));
    }

    @Override
    public int getStart() {
        int start = this.pageLength * (this.page - 1);
        return Math.max(start, 0);
    }

    @Override
    public int getLimit() {
        return this.pageLength;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public List<T> getValues() {
        return this.values;
    }

    public String getNext() {
        return this.next;
    }

    @Override
    public boolean isLastPage() {
        return this.next == null;
    }
}

