/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.concurrent_login;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.PageDecorator;
import hudson.plugins.concurrent_login.SessionManager;
import hudson.plugins.concurrent_login.UserInfoProperty;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.export.Exported;

@Extension
public class UserInfoDecorator
extends PageDecorator {
    private String sess_id;
    private String alreadyLoginID;
    final Logger logger = Logger.getLogger("hudson.plugins.concurrent_login");

    public UserInfoDecorator() {
        this.logger.log(Level.INFO, "***** Loading UserInfoDecorator...");
        this.load();
    }

    public void requestInfo(HttpServletRequest request, HttpServletResponse response, String loginUserID) {
        UserInfoProperty.DescriptorImpl descriptor = (UserInfoProperty.DescriptorImpl)Hudson.getInstance().getDescriptorByType(UserInfoProperty.DescriptorImpl.class);
        if (descriptor.getuseConcurrentLogin()) {
            this.alreadyLoginID = null;
            HttpSession session = request.getSession(false);
            this.sess_id = session.getId();
            SessionManager sessionManager = SessionManager.getInstance();
            if (!loginUserID.equals("anonymous") && !sessionManager.isLogin(this.sess_id)) {
                if (!sessionManager.isUsing(loginUserID)) {
                    sessionManager.setSession(session, loginUserID);
                } else {
                    this.alreadyLoginID = loginUserID;
                    try {
                        response.sendRedirect("/jenkins/logout");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public String getAlreadyLoginCheck() {
        return this.alreadyLoginID;
    }

    public String getSessId() {
        return this.sess_id;
    }

    @Exported
    public String getName() {
        return this.auth().getName();
    }

    private Authentication auth() {
        return Jenkins.getAuthentication();
    }
}

