/*
 * Decompiled with CFR 0.152.
 */
package eu.markov.jenkins.plugin.mvnmeta;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import eu.markov.jenkins.plugin.mvnmeta.MavenMetadataParameterDefinition;
import hudson.model.Hudson;
import hudson.model.ModelObject;
import hudson.model.ParameterDefinition;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public abstract class MavenMetadataParameterDefinitionBackwardCompatibility
extends ParameterDefinition {
    private static final long serialVersionUID = -694351540106684393L;
    private static final Logger LOGGER = Logger.getLogger(MavenMetadataParameterDefinition.class.getName());
    @Deprecated
    private transient String username;
    @Deprecated
    private transient String password;

    public MavenMetadataParameterDefinitionBackwardCompatibility(String name, String description) {
        super(name, description);
    }

    public Object readResolve() throws IOException {
        if (StringUtils.isBlank((String)this.getCredentialsId()) && StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            try {
                this.migrateCredentials();
            }
            catch (IOException ioe) {
                this.setCredentialsId(null);
                LOGGER.warning("Credentials for repo " + this.getRepoBaseUrl() + " and user " + this.username + " could not be migrated");
            }
        }
        return this;
    }

    private void migrateCredentials() throws IOException {
        String customCredentialsId;
        String repoBaseUrl = this.getRepoBaseUrl();
        try {
            customCredentialsId = this.createRepoBaseUrlWithImplicitUser();
        }
        catch (MalformedURLException e) {
            customCredentialsId = this.username + "@" + repoBaseUrl;
        }
        this.setCredentialsId(customCredentialsId);
        UsernamePasswordCredentials credentials = this.findCredentialsByCredentialsId();
        if (credentials == null) {
            String description = "Generated credentials for " + customCredentialsId;
            credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.GLOBAL, customCredentialsId, description, this.username, this.password);
            CredentialsStore credentialsStore = (CredentialsStore)CredentialsProvider.lookupStores((ModelObject)Hudson.getInstance()).iterator().next();
            credentialsStore.addCredentials(Domain.global(), (Credentials)credentials);
        }
        LOGGER.fine("Migrated user " + this.username + " and password for " + repoBaseUrl + " to global credentials with ID " + customCredentialsId);
    }

    private String createRepoBaseUrlWithImplicitUser() throws MalformedURLException {
        StringBuilder credentialsIdBuilder = new StringBuilder();
        URL url = new URL(this.getRepoBaseUrl());
        credentialsIdBuilder.append(url.getProtocol());
        credentialsIdBuilder.append("://");
        credentialsIdBuilder.append(this.username);
        credentialsIdBuilder.append("@");
        credentialsIdBuilder.append(url.getHost());
        int port = url.getPort();
        if (port > -1) {
            credentialsIdBuilder.append(":");
            credentialsIdBuilder.append(port);
        }
        credentialsIdBuilder.append(url.getPath());
        return credentialsIdBuilder.toString();
    }

    protected abstract UsernamePasswordCredentials findCredentialsByCredentialsId();

    protected abstract String getRepoBaseUrl();

    protected abstract String getCredentialsId();

    protected abstract void setCredentialsId(String var1);

    @Deprecated
    public String getUsername() {
        return this.username;
    }

    @Deprecated
    public String getPassword() {
        return this.password;
    }
}

