/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.TaskListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;

@Extension
public class HealthMonitor
extends AsyncPeriodicWork {
    private long slaveUpdatePeriod = TimeUnit.MINUTES.toMillis(Math.max(2L, Long.getLong("com.splunk.splunkjenkins.slaveMonitorMinutes", 8L)));
    private long period = TimeUnit.SECONDS.toMillis(Math.max(20L, Long.getLong("com.splunk.splunkjenkins.queueMonitorSeconds", 45L)));
    private Set<String> slaveNames = new HashSet<String>();
    protected long lastAccessTime = System.currentTimeMillis();

    public HealthMonitor() {
        super("Splunk data monitor");
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        if (!SplunkJenkinsInstallation.get().isEnabled()) {
            return;
        }
        this.sendPendingQueue();
        if (System.currentTimeMillis() - this.lastAccessTime < this.slaveUpdatePeriod) {
            return;
        }
        this.lastAccessTime = System.currentTimeMillis();
        this.sendNodeUpdate();
        listener.getLogger().println("execute sendNodeUpdate");
    }

    private void sendNodeUpdate() {
        Map<String, Map<String, Object>> slaveStats = LogEventHelper.getSlaveStats();
        Set<String> aliveSlaves = slaveStats.keySet();
        SplunkLogService.getInstance().sendBatch(slaveStats.values(), EventType.SLAVE_INFO);
        ArrayList removedSlavs = new ArrayList();
        for (String slaveName : this.slaveNames) {
            if (aliveSlaves.contains(slaveName)) continue;
            HashMap<String, String> event = new HashMap<String, String>();
            event.put("event_tag", "slave");
            event.put("node_name", slaveName);
            event.put("status", "removed");
            removedSlavs.add(event);
        }
        SplunkLogService.getInstance().sendBatch(removedSlavs, EventType.SLAVE_INFO);
        SplunkLogService.getInstance().sendBatch(LogEventHelper.getRunningJob(), EventType.QUEUE_INFO);
        this.slaveNames = aliveSlaves;
        Map<String, Object> masterEvent = LogEventHelper.getMasterStats();
        masterEvent.put("item", this.name);
        masterEvent.put("event_tag", "queue");
        SplunkLogService.getInstance().send(masterEvent, EventType.QUEUE_INFO);
        ArrayList memoryUsages = new ArrayList();
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            HashMap<String, Object> memoryPoolUsage = new HashMap<String, Object>();
            MemoryUsage usageDetail = memoryPoolMXBean.getUsage();
            memoryPoolUsage.put("event_tag", "jvm_memory");
            memoryPoolUsage.put("memory_pool", memoryPoolMXBean.getName());
            memoryPoolUsage.put("init_size", usageDetail.getInit() >> 20);
            memoryPoolUsage.put("max_size", usageDetail.getMax() >> 20);
            memoryPoolUsage.put("committed_size", usageDetail.getCommitted() >> 20);
            memoryPoolUsage.put("used_size", usageDetail.getUsed() >> 20);
            memoryUsages.add(memoryPoolUsage);
        }
        SplunkLogService.getInstance().sendBatch(memoryUsages, EventType.QUEUE_INFO);
    }

    private void sendPendingQueue() {
        Queue.Item[] items = Jenkins.getInstance().getQueue().getItems();
        ArrayList queue = new ArrayList(items.length);
        for (int i = 0; i < items.length; ++i) {
            Queue.Item item = items[i];
            HashMap<String, Object> queueItem = new HashMap<String, Object>();
            queueItem.put("queue_id", item.getId());
            queueItem.put("queue_time", Float.valueOf((float)(System.currentTimeMillis() - item.getInQueueSince()) / 1000.0f));
            queueItem.put("stuck", item.isStuck());
            queueItem.put("block_reason", item.getWhy());
            queueItem.put("concurrent_build", item.task.isConcurrentBuild());
            queueItem.put("event_tag", "queue_item");
            String jobName = item.task instanceof Job ? ((Job)item.task).getFullName() : item.task.getUrl();
            queueItem.put("task", jobName);
            queue.add(queueItem);
        }
        SplunkLogService.getInstance().sendBatch(queue, EventType.QUEUE_INFO);
    }

    public long getRecurrencePeriod() {
        return this.period;
    }
}

