/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins;

import com.google.common.collect.ImmutableList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class Constants {
    public static final String TESTCASE = "testcase";
    public static final String TESTSUITE = "testsuite";
    public static final String BUILD_ID = "build_url";
    public static final String TAG = "event_tag";
    public static final String JOB_RESULT = "job_result";
    public static final String JSON_ENDPOINT = "/services/collector/event";
    public static final String RAW_ENDPOINT = "/services/collector/raw";
    public static final String LOG_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String SLAVE_TAG_NAME = "slave";
    public static final String QUEUE_TAG_NAME = "queue";
    public static final String ENQUEUE_TAG_NAME = "enqueue";
    public static final String DEQUEUE_TAG_NAME = "dequeue";
    public static final String BUILDABLE_PHASE_NAME = "buildable";
    public static final String BLOCKED_PHASE_NAME = "blocked";
    public static final String WAITING_PHASE_NAME = "waiting";
    public static final String QUEUE_WAITING_ITEM_NAME = "queue_item";
    public static final String JOB_EVENT_TAG_NAME = "job_event";
    public static final String JOB_EVENT_MONITOR = "job_monitor";
    public static final String BUILT_IN_NODE = "(built-in)";
    public static final String BUILD_REPORT_ENV_TAG = "metadata";
    public static final String JENKINS_CONFIG_PREFIX = "jenkins://";
    public static final String JENKINS_SOURCE_SEP = "/";
    public static final String AUDIT_SOURCE = "audit_trail";
    public static final String USER_NAME_KEY = "user";
    public static final String EVENT_CAUSED_BY = "event_src";
    public static final String EVENT_SOURCE_TYPE = "sourcetype";
    public static final String NODE_NAME = "node_name";
    public static final String ERROR_MESSAGE_NA = "(none)";
    public static final String MASK_PASSWORD = "***";
    public static final String NO_TEST_REPORT_FOUND = "No TestResult";
    public static final String TEST_REPORT_NOT_CONFIGURED = "Junit or xUnit report not configured";
    public static final ImmutableList<String> SCRIPT_TEXT_MD5_HASH = ImmutableList.of((Object)"729ac3b82ecf2e0afc0cb00d73c22892", (Object)"f43916477139eb890e72c1602e0851b4", (Object)"aac4abe92db9bf90e3b27a4e41728526");
    public static final int MIN_BUFFER_SIZE = Integer.getInteger("splunkins.buffer", 4096);
    public static final int JDK_FINE_LOG_BATCH = Integer.getInteger("splunkins.debugLogBatchSize", 128);
    public static final int MAX_BATCH_SIZE = 0x800000;
    public static final int GZIP_THRESHOLD = 1024;
    public static final int SLAVE_LOG_BUFFER_SIZE = MIN_BUFFER_SIZE * 4;
    public static final String COVERAGE_OVERALL_NAME = "project";
    public static final int CONSOLE_TEXT_SINGLE_LINE_MAX_LENGTH = Integer.getInteger("splunkins.lineTruncate", 100000);
    public static final int MAX_JUNIT_STDIO_SIZE = Integer.parseInt(System.getProperty("splunkins.junitStdioLimit", "2097152"));
    public static boolean DECODE_PIPELINE_CONSOLE = Boolean.parseBoolean(System.getProperty("splunkins.decodePipelineConsole", "true"));
    public static final boolean ENABLE_POST_LOGGER = Boolean.parseBoolean(System.getProperty("splunkins.auditPostRequest", "true"));
    public static final Pattern JOB_CONSOLE_FILTER_WHITELIST_PATTERN;

    static {
        Pattern filterPattern = null;
        String filterStr = System.getProperty("splunkins.allowConsoleLogPattern", "");
        if (StringUtils.isNotBlank((CharSequence)filterStr)) {
            try {
                filterPattern = Pattern.compile(filterStr);
            }
            catch (PatternSyntaxException ex) {
                Logger.getLogger("com.splunk.splunkjenkins.SplunkJenkinsInstallation").log(Level.SEVERE, "failed to parse allowConsoleLogPattern=" + filterStr, ex);
            }
        }
        JOB_CONSOLE_FILTER_WHITELIST_PATTERN = filterPattern;
    }
}

