/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.utils;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.model.CoverageMetricsAdapter;
import com.splunk.splunkjenkins.model.EventRecord;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.CoverageDetailJsonSerializer;
import com.splunk.splunkjenkins.utils.LogFileCallable;
import com.splunk.splunkjenkins.utils.SpecialDoubleAdapter;
import com.splunk.splunkjenkins.utils.SpecialFloatAdapter;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.GroovyClassLoader;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.ComputerSet;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.PasswordParameterValue;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.queue.WorkUnit;
import hudson.node_monitors.NodeMonitor;
import hudson.scm.SCM;
import hudson.tasks.Publisher;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.InterruptedBuildAction;
import jenkins.model.Jenkins;
import jenkins.triggers.SCMTriggerItem;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import shaded.splk.com.google.gson.FieldNamingStrategy;
import shaded.splk.com.google.gson.Gson;
import shaded.splk.com.google.gson.GsonBuilder;
import shaded.splk.org.apache.http.HttpEntity;
import shaded.splk.org.apache.http.HttpResponse;
import shaded.splk.org.apache.http.client.HttpClient;
import shaded.splk.org.apache.http.client.entity.GzipCompressingEntity;
import shaded.splk.org.apache.http.client.methods.HttpPost;
import shaded.splk.org.apache.http.client.methods.HttpUriRequest;
import shaded.splk.org.apache.http.client.utils.URIBuilder;
import shaded.splk.org.apache.http.entity.StringEntity;
import shaded.splk.org.apache.http.util.EntityUtils;

public class LogEventHelper {
    private static final Pattern ERROR_SPAN_CONTENT = Pattern.compile("error.*?>(.*?)</span>", 2);
    public static final String SEPARATOR = "    ";
    private static final Logger LOG = Logger.getLogger(LogEventHelper.class.getName());
    private static final String JSON_CHANNEL_ID = UUID.randomUUID().toString().toUpperCase();
    private static final String RAW_CHANNEL_ID = UUID.randomUUID().toString().toUpperCase();
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().setFieldNamingStrategy((FieldNamingStrategy)new LowerCaseStrategy()).setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").registerTypeAdapter(CoverageMetricsAdapter.CoverageDetail.class, (Object)new CoverageDetailJsonSerializer()).registerTypeAdapter(Double.class, (Object)new SpecialDoubleAdapter()).registerTypeAdapter(Float.class, (Object)new SpecialFloatAdapter()).create();
    private static final Map<String, Long> HUMAN_READABLE_SIZE = ImmutableMap.builder().put((Object)"KB", (Object)1024L).put((Object)"kB", (Object)1000L).put((Object)"KiB", (Object)1024L).put((Object)"MB", (Object)0x100000L).put((Object)"MiB", (Object)0x100000L).put((Object)"GB", (Object)0x40000000L).build();
    private static boolean gzipEnabled = !Boolean.getBoolean(LogEventHelper.class.getName() + ".disableGzip");

    public static HttpPost buildPost(EventRecord record, SplunkJenkinsInstallation config) {
        HttpPost postMethod;
        if (config.canPostRaw(record.getEventType())) {
            postMethod = new HttpPost(record.getRawEndpoint(config));
            LOG.log(Level.FINEST, "sending raw data, source=" + record.getSource());
            LogEventHelper.updateContent(postMethod, record.getMessageString(), false);
            postMethod.setHeader("x-splunk-request-channel", RAW_CHANNEL_ID);
        } else {
            String jsonRecord;
            postMethod = new HttpPost(config.getJsonUrl());
            if (record.getEventType().needSplit()) {
                String[] values;
                StringWriter stout = new StringWriter();
                for (String line : values = record.getMessageString().split("[\\r\\n]+")) {
                    if (Strings.isNullOrEmpty((String)line)) continue;
                    EventRecord lineRecord = new EventRecord(line, record.getEventType());
                    lineRecord.setSource(record.getSource());
                    lineRecord.setTime(record.getTime());
                    stout.write(gson.toJson(lineRecord.toMap(config)));
                    stout.write("\n");
                }
                jsonRecord = stout.toString();
            } else {
                jsonRecord = record.getEventType() == EventType.BATCH_JSON ? record.getMessageString() : gson.toJson(record.toMap(config));
            }
            LOG.log(Level.FINEST, jsonRecord);
            LogEventHelper.updateContent(postMethod, jsonRecord, true);
            postMethod.setHeader("x-splunk-request-channel", JSON_CHANNEL_ID);
        }
        postMethod.setHeader("Authorization", "Splunk " + config.getTokenValue());
        return postMethod;
    }

    private static void updateContent(HttpPost postMethod, String message, boolean isJson) {
        StringEntity entity = new StringEntity(message, StandardCharsets.UTF_8);
        if (isJson) {
            entity.setContentType("application/json; profile=urn:splunk:event:1.0; charset=utf-8");
        }
        if (gzipEnabled && entity.getContentLength() > 1024L) {
            postMethod.setEntity((HttpEntity)new GzipCompressingEntity((HttpEntity)entity));
        } else {
            postMethod.setEntity((HttpEntity)entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation verifyHttpInput(SplunkJenkinsInstallation config) {
        HttpPost post = LogEventHelper.buildPost(new EventRecord("ping from jenkins plugin", EventType.LOG), config);
        HttpClient client = SplunkLogService.getInstance().getClient();
        try {
            HttpResponse response = client.execute((HttpUriRequest)post);
            int respCode = response.getStatusLine().getStatusCode();
            if (respCode != 200) {
                String reason = response.getStatusLine().getReasonPhrase();
                if (respCode == 400) {
                    FormValidation formValidation = FormValidation.error((String)"Incorrect index name or do not have write permission to the default index, please check MetaData configuration");
                    return formValidation;
                }
                FormValidation formValidation = FormValidation.error((String)("Code:" + respCode + " Response:" + reason));
                return formValidation;
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
            post.releaseConnection();
            config.setRawEventEnabled(true);
            post = LogEventHelper.buildPost(new EventRecord("ping from jenkins plugin\nraw event ping", EventType.LOG), config);
            response = client.execute((HttpUriRequest)post);
            SplunkJenkinsInstallation globalConfig = SplunkJenkinsInstallation.get();
            if (response.getStatusLine().getStatusCode() != 200 && globalConfig != null) {
                SplunkJenkinsInstallation.get().setRawEventEnabled(false);
                FormValidation formValidation = FormValidation.ok((String)"Splunk connection verified but raw event is not supported");
                return formValidation;
            }
        }
        catch (IOException e) {
            FormValidation formValidation = FormValidation.error((String)e.getMessage());
            return formValidation;
        }
        finally {
            post.releaseConnection();
        }
        return FormValidation.ok((String)"Splunk connection verified");
    }

    public static boolean nonEmpty(String value) {
        return Strings.emptyToNull((String)value) != null;
    }

    public static String getUserName() {
        User user = User.current();
        if (user == null) {
            return "anonymous";
        }
        return user.getDisplayName();
    }

    private static long getUsedHeapSize() {
        MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long usedHeap = usage.getUsed();
        return usedHeap;
    }

    public static Map<String, Object> getMasterStats() {
        Jenkins instance = Jenkins.getInstance();
        int computerSize = instance.getComputers().length;
        int totalExecutors = instance.overallLoad.computeTotalExecutors();
        int queueLength = instance.overallLoad.computeQueueLength();
        int idleExecutors = instance.overallLoad.computeIdleExecutors();
        HashMap<String, Object> event = new HashMap<String, Object>();
        event.put("queue_length", queueLength);
        event.put("total_computers", computerSize);
        event.put("idle_executors", idleExecutors);
        event.put("total_executors", totalExecutors);
        long heapSize = LogEventHelper.getUsedHeapSize();
        long heapMB = heapSize >> 20;
        event.put("heap_size_mb", heapMB);
        ThreadMXBean threadMXbean = ManagementFactory.getThreadMXBean();
        int threadCount = threadMXbean.getThreadCount();
        int daemonThreadCount = threadMXbean.getDaemonThreadCount();
        event.put("thread_count", threadCount);
        event.put("daemon_count", daemonThreadCount);
        return event;
    }

    public static int sendFiles(Run build, FilePath ws, Map<String, String> envVars, TaskListener listener, String includes, String excludes, boolean sendFromSlave, long maxFileSize) {
        int eventCount = 0;
        if (ws == null) {
            return eventCount;
        }
        String expanded = Util.replaceMacro((String)includes, envVars);
        String exclude = Util.replaceMacro((String)excludes, envVars);
        try {
            if (!ws.exists()) {
                LOG.warning("ws doesn't exist: " + ws.getRemote());
                return eventCount;
            }
            Object[] paths = ws.list(expanded, exclude);
            if (paths.length == 0) {
                LOG.warning("can not find files using includes:" + includes + " excludes:" + excludes + " in workspace:" + ws.getRemote());
                return eventCount;
            }
            Map configMap = SplunkJenkinsInstallation.get().toMap();
            LogFileCallable fileCallable = new LogFileCallable(ws.getRemote(), build.getUrl(), configMap, sendFromSlave, maxFileSize);
            eventCount = fileCallable.sendFiles((FilePath[])paths);
            listener.getLogger().println("sent " + Arrays.toString(paths) + " to splunk in " + eventCount + " events");
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "failed to archive files", e);
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "interrupted while archiving file", e);
        }
        return eventCount;
    }

    public static long parseFileSize(String size) {
        if (Strings.emptyToNull((String)size) == null) {
            return 0L;
        }
        try {
            for (Map.Entry<String, Long> keyPair : HUMAN_READABLE_SIZE.entrySet()) {
                String key = keyPair.getKey();
                Long value = keyPair.getValue();
                if (!size.endsWith(key)) continue;
                String numberPart = size.substring(0, size.length() - key.length());
                if (numberPart.contains(".")) {
                    return (long)((float)value.longValue() * Float.parseFloat(numberPart));
                }
                return value * Long.parseLong(numberPart);
            }
            return Long.parseLong(size);
        }
        catch (NumberFormatException ex) {
            LOG.log(Level.SEVERE, "invalid number " + size);
            return 0L;
        }
    }

    public static String getTriggerUserName(Run run) {
        String userName = "anonymous";
        if (run.getParent().getClass().getName().equals("hudson.maven.MavenModule")) {
            return "(maven)";
        }
        Cause.UpstreamCause upstreamCause = null;
        String triggerUserName = null;
        block0: for (CauseAction action : run.getActions(CauseAction.class)) {
            for (Cause cause : action.getCauses()) {
                triggerUserName = LogEventHelper.getUsernameOrTimer(cause);
                if (triggerUserName != null) break block0;
                if (upstreamCause != null || !(cause instanceof Cause.UpstreamCause)) continue;
                upstreamCause = (Cause.UpstreamCause)cause;
            }
        }
        if (triggerUserName != null) {
            userName = triggerUserName;
        } else if (upstreamCause != null) {
            userName = LogEventHelper.getUpStreamUser(upstreamCause);
        }
        return userName;
    }

    private static String getUpStreamUser(Cause.UpstreamCause upstreamCause) {
        for (Cause upCause : upstreamCause.getUpstreamCauses()) {
            if (upCause instanceof Cause.UpstreamCause) {
                return LogEventHelper.getUpStreamUser((Cause.UpstreamCause)upCause);
            }
            String userName = LogEventHelper.getUsernameOrTimer(upCause);
            if (userName == null) continue;
            return userName;
        }
        return null;
    }

    private static String getUsernameOrTimer(Cause cause) {
        if (cause instanceof Cause.UserIdCause) {
            return ((Cause.UserIdCause)cause).getUserName();
        }
        if (cause instanceof TimerTrigger.TimerTriggerCause) {
            return "(timer)";
        }
        if (cause instanceof SCMTrigger.SCMTriggerCause) {
            return "(scm)";
        }
        return null;
    }

    private static String getNodeName(Computer computer) {
        if (computer == null) {
            return "N/A";
        }
        if (computer instanceof Jenkins.MasterComputer) {
            return "(built-in)";
        }
        return computer.getName();
    }

    public static Map<String, Object> getComputerStatus(Computer computer) {
        HashMap<String, Object> slaveInfo = new HashMap<String, Object>();
        if (computer == null) {
            return slaveInfo;
        }
        String nodeName = LogEventHelper.getNodeName(computer);
        slaveInfo.put("node_name", nodeName);
        slaveInfo.put("event_tag", "slave");
        Node slaveNode = computer.getNode();
        if (slaveNode != null) {
            slaveInfo.put("label", slaveNode.getLabelString());
        }
        slaveInfo.put("status", "updated");
        slaveInfo.put("num_executors", computer.getNumExecutors());
        slaveInfo.put("is_idle", computer.isIdle());
        slaveInfo.put("is_online", computer.isOnline());
        if (computer.isOffline()) {
            String offlineReason = computer.getOfflineCauseReason();
            if (StringUtils.contains((CharSequence)offlineReason, (CharSequence)"removed")) {
                slaveInfo.put("num_executors", 0);
                slaveInfo.put("removed", "true");
            }
            slaveInfo.put("offline_reason", offlineReason);
            slaveInfo.put("connecting", computer.isConnecting());
        }
        slaveInfo.put("url", Jenkins.getInstance().getRootUrl() + computer.getUrl());
        long connectTime = computer.getConnectTime();
        if (connectTime != 0L) {
            slaveInfo.put("connect_time", DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(connectTime)));
        } else {
            slaveInfo.put("connect_time", 0);
        }
        slaveInfo.put("uptime", LogEventHelper.getUpTime(computer));
        return slaveInfo;
    }

    public static List<Map> getRunningJob() {
        ArrayList<Map> builds = new ArrayList<Map>();
        for (Computer computer : Jenkins.getInstance().getComputers()) {
            Run run;
            ArrayList<Run> runList = new ArrayList<Run>();
            for (Executor executor : computer.getExecutors()) {
                run = LogEventHelper.getRunningJob(executor);
                if (run == null) continue;
                runList.add(run);
            }
            for (Executor executor : computer.getOneOffExecutors()) {
                run = LogEventHelper.getRunningJob(executor);
                if (run == null) continue;
                runList.add(run);
            }
            for (Run run2 : runList) {
                HashMap<String, Object> buildInfo = new HashMap<String, Object>();
                buildInfo.put("build_url", run2.getUrl());
                buildInfo.put("event_tag", "job_monitor");
                buildInfo.put("node_name", LogEventHelper.getNodeName(computer));
                buildInfo.put("job_name", run2.getParent().getFullName());
                buildInfo.put("build_number", run2.getNumber());
                buildInfo.put("job_duration", Float.valueOf(LogEventHelper.getRunDuration(run2)));
                builds.add(buildInfo);
            }
        }
        return builds;
    }

    private static Run getRunningJob(Executor executor) {
        Run run = null;
        Queue.Executable executable = executor.getCurrentExecutable();
        WorkUnit workUnit = executor.getCurrentWorkUnit();
        if (executable == null && workUnit != null) {
            executable = workUnit.getExecutable();
        }
        if (executable != null && executable instanceof Run) {
            run = (Run)executable;
        }
        return run;
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"})
    private static Object getUpTime(Computer computer) {
        Method method = MethodUtils.getAccessibleMethod(computer.getClass(), (String)"getUptime", (Class[])new Class[0]);
        if (method != null) {
            try {
                return method.invoke((Object)computer, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Map<String, Object> getMonitorData(Computer computer, NodeMonitor monitor) {
        HashMap<String, Object> monitorStatus = new HashMap<String, Object>();
        Object data = monitor.data(computer);
        if (data != null) {
            Matcher matcher;
            String monitorData;
            String monitorName = monitor.getClass().getSimpleName();
            Method method = MethodUtils.getAccessibleMethod(data.getClass(), (String)"toHtml", (Class[])new Class[0]);
            if (method != null) {
                try {
                    monitorData = (String)method.invoke(data, new Object[0]);
                }
                catch (Exception e) {
                    monitorData = data.toString();
                }
            } else {
                monitorData = data.toString();
            }
            if ((matcher = ERROR_SPAN_CONTENT.matcher(monitorData)).find()) {
                monitorStatus.put(monitorName, "warning:" + matcher.group(1));
            } else {
                monitorStatus.put(monitorName, monitorData);
            }
        }
        return monitorStatus;
    }

    public static Map<String, Map<String, Object>> getSlaveStats() {
        HashMap<String, Map<String, Object>> slaveStatusMap = new HashMap<String, Map<String, Object>>();
        Computer[] computers = Jenkins.getInstance().getComputers();
        if (computers == null || computers.length == 0) {
            return slaveStatusMap;
        }
        DescribableList monitors = ComputerSet.getMonitors();
        for (Computer computer : computers) {
            HashMap<String, Object> slaveInfo = new HashMap<String, Object>();
            slaveInfo.put("event_src", "monitor");
            slaveInfo.putAll(LogEventHelper.getComputerStatus(computer));
            for (NodeMonitor monitor : monitors) {
                slaveInfo.putAll(LogEventHelper.getMonitorData(computer, monitor));
            }
            slaveStatusMap.put((String)slaveInfo.get("node_name"), slaveInfo);
        }
        return slaveStatusMap;
    }

    public static EnvVars getEnvironment(Run run) {
        EnvVars vars;
        HashMap<String, String> maskPasswords = new HashMap<String, String>();
        List parameterActions = run.getActions(ParametersAction.class);
        for (ParametersAction parameters : parameterActions) {
            for (ParameterValue p : parameters) {
                if (!(p instanceof PasswordParameterValue)) continue;
                maskPasswords.put(p.getName(), "***");
            }
        }
        try {
            vars = run.getEnvironment(BuildListener.NULL);
            vars.putAll(maskPasswords);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "failed to get build environment for build {}", run.getUrl());
            vars = new EnvVars();
        }
        return vars;
    }

    public static Map<String, Object> getBuildVariables(Run run, boolean completed) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        List parameterActions = run.getActions(ParametersAction.class);
        for (ParametersAction parameters : parameterActions) {
            for (ParameterValue p : parameters) {
                if (p == null) continue;
                if (!p.isSensitive()) {
                    values.put(p.getName(), p.getValue());
                    continue;
                }
                values.put(p.getName(), "***");
            }
        }
        if (completed) {
            LogEventHelper.appendScm(values, run);
        }
        return values;
    }

    public static Map<String, Object> getBuildVariables(Run run) {
        return LogEventHelper.getBuildVariables(run, true);
    }

    public static void logUserAction(String user, String message) {
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.JENKINS_CONFIG)) {
            return;
        }
        HashMap<String, String> logInfo = new HashMap<String, String>();
        logInfo.put("event_tag", "audit_trail");
        logInfo.put("message", message);
        logInfo.put("user", user);
        SplunkLogService.getInstance().send(logInfo, EventType.JENKINS_CONFIG, "audit_trail");
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public static void updateSlaveInfoAsync(final String nodeName) {
        Computer.threadPoolForRemoting.submit(new Runnable(){

            @Override
            public void run() {
                Computer computer;
                Map<String, Object> event;
                Node node;
                if (nodeName != null && (node = Jenkins.getInstance().getNode(nodeName)) != null && node.toComputer() != null && !(event = LogEventHelper.getComputerStatus(computer = node.toComputer())).isEmpty()) {
                    SplunkLogService.getInstance().send(event, EventType.SLAVE_INFO);
                }
            }
        });
    }

    public static String getRelativeJenkinsHomePath(String configPath) {
        String jenkinsHome = Jenkins.getInstance().getRootDir().getPath();
        String relativePath = configPath;
        if (configPath.startsWith(jenkinsHome)) {
            relativePath = configPath.substring(jenkinsHome.length() + 1);
        }
        return relativePath;
    }

    public static String getDefaultDslScript() {
        String exampleText = "//post script section";
        try (InputStream input = LogEventHelper.class.getClassLoader().getResourceAsStream("sample.groovy");){
            exampleText = IOUtils.toString((InputStream)input);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "failed to read example.groovy", e);
        }
        return exampleText;
    }

    @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"})
    public static FormValidation validateGroovyScript(String script) {
        FormValidation validationResult = GroovySandbox.checkScriptForCompilationErrors((String)script, (GroovyClassLoader)new GroovyClassLoader(Jenkins.getInstance().getPluginManager().uberClassLoader));
        if (validationResult.kind == FormValidation.Kind.OK) {
            return ScriptApproval.get().checking(script, GroovyLanguage.get());
        }
        return validationResult;
    }

    public static boolean hasPublisherName(String shortClassName, Run build) {
        boolean found = false;
        if (!(build instanceof AbstractBuild)) {
            return found;
        }
        Descriptor publisherDescriptor = Jenkins.getInstance().getPublisher(shortClassName);
        if (publisherDescriptor == null) {
            return found;
        }
        Class clazz = publisherDescriptor.clazz;
        DescribableList publishers = ((AbstractBuild)build).getProject().getPublishersList();
        for (Publisher publisher : publishers) {
            if (!clazz.isInstance(publisher)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static float getRunDuration(Run run) {
        float duration = (float)run.getDuration() / 1000.0f;
        if (duration < 0.01f || run.isBuilding()) {
            duration = Math.max(0.0f, (float)(System.currentTimeMillis() - run.getStartTimeInMillis()) / 1000.0f);
        }
        return duration;
    }

    public static void appendScm(Map eventToAppend, Run run) {
        Map<String, Object> scmInfo = LogEventHelper.getScmInfo(run);
        for (Map.Entry<String, Object> scmEntry : scmInfo.entrySet()) {
            if (eventToAppend.containsKey(scmEntry.getKey())) continue;
            eventToAppend.put(scmEntry.getKey(), scmEntry.getValue());
        }
    }

    public static Map<String, Object> getScmInfo(Run build) {
        SCMTriggerItem scmTrigger = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)build.getParent());
        if (scmTrigger == null) {
            return Collections.emptyMap();
        }
        Collection scmConfigs = scmTrigger.getSCMs();
        HashMap<String, Object> event = new HashMap<String, Object>();
        Map<String, Object> singleEvent = new HashMap<String, Object>();
        EnvVars envVars = new EnvVars();
        for (SCM scm : scmConfigs) {
            String scmName;
            if (build instanceof AbstractBuild) {
                scm.buildEnvVars((AbstractBuild)build, (Map)envVars);
            }
            if (event.containsKey(scmName = scm.getClass().getName())) continue;
            singleEvent = LogEventHelper.getScmInfo(scmName, envVars);
            event.put(scmName, singleEvent);
        }
        if (event.size() == 1) {
            return singleEvent;
        }
        return event;
    }

    public static Map<String, Object> getScmInfo(String scmName, EnvVars envVars) {
        HashMap<String, Object> event = new HashMap<String, Object>();
        switch (scmName) {
            case "hudson.plugins.git.GitSCM": {
                event.put("scm", "git");
                event.put("scm_url", LogEventHelper.getScmURL(envVars, "GIT_URL"));
                event.put("branch", envVars.get((Object)"GIT_BRANCH"));
                event.put("revision", envVars.get((Object)"GIT_COMMIT"));
                break;
            }
            case "hudson.scm.SubversionSCM": {
                event.put("scm", "svn");
                event.put("scm_url", LogEventHelper.getScmURL(envVars, "SVN_URL"));
                event.put("revision", envVars.get((Object)"SVN_REVISION"));
                break;
            }
            case "org.jenkinsci.plugins.p4.PerforceScm": {
                event.put("scm", "p4");
                event.put("p4_client", envVars.get((Object)"P4_CLIENT"));
                event.put("revision", envVars.get((Object)"P4_CHANGELIST"));
                break;
            }
            case "hudson.plugins.mercurial.MercurialSCM": {
                event.put("scm", "hg");
                event.put("scm_url", envVars.get((Object)"MERCURIAL_REPOSITORY_URL"));
                event.put("branch", envVars.get((Object)"MERCURIAL_REVISION_BRANCH"));
                event.put("revision", envVars.get((Object)"MERCURIAL_REVISION"));
                break;
            }
            case "hudson.scm.NullSCM": {
                break;
            }
            default: {
                event.put("scm", scmName);
            }
        }
        return event;
    }

    public static String getScmURL(EnvVars envVars, String prefix) {
        String value = (String)envVars.get((Object)prefix);
        if (value == null) {
            String probe_url;
            ArrayList<String> urls = new ArrayList<String>();
            for (int i = 0; i < 10 && (probe_url = (String)envVars.get((Object)(prefix + "_" + i))) != null; ++i) {
                urls.add(Util.replaceMacro((String)probe_url, (Map)envVars));
            }
            if (!urls.isEmpty()) {
                value = StringUtils.join(urls, (String)",");
            }
        } else {
            value = Util.replaceMacro((String)value, (Map)envVars);
        }
        return value;
    }

    public static String toJson(EventRecord record) {
        if (record == null) {
            return "\"empty record\"";
        }
        SplunkJenkinsInstallation config = SplunkJenkinsInstallation.get();
        return gson.toJson(record.toMap(config));
    }

    public static String getBuildVersion() {
        Properties properties = new Properties();
        try (InputStream pomInput = LogEventHelper.class.getResourceAsStream("/META-INF/maven/com.splunk.splunkins/splunk-devops/pom.properties");){
            if (pomInput != null) {
                properties.load(pomInput);
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "failed to open file splunk-devops/pom.properties", e);
        }
        return properties.getProperty("version", "snapshot");
    }

    public static String getBuildCauses(Run run) {
        LinkedHashSet<String> causes = new LinkedHashSet<String>();
        for (CauseAction action : run.getActions(CauseAction.class)) {
            for (Cause cause : action.getCauses()) {
                causes.add(cause.getShortDescription());
            }
        }
        for (CauseAction action : run.getActions(InterruptedBuildAction.class)) {
            for (Cause cause : action.getCauses()) {
                causes.add(cause.getShortDescription());
            }
        }
        return StringUtils.join(causes, (String)", ");
    }

    static class LowerCaseStrategy
    implements FieldNamingStrategy {
        LowerCaseStrategy() {
        }

        public String translateName(Field f) {
            return f.getName().toLowerCase();
        }
    }

    public static class UrlQueryBuilder {
        private Map<String, String> query = new HashMap<String, String>();

        public static String toString(Map<String, String> queryParameters) {
            URIBuilder builder = new URIBuilder();
            for (Map.Entry<String, String> keyPair : queryParameters.entrySet()) {
                String key = keyPair.getKey();
                String value = keyPair.getValue();
                builder.addParameter(key, value);
            }
            try {
                URI uri = builder.build();
                String queryUrl = uri.toString();
                if (StringUtils.indexOf((CharSequence)queryUrl, (CharSequence)"?") == 0) {
                    return queryUrl.substring(1, queryUrl.length());
                }
                return queryUrl;
            }
            catch (URISyntaxException e) {
                LOG.log(Level.SEVERE, "failed to encode url", e);
                return "";
            }
        }

        public UrlQueryBuilder putIfAbsent(String key, String value) {
            String existValue;
            if (LogEventHelper.nonEmpty(value) && !"null".equals(value) && (existValue = this.query.get(key)) == null) {
                this.query.put(key, value);
            }
            return this;
        }

        public Map getQueryMap() {
            return Collections.unmodifiableMap(this.query);
        }

        public String build() {
            return UrlQueryBuilder.toString(this.query);
        }
    }
}

