/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.listeners;

import com.splunk.splunkjenkins.SplunkJenkinsInstallation;
import com.splunk.splunkjenkins.listeners.Messages;
import com.splunk.splunkjenkins.model.EventType;
import com.splunk.splunkjenkins.utils.LogEventHelper;
import com.splunk.splunkjenkins.utils.SplunkLogService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.Saveable;
import hudson.model.User;
import hudson.model.listeners.SaveableListener;
import java.io.IOException;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import org.apache.commons.codec.digest.DigestUtils;

@Extension
@SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
public class LoggingConfigListener
extends SaveableListener {
    private static final String XML_COMMENT = "<!--<![CDATA[%s]]>-->\n";
    private static final Logger LOGGER;
    private static final String IGNORE_CONFIG_CHANGE_PATTERN = "(?:queue|nodeMonitors|UpdateCenter|global-build-stats).xml|/(?:fingerprint|builds|config-history)/.*?xml";
    public static final Pattern IGNORED;
    private WeakHashMap cached = new WeakHashMap(512);

    public void onChange(Saveable saveable, XmlFile file) {
        if (!SplunkJenkinsInstallation.isLogHandlerRegistered()) {
            return;
        }
        String configPath = file.getFile().getAbsolutePath();
        if (saveable == null || IGNORED.matcher(configPath).find()) {
            LOGGER.log(Level.FINE, "{} is ignored", configPath);
            return;
        }
        if (saveable instanceof User) {
            return;
        }
        if (SplunkJenkinsInstallation.get().isEventDisabled(EventType.JENKINS_CONFIG)) {
            return;
        }
        String relativePath = LogEventHelper.getRelativeJenkinsHomePath(configPath);
        if (!(saveable instanceof Item)) {
            LogEventHelper.logUserAction(LogEventHelper.getUserName(), Messages.audit_update_item(relativePath));
        }
        if ("SYSTEM".equals(Jenkins.getAuthentication().getName())) {
            LOGGER.log(Level.FINE, "{0} is changed by system", configPath);
            return;
        }
        try {
            String configContent = file.asString();
            String checkSum = DigestUtils.md5Hex((String)(configPath + configContent));
            if (this.cached.containsKey(checkSum)) {
                return;
            }
            this.cached.put(checkSum, 0);
            String sourceName = "jenkins://" + relativePath;
            String userName = LogEventHelper.getUserName();
            String comment = String.format(XML_COMMENT, userName);
            SplunkLogService.getInstance().send(comment + configContent, EventType.JENKINS_CONFIG, sourceName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        Pattern ignorePattern;
        LOGGER = Logger.getLogger(LoggingConfigListener.class.getName());
        String ignorePatternStr = System.getProperty("splunkins.ignoreConfigChangePattern", IGNORE_CONFIG_CHANGE_PATTERN);
        try {
            ignorePattern = Pattern.compile(ignorePatternStr, 2);
        }
        catch (PatternSyntaxException ex) {
            ignorePattern = Pattern.compile(IGNORE_CONFIG_CHANGE_PATTERN, 2);
        }
        IGNORED = ignorePattern;
    }
}

