/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.splunkjenkins.console;

import com.splunk.splunkjenkins.console.LabelConsoleLineStream;
import com.splunk.splunkjenkins.console.PipelineConsoleDecoder;
import com.splunk.splunkjenkins.utils.RemoteUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import jenkins.util.JenkinsJVM;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.log.TaskListenerDecorator;

public class SplunkConsoleTaskListenerDecorator
extends TaskListenerDecorator {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    transient PipelineConsoleDecoder decoder;
    Map remoteSplunkinsConfig = null;
    String source;

    public SplunkConsoleTaskListenerDecorator(WorkflowRun run) {
        this.decoder = new PipelineConsoleDecoder(run);
        this.source = run.getUrl() + "console";
    }

    @NonNull
    public OutputStream decorate(@NonNull OutputStream outputStream) throws IOException {
        if (!JenkinsJVM.isJenkinsJVM()) {
            if (this.remoteSplunkinsConfig != null) {
                RemoteUtils.initSplunkConfigOnAgent((Map)this.remoteSplunkinsConfig);
            } else {
                return outputStream;
            }
        }
        if (this.decoder == null) {
            this.decoder = new PipelineConsoleDecoder(null);
        }
        return new LabelConsoleLineStream(outputStream, this.source, this.decoder);
    }

    protected void setRemoteSplunkinsConfig(Map remoteSplunkinsConfig) {
        this.remoteSplunkinsConfig = remoteSplunkinsConfig;
    }
}

