/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.containerSecurity.webhook;

import com.qualys.plugins.containerSecurity.model.ProxyConfiguration;
import java.io.PrintStream;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Webhook {
    private PrintStream buildLogger;
    private final String url;
    private final String data;
    private final ProxyConfiguration proxy;
    private static final int timeout = 60;
    private static final int RETRIES = 1;
    private static final Logger logger = Logger.getLogger(Webhook.class.getName());

    public Webhook(String url, String data, PrintStream logger, ProxyConfiguration proxy) {
        this.url = url;
        this.data = data;
        this.buildLogger = logger;
        this.proxy = proxy;
    }

    private HttpClient getHttpClient() {
        CloseableHttpClient client;
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(60).setConnectTimeout(60).setSocketTimeout(60).build();
        if (this.proxy.getUseProxy()) {
            String username = this.proxy.getProxyUsername();
            String password = this.proxy.getProxyPassword();
            if (StringUtils.isNotBlank((String)username)) {
                credsProvider.setCredentials(new AuthScope(this.proxy.getProxyServer(), this.proxy.getProxyPort()), (Credentials)new UsernamePasswordCredentials(username, password));
            }
            HttpHost proxyHost = new HttpHost(this.proxy.getProxyServer(), this.proxy.getProxyPort());
            client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setProxy(proxyHost).setDefaultRequestConfig(requestConfig).build();
        } else {
            client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(requestConfig).build();
        }
        return client;
    }

    public void post() {
        int tried = 0;
        boolean success = false;
        HttpClient client = this.getHttpClient();
        this.buildLogger.println("Sending scanned result data to webhook URL - " + this.url);
        logger.info("Sending scanned result data to webhook URL - " + this.url);
        do {
            ++tried;
            logger.info("Posted JSON: " + this.data);
            HttpPost post = new HttpPost(this.url);
            post.setEntity((HttpEntity)new StringEntity(this.data, "UTF-8"));
            post.setHeader("Content-Type", "application/json");
            try (CloseableHttpResponse response = (CloseableHttpResponse)client.execute((HttpUriRequest)post);){
                int responseCode = response.getStatusLine().getStatusCode();
                if (responseCode != 200) {
                    String responseBody = response.getEntity() != null ? new String(response.getEntity().getContent().readAllBytes()) : "";
                    this.buildLogger.println("Posting data to " + this.url + " may have failed. Webhook responded with status code - " + responseCode);
                    logger.info("Posting data to " + this.url + " may have failed. Webhook responded with status code - " + responseCode);
                    logger.info("Message from webhook - " + responseBody);
                } else {
                    success = true;
                }
            }
            catch (Exception e) {
                this.buildLogger.println("Failed to post data to webhook URL - " + this.url);
                logger.info("Failed to post data to webhook URL - " + this.url);
                e.printStackTrace(this.buildLogger);
            }
        } while (tried < 1 && !success);
        if (success) {
            this.buildLogger.println("Successfully posted data to webhook URL - " + this.url);
            logger.info("Successfully posted data to webhook URL - " + this.url);
        }
    }
}

