/*
 * Decompiled with CFR 0.152.
 */
package com.qualys.plugins.containerSecurity;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qualys.plugins.containerSecurity.GetImageVulnsCallable;
import com.qualys.plugins.containerSecurity.QualysEvaluationException;
import com.qualys.plugins.containerSecurity.common.QualysAuth.QualysAuth;
import com.qualys.plugins.containerSecurity.common.QualysClient.QualysCSClient;
import com.qualys.plugins.containerSecurity.common.QualysClient.QualysCSTestConnectionResponse;
import com.qualys.plugins.containerSecurity.common.QualysCriteria.QualysCriteria;
import com.qualys.plugins.containerSecurity.model.ProxyConfiguration;
import com.qualys.plugins.containerSecurity.report.ReportAction;
import com.qualys.plugins.containerSecurity.util.Helper;
import com.qualys.plugins.containerSecurity.webhook.Webhook;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class GetImageVulns {
    private Run<?, ?> run;
    private TaskListener listener;
    private PrintStream buildLogger;
    private QualysCSClient qualysClient;
    private int pollingIntervalForVulns;
    private int vulnsTimeout;
    private boolean isFailConditionsConfigured;
    private String webhookUrl;
    private ProxyConfiguration proxyConfiguration;
    private JsonObject criteria;
    private QualysAuth auth;
    private boolean buildSuccess = true;
    private static final Logger logger = Logger.getLogger(GetImageVulns.class.getName());

    public GetImageVulns(QualysCSClient client, QualysAuth auth, Run<?, ?> run, TaskListener listener, int pollingIntervalForVulns, int vulnsTimeout, String webhookUrl, JsonObject criteria, boolean isFailConditionsConfigured, ProxyConfiguration proxyConfiguration) {
        this.run = run;
        this.listener = listener;
        this.buildLogger = listener.getLogger();
        this.pollingIntervalForVulns = pollingIntervalForVulns;
        this.vulnsTimeout = vulnsTimeout;
        this.qualysClient = client;
        this.auth = auth;
        this.criteria = criteria;
        this.isFailConditionsConfigured = isFailConditionsConfigured;
        this.webhookUrl = webhookUrl;
        this.proxyConfiguration = proxyConfiguration;
    }

    public void getAndProcessDockerImagesScanResult(HashMap<String, String> imageList, long taggingTime) throws AbortException, QualysEvaluationException {
        if (imageList == null || imageList.isEmpty()) {
            return;
        }
        try {
            this.buildLogger.println("Testing connection with Qualys API server...");
            logger.info("Testing connection with Qualys API server...");
            boolean retry = true;
            for (int retryCount = 0; retry && retryCount <= 3; ++retryCount) {
                QualysCSTestConnectionResponse resp = this.qualysClient.testConnection();
                logger.info("Received response : " + String.valueOf(resp));
                retry = false;
                if (resp.success && (resp.responseCode == 201 || resp.responseCode == 200)) {
                    this.buildLogger.println("Test connection successful.");
                    logger.info("Test connection successful. Response code: " + resp.responseCode);
                    break;
                }
                if (resp.responseCode >= 500 && resp.responseCode <= 599 && retryCount < 3 || resp.responseCode == 400 && retryCount < 3) {
                    retry = true;
                    long secInMillis = TimeUnit.SECONDS.toMillis(5L);
                    this.buildLogger.println("Something went wrong with server; Could be a temporary glitch. Retrying in 5 secs...");
                    Thread.sleep(secInMillis);
                    continue;
                }
                throw new QualysEvaluationException(resp.message);
            }
        }
        catch (RuntimeException e) {
            logger.info("Test connection with Qualys API server failed. Reason : " + e.getMessage());
            throw new QualysEvaluationException("Test connection with Qualys API server failed. Reason : " + e.getMessage());
        }
        catch (Exception e) {
            logger.info("Test connection with Qualys API server failed. Reason : " + e.getMessage());
            throw new QualysEvaluationException("Test connection with Qualys API server failed. Reason : " + e.getMessage());
        }
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(imageList.size());
        HashMap<String, Future<String>> list = new HashMap<String, Future<String>>();
        for (String imageSha : imageList.keySet()) {
            Future<String> future = executor.submit(new GetImageVulnsCallable(taggingTime, imageSha, this.qualysClient, this.listener, this.pollingIntervalForVulns, this.vulnsTimeout, this.run.getArtifactsDir().getAbsolutePath(), this.isFailConditionsConfigured, this.auth));
            list.put(imageSha, future);
        }
        executor.shutdown();
        this.processResult(imageList, list);
    }

    public void processResult(HashMap<String, String> imageList, Map<String, Future<String>> list) throws AbortException, QualysEvaluationException {
        ArrayList<String> exceptionMessages = new ArrayList<String>();
        JsonArray trendingDataObj = new JsonArray();
        JsonObject scanReportObj = new JsonObject();
        JsonObject imageSHA = new JsonObject();
        boolean hasAtleastOneResult = false;
        ArrayList<String> otherExceptions = new ArrayList<String>();
        for (Map.Entry<String, String> entry : imageList.entrySet()) {
            String response;
            String imageID;
            block20: {
                String imageSha = entry.getKey();
                imageID = imageSha.substring(0, 12);
                response = null;
                Future<String> future = list.get(imageSha);
                try {
                    response = future.get();
                }
                catch (Exception e) {
                    if (!this.isFailConditionsConfigured) break block20;
                    otherExceptions.add(e.getMessage());
                }
            }
            if (response == null || response.isEmpty()) continue;
            try {
                JsonObject cves;
                Gson gson = new Gson();
                String criteriaString = gson.toJson((JsonElement)this.criteria);
                this.buildLogger.println("Criteria object: " + criteriaString);
                String scanResult = response;
                if (scanResult.isEmpty()) continue;
                hasAtleastOneResult = true;
                JsonObject scanResultObj = (JsonObject)gson.fromJson(scanResult, JsonObject.class);
                if (scanResultObj.has("sha")) {
                    imageSHA.addProperty(imageID, scanResultObj.get("sha").getAsString());
                }
                QualysCriteria criteria2 = new QualysCriteria(criteriaString);
                this.buildSuccess = criteria2.evaluate((JsonObject)gson.fromJson(response, JsonObject.class));
                JsonObject reportObj = criteria2.getResult();
                scanReportObj.add(imageID, (JsonElement)reportObj);
                JsonObject trend = this.getTrendingForImage(imageID, reportObj);
                trendingDataObj.add((JsonElement)trend);
                if (!this.buildSuccess) {
                    String failReason = this.getBuildFailureMessages(imageID, reportObj);
                    exceptionMessages.add(failReason);
                }
                if (reportObj.getAsJsonObject("qids") == null && reportObj.getAsJsonObject("cveIds") == null) continue;
                JsonObject qids = reportObj.getAsJsonObject("qids");
                if (qids.get("excluded") != null && !qids.get("excluded").isJsonNull() && !StringUtils.isEmpty((String)qids.get("excluded").getAsString())) {
                    this.buildLogger.println("Excluded QIDs while evaluating image <" + imageID + "> : " + qids.get("excluded").getAsString());
                }
                if ((cves = reportObj.getAsJsonObject("cveIds")).get("excluded") == null || cves.get("excluded").isJsonNull() || StringUtils.isEmpty((String)cves.get("excluded").getAsString())) continue;
                this.buildLogger.println("Excluded CVE IDs while evaluating image <" + imageID + "> : " + cves.get("excluded").getAsString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.buildLogger.println("Error while processing/evaluating scan result. Error: " + e.getMessage());
            }
        }
        if (!hasAtleastOneResult && !otherExceptions.isEmpty()) {
            throw new AbortException(otherExceptions.stream().collect(Collectors.joining("\n")));
        }
        JsonObject summaryObj = new JsonObject();
        summaryObj.add("scanResult", (JsonElement)scanReportObj);
        summaryObj.add("trendingData", (JsonElement)trendingDataObj);
        String content = summaryObj.toString();
        Helper.createNewFile(this.run.getArtifactsDir().getAbsolutePath(), "qualys_images_summary", content, this.buildLogger);
        String buildNo = "";
        try {
            EnvVars env = this.run.getEnvironment(this.listener);
            buildNo = (String)env.get((Object)"BUILD_NUMBER");
            Helper.createZip(this.run.getArtifactsDir().getAbsolutePath() + "/qualys_plugin_scanResult-" + buildNo + ".zip", this.run.getArtifactsDir().getAbsolutePath(), this.buildLogger);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.buildLogger.println("Failed to create zip file. Exception: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.buildLogger.println("Failed to create zip file. Exception: " + e.getMessage());
        }
        try {
            for (Map.Entry<String, String> entry : imageList.entrySet()) {
                String imageSha = entry.getKey();
                String imageID = imageSha.substring(0, 12);
                String originalImageStr = entry.getValue();
                String imageSHAStr = null;
                imageSHAStr = imageSHA.has(imageID) ? imageSHA.get(imageID).getAsString() : imageID;
                if (!scanReportObj.has(imageID)) continue;
                ReportAction action = new ReportAction(imageID, this.run, this.buildLogger, originalImageStr, this.auth.getPortalURL(), imageSHAStr);
                this.run.addAction((Action)action);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.buildLogger.println("Failed to create Qualys Report links. Exception: " + e.getMessage());
        }
        try {
            if (this.webhookUrl != null && !StringUtils.isEmpty((String)this.webhookUrl)) {
                this.postWebhookData(imageList.keySet(), scanReportObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.buildLogger.println("Failed to post data to webhook. Exception: " + e.getMessage());
        }
        this.buildLogger.println("Qualys Container Scanning Connector - finished.");
        if (!otherExceptions.isEmpty()) {
            exceptionMessages.addAll(otherExceptions);
        }
        if (!exceptionMessages.isEmpty()) {
            throw new QualysEvaluationException(exceptionMessages.stream().collect(Collectors.joining("\n")));
        }
    }

    public JsonObject getTrendingForImage(String imageID, JsonObject reportObj) {
        JsonObject trend = new JsonObject();
        trend.addProperty("imageId", imageID);
        JsonArray confirmedVulnsArray = new JsonArray();
        JsonObject obj = reportObj.get("confirmedVulnsBySev").getAsJsonObject();
        for (int i = 1; i <= 5; ++i) {
            confirmedVulnsArray.add(obj.get(String.valueOf(i)));
        }
        trend.add("confirmedVulns", (JsonElement)confirmedVulnsArray);
        JsonArray repos = new JsonArray();
        JsonObject imageSummaryObj = reportObj.getAsJsonObject("imageSummary");
        JsonElement repoObj = imageSummaryObj.get("repo");
        if (repoObj != null && !repoObj.isJsonNull()) {
            JsonArray repoArray = repoObj.getAsJsonArray();
            for (int i = 0; i < repoArray.size(); ++i) {
                JsonObject repo = repoArray.get(i).getAsJsonObject();
                JsonElement repoNameObj = repo.get("repository");
                if (repoNameObj == null || repoNameObj.isJsonNull()) continue;
                repos.add(repoNameObj.getAsString());
            }
        }
        trend.add("repos", (JsonElement)repos);
        return trend;
    }

    public void postWebhookData(Set<String> imageList, JsonObject scanReportObj) {
        String buildNo = "";
        String jobName = "";
        String jobUrl = "";
        try {
            EnvVars env = this.run.getEnvironment(this.listener);
            buildNo = (String)env.get((Object)"BUILD_NUMBER");
            jobName = (String)env.get((Object)"JOB_NAME");
            jobUrl = (String)env.get((Object)"JOB_URL");
        }
        catch (RuntimeException e) {
            this.buildLogger.println("Failed to fetch build number from environment variables");
        }
        catch (Exception e) {
            this.buildLogger.println("Failed to fetch build number from environment variables");
        }
        JsonObject webhookPostData = new JsonObject();
        webhookPostData.addProperty("buildNumber", buildNo);
        webhookPostData.addProperty("jobName", jobName);
        webhookPostData.addProperty("jobUrl", jobUrl);
        webhookPostData.addProperty("buildStatus", this.buildSuccess ? "Success" : "Failed");
        Gson gson = new Gson();
        JsonArray imagesDataWebhookArray = new JsonArray();
        JsonArray failReasonsArray = new JsonArray();
        for (String imageID : imageList) {
            JsonObject obj = this.makeFailReasonObject(imageID, scanReportObj);
            failReasonsArray.add((JsonElement)obj);
            JsonObject el = this.makeWebhookDataObject(imageID, scanReportObj);
            imagesDataWebhookArray.add((JsonElement)el);
        }
        if (!this.buildSuccess) {
            webhookPostData.add("failReason", gson.toJsonTree((Object)failReasonsArray));
        }
        webhookPostData.add("images", (JsonElement)imagesDataWebhookArray);
        if (!webhookPostData.isJsonNull() && this.webhookUrl != null && !StringUtils.isEmpty((String)this.webhookUrl)) {
            Webhook wh = new Webhook(this.webhookUrl, gson.toJson((JsonElement)webhookPostData), this.buildLogger, this.proxyConfiguration);
            wh.post();
        }
    }

    public JsonObject makeFailReasonObject(String imageId, JsonObject scanReportObj) {
        JsonObject returnObj = new JsonObject();
        returnObj.addProperty("imageId", imageId);
        try {
            JsonObject jsonObj = scanReportObj.getAsJsonObject(imageId);
            JsonObject severityObj = jsonObj.get("severities").getAsJsonObject();
            JsonObject severityNewObj = null;
            for (Map.Entry el : severityObj.entrySet()) {
                JsonObject sev = ((JsonElement)el.getValue()).getAsJsonObject();
                if (sev.get("result").getAsBoolean()) continue;
                if (severityNewObj == null) {
                    severityNewObj = new JsonObject();
                }
                JsonObject obj = new JsonObject();
                obj.add("configured", sev.get("configured"));
                obj.add("found", sev.get("found"));
                severityNewObj.add((String)el.getKey(), (JsonElement)obj);
            }
            if (severityNewObj != null) {
                returnObj.add("severity", severityNewObj);
            }
            JsonObject qidObj = jsonObj.get("qids").getAsJsonObject();
            JsonObject qidNewObj = null;
            if (!qidObj.get("result").getAsBoolean()) {
                qidNewObj = new JsonObject();
                qidNewObj.add("configured", qidObj.get("configured"));
                qidNewObj.add("found", qidObj.get("found"));
            }
            if (qidNewObj != null) {
                returnObj.add("qid", (JsonElement)qidNewObj);
            }
            JsonObject cveObj = jsonObj.get("cveIds").getAsJsonObject();
            JsonObject cveNewObj = null;
            if (!cveObj.get("result").getAsBoolean()) {
                cveNewObj = new JsonObject();
                cveNewObj.add("configured", cveObj.get("configured"));
                cveNewObj.add("found", cveObj.get("found"));
            }
            if (cveNewObj != null) {
                returnObj.add("cve", (JsonElement)cveNewObj);
            }
            JsonObject cvssObj = jsonObj.get("cvss").getAsJsonObject();
            JsonObject cvssNewObj = null;
            if (!cvssObj.get("result").getAsBoolean()) {
                cvssNewObj = new JsonObject();
                cvssNewObj.add("configured", cvssObj.get("configured"));
                cvssNewObj.add("found", cvssObj.get("found"));
                if (cvssObj.has("version") && cvssObj.get("version").getAsString().equalsIgnoreCase("3")) {
                    cvssNewObj.addProperty("version", (Number)3);
                } else {
                    cvssNewObj.addProperty("version", (Number)2);
                }
            }
            if (cvssNewObj != null) {
                returnObj.add("cvss", (JsonElement)cvssNewObj);
            }
            JsonObject softwareObj = jsonObj.get("software").getAsJsonObject();
            JsonObject softwareNewObj = null;
            if (!softwareObj.get("result").getAsBoolean()) {
                softwareNewObj = new JsonObject();
                softwareNewObj.add("configured", softwareObj.get("configured"));
                softwareNewObj.add("found", softwareObj.get("found"));
            }
            if (softwareNewObj != null) {
                returnObj.add("software", (JsonElement)softwareNewObj);
            }
        }
        catch (RuntimeException e) {
            logger.info("Error while making webhook data : " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.info("Error while making webhook data : " + e.getMessage());
            e.printStackTrace();
        }
        return returnObj;
    }

    public JsonObject makeWebhookDataObject(String imageId, JsonObject scanReportObj) {
        JsonObject result = new JsonObject();
        try {
            JsonObject jsonObj = scanReportObj.getAsJsonObject(imageId);
            JsonObject imageSummaryObj = jsonObj.getAsJsonObject("imageSummary");
            result.addProperty("imageId", imageId);
            result.add("uuid", imageSummaryObj.get("uuid"));
            result.add("sha", imageSummaryObj.get("sha"));
            result.add("size", imageSummaryObj.get("size"));
            result.add("repo", imageSummaryObj.get("repo"));
            result.add("operatingSystem", imageSummaryObj.get("operatingSystem"));
            result.add("layersCount", imageSummaryObj.get("layersCount"));
            result.add("dockerVersion", imageSummaryObj.get("dockerVersion"));
            result.add("architecture", imageSummaryObj.get("architecture"));
            JsonObject vulns = new JsonObject();
            vulns.add("totalVulnerabilities", jsonObj.get("totalVulnerabilities"));
            vulns.add("typeDetected", jsonObj.get("typeDetected"));
            JsonObject severity = new JsonObject();
            severity.add("Potential", jsonObj.get("potentialVulnsBySev"));
            severity.add("Confirmed", jsonObj.get("confirmedVulnsBySev"));
            vulns.add("severity", (JsonElement)severity);
            vulns.add("patchable", jsonObj.get("patchability"));
            result.add("vulnerabilities", (JsonElement)vulns);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private String getBuildFailureMessages(String imageID, JsonObject result) throws Exception {
        JsonObject cvssObj;
        boolean cvssPass;
        JsonObject obj;
        boolean criteriaPass;
        JsonObject cveObj;
        boolean cvePass;
        String found;
        JsonObject qidsObj;
        boolean qidsPass;
        ArrayList<CallSite> failureMessages = new ArrayList<CallSite>();
        if (result.has("qids") && result.get("qids") != null && !result.get("qids").isJsonNull() && !(qidsPass = (qidsObj = result.get("qids").getAsJsonObject()).get("result").getAsBoolean())) {
            found = qidsObj.get("found").getAsString();
            failureMessages.add((CallSite)((Object)("QIDs configured in Failure Conditions were found in the scan result of image " + imageID + " : " + found)));
        }
        if (result.has("cveIds") && result.get("cveIds") != null && !result.get("cveIds").isJsonNull() && !(cvePass = (cveObj = result.get("cveIds").getAsJsonObject()).get("result").getAsBoolean())) {
            found = cveObj.get("found").getAsString();
            failureMessages.add((CallSite)((Object)("CVE IDs configured in Failure Conditions were found in the scan result of image " + imageID + " : " + found)));
        }
        if (result.has("software") && result.get("software") != null && !result.get("software").isJsonNull() && !(criteriaPass = (obj = result.get("software").getAsJsonObject()).get("result").getAsBoolean())) {
            found = obj.get("found").getAsString();
            failureMessages.add((CallSite)((Object)("Softwares configured in Failure Conditions were found in the scan result of image " + imageID + " : " + found)));
        }
        StringBuffer sevConfigured = new StringBuffer();
        sevConfigured.append("\nConfigured : ");
        Object sevFound = "\nFound : ";
        boolean severityFailed = false;
        for (int i = 1; i <= 5; ++i) {
            JsonObject sevObj;
            JsonObject severity;
            if (!result.has("severities") || result.get("severities") == null || result.get("severities").isJsonNull() || !(severity = (sevObj = result.get("severities").getAsJsonObject()).get("" + i).getAsJsonObject()).has("configured") || severity.get("configured").isJsonNull() || severity.get("configured").getAsInt() == -1) continue;
            sevFound = (String)sevFound + "Severity " + i + ": " + String.valueOf(severity.get("found").isJsonNull() ? Integer.valueOf(0) : severity.get("found").getAsString()) + ";";
            sevConfigured.append("Severity " + i + ">" + severity.get("configured").getAsString() + ";");
            boolean sevPass = severity.get("result").getAsBoolean();
            if (sevPass) continue;
            severityFailed = true;
        }
        if (result.has("cvss") && result.get("cvss") != null && !result.get("cvss").isJsonNull() && !(cvssPass = (cvssObj = result.get("cvss").getAsJsonObject()).get("result").getAsBoolean())) {
            String found2 = cvssObj.get("foundMap").getAsJsonObject().toString().replaceAll("[{}]", "");
            failureMessages.add((CallSite)((Object)("CVSS Score configured in Failure Conditions were found in the scan result of image " + imageID + " : " + found2)));
        }
        if (severityFailed) {
            failureMessages.add((CallSite)((Object)("The vulnerabilities count by severity for image id " + imageID + " exceeded one of the configured threshold value :" + sevConfigured.toString() + (String)sevFound)));
        }
        return StringUtils.join(failureMessages, (String)"\n");
    }
}

