/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.hipchat.ActiveNotifier;
import jenkins.plugins.hipchat.HipChatService;
import jenkins.plugins.hipchat.StandardHipChatService;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HipChatNotifier
extends Notifier {
    private static final Logger logger = Logger.getLogger(HipChatNotifier.class.getName());
    private String jenkinsUrl;
    private String authToken;
    private String room;

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getRoom() {
        return this.room;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getJenkinsUrl() {
        return this.jenkinsUrl;
    }

    public void setJenkinsUrl(String jenkinsUrl) {
        this.jenkinsUrl = jenkinsUrl;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    @DataBoundConstructor
    public HipChatNotifier(String authToken, String room, String jenkinsUrl) {
        this.authToken = authToken;
        this.jenkinsUrl = jenkinsUrl;
        this.room = room;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    public HipChatService newHipChatService(String room) {
        return new StandardHipChatService(this.getAuthToken(), room == null ? this.getRoom() : room, "Jenkins");
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HipChatJobProperty
    extends JobProperty<AbstractProject<?, ?>> {
        private String room;
        private boolean startNotification;

        @DataBoundConstructor
        public HipChatJobProperty(String room, boolean startNotification) {
            this.room = room;
            this.startNotification = startNotification;
        }

        @Exported
        public String getRoom() {
            return this.room;
        }

        @Exported
        public boolean getStartNotification() {
            return this.startNotification;
        }

        public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
            if (this.startNotification) {
                Map map = build.getProject().getPublishersList().toMap();
                for (Publisher publisher : map.values()) {
                    if (!(publisher instanceof HipChatNotifier)) continue;
                    logger.info("Invoking Started...");
                    new ActiveNotifier((HipChatNotifier)publisher).started(build);
                }
            }
            return super.prebuild(build, listener);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class DescriptorImpl
        extends JobPropertyDescriptor {
            public String getDisplayName() {
                return "HipChat Notifications";
            }

            public boolean isApplicable(Class<? extends Job> jobType) {
                return true;
            }

            public HipChatJobProperty newInstance(StaplerRequest sr, JSONObject formData) throws Descriptor.FormException {
                return new HipChatJobProperty(sr.getParameter("hipChatProjectRoom"), sr.getParameter("hipChatStartNotification") != null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String token;
        private String room;
        private String jenkinsUrl;

        public String getToken() {
            return this.token;
        }

        public String getRoom() {
            return this.room;
        }

        public String getJenkinsUrl() {
            return this.jenkinsUrl;
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public HipChatNotifier newInstance(StaplerRequest sr) {
            if (this.token == null) {
                this.token = sr.getParameter("hipChatToken");
            }
            if (this.jenkinsUrl == null) {
                this.jenkinsUrl = sr.getParameter("hipChatJenkinsUrl");
            }
            if (this.room == null) {
                this.room = sr.getParameter("hipChatRoom");
            }
            return new HipChatNotifier(this.token, this.room, this.jenkinsUrl);
        }

        public boolean configure(StaplerRequest sr, JSONObject formData) throws Descriptor.FormException {
            this.token = sr.getParameter("hipChatToken");
            this.room = sr.getParameter("hipChatRoom");
            this.jenkinsUrl = sr.getParameter("hipChatJenkinsUrl");
            if (this.jenkinsUrl != null && !this.jenkinsUrl.endsWith("/")) {
                this.jenkinsUrl = this.jenkinsUrl + "/";
            }
            try {
                new HipChatNotifier(this.token, this.room, this.jenkinsUrl);
            }
            catch (Exception e) {
                throw new Descriptor.FormException("Failed to initialize notifier - check your global notifier configuration settings", (Throwable)e, "");
            }
            this.save();
            return super.configure(sr, formData);
        }

        public String getDisplayName() {
            return "HipChat Notifications";
        }
    }
}

