/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.tasks.Publisher;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.plugins.hipchat.ActiveNotifier;
import jenkins.plugins.hipchat.DisabledNotifier;
import jenkins.plugins.hipchat.FineGrainedNotifier;
import jenkins.plugins.hipchat.HipChatNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HipChatListener
extends RunListener<AbstractBuild> {
    private static final Logger logger = Logger.getLogger(HipChatListener.class.getName());

    public HipChatListener() {
        super(AbstractBuild.class);
    }

    public void onCompleted(AbstractBuild r, TaskListener listener) {
        this.getNotifier(r.getProject()).completed(r);
        super.onCompleted((Run)r, listener);
    }

    public void onStarted(AbstractBuild r, TaskListener listener) {
    }

    public void onDeleted(AbstractBuild r) {
    }

    public void onFinalized(AbstractBuild r) {
    }

    FineGrainedNotifier getNotifier(AbstractProject project) {
        Map map = project.getPublishersList().toMap();
        for (Publisher publisher : map.values()) {
            if (!(publisher instanceof HipChatNotifier)) continue;
            return new ActiveNotifier((HipChatNotifier)publisher);
        }
        return new DisabledNotifier();
    }
}

