/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.hipchat;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.CauseAction;
import hudson.model.Result;
import hudson.scm.ChangeLogSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Logger;
import jenkins.plugins.hipchat.FineGrainedNotifier;
import jenkins.plugins.hipchat.HipChatListener;
import jenkins.plugins.hipchat.HipChatNotifier;
import jenkins.plugins.hipchat.HipChatService;
import org.apache.commons.lang.StringUtils;

public class ActiveNotifier
implements FineGrainedNotifier {
    private static final Logger logger = Logger.getLogger(HipChatListener.class.getName());
    HipChatNotifier notifier;

    public ActiveNotifier(HipChatNotifier notifier) {
        this.notifier = notifier;
    }

    private HipChatService getHipChat(AbstractBuild r) {
        AbstractProject project = r.getProject();
        String projectRoom = Util.fixEmpty((String)((HipChatNotifier.HipChatJobProperty)project.getProperty(HipChatNotifier.HipChatJobProperty.class)).getRoom());
        return this.notifier.newHipChatService(projectRoom);
    }

    public void deleted(AbstractBuild r) {
    }

    public void started(AbstractBuild build) {
        String changes = this.getChanges(build);
        CauseAction cause = (CauseAction)build.getAction(CauseAction.class);
        if (changes != null) {
            this.notifyStart(build, changes);
        } else if (cause != null) {
            MessageBuilder message = new MessageBuilder(this.notifier, build);
            message.append(cause.getShortDescription());
            this.notifyStart(build, message.appendOpenLink().toString());
        } else {
            this.notifyStart(build, this.getBuildStatusMessage(build));
        }
    }

    private void notifyStart(AbstractBuild build, String message) {
        this.getHipChat(build).publish(message, "green");
    }

    public void finalized(AbstractBuild r) {
    }

    public void completed(AbstractBuild r) {
        this.getHipChat(r).publish(this.getBuildStatusMessage(r), ActiveNotifier.getBuildColor(r));
    }

    String getChanges(AbstractBuild r) {
        if (!r.hasChangeSetComputed()) {
            logger.info("No change set computed...");
            return null;
        }
        ChangeLogSet changeSet = r.getChangeSet();
        LinkedList<ChangeLogSet.Entry> entries = new LinkedList<ChangeLogSet.Entry>();
        HashSet files = new HashSet();
        for (Object o : changeSet.getItems()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
            logger.info("Entry " + o);
            entries.add(entry);
            files.addAll(entry.getAffectedFiles());
        }
        if (entries.isEmpty()) {
            logger.info("Empty change...");
            return null;
        }
        HashSet<String> authors = new HashSet<String>();
        for (ChangeLogSet.Entry entry : entries) {
            authors.add(entry.getAuthor().getDisplayName());
        }
        MessageBuilder message = new MessageBuilder(this.notifier, r);
        message.append("Started by changes from ");
        message.append(StringUtils.join(authors, (String)", "));
        message.append(" (");
        message.append(files.size());
        message.append(" file(s) changed)");
        return message.appendOpenLink().toString();
    }

    static String getBuildColor(AbstractBuild r) {
        Result result = r.getResult();
        if (result == Result.SUCCESS) {
            return "green";
        }
        if (result == Result.FAILURE) {
            return "red";
        }
        return "yellow";
    }

    String getBuildStatusMessage(AbstractBuild r) {
        MessageBuilder message = new MessageBuilder(this.notifier, r);
        message.appendStatusMessage();
        message.appendDuration();
        return message.appendOpenLink().toString();
    }

    public static class MessageBuilder {
        private StringBuffer message;
        private HipChatNotifier notifier;
        private AbstractBuild build;

        public MessageBuilder(HipChatNotifier notifier, AbstractBuild build) {
            this.notifier = notifier;
            this.message = new StringBuffer();
            this.build = build;
            this.startMessage();
        }

        public MessageBuilder appendStatusMessage() {
            this.message.append(MessageBuilder.getStatusMessage(this.build));
            return this;
        }

        static String getStatusMessage(AbstractBuild r) {
            if (r.isBuilding()) {
                return "Starting...";
            }
            Result result = r.getResult();
            if (result == Result.SUCCESS) {
                return "Success";
            }
            if (result == Result.FAILURE) {
                return "<b>FAILURE</b>";
            }
            if (result == Result.ABORTED) {
                return "ABORTED";
            }
            if (result == Result.NOT_BUILT) {
                return "Not built";
            }
            if (result == Result.UNSTABLE) {
                return "Unstable";
            }
            return "Unknown";
        }

        public MessageBuilder append(String string) {
            this.message.append(string);
            return this;
        }

        public MessageBuilder append(Object string) {
            this.message.append(string.toString());
            return this;
        }

        private MessageBuilder startMessage() {
            this.message.append(this.build.getProject().getDisplayName());
            this.message.append(" - ");
            this.message.append(this.build.getDisplayName());
            this.message.append(" ");
            return this;
        }

        public MessageBuilder appendOpenLink() {
            String url = this.notifier.getJenkinsUrl() + this.build.getUrl();
            this.message.append(" (<a href='").append(url).append("'>Open</a>)");
            return this;
        }

        public MessageBuilder appendDuration() {
            this.message.append(" after ");
            this.message.append(this.build.getDurationString());
            return this;
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

