/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.jenkins.digitalocean;

import com.dubture.jenkins.digitalocean.DigitalOcean;
import com.dubture.jenkins.digitalocean.DigitalOceanCloud;
import com.dubture.jenkins.digitalocean.Slave;
import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.impl.DigitalOceanClient;
import com.myjeeva.digitalocean.pojo.Droplet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import java.util.logging.Logger;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;

public class DigitalOceanComputer
extends AbstractCloudComputer<Slave>
implements TrackedItem {
    private static final Logger LOGGER = Logger.getLogger(DigitalOceanComputer.class.getName());
    private final ProvisioningActivity.Id provisioningId;
    private final String authTokenCredentialId;
    private final Integer dropletId;

    public DigitalOceanComputer(Slave slave) {
        super((AbstractCloudSlave)slave);
        this.provisioningId = slave.getId();
        this.dropletId = slave.getDropletId();
        this.authTokenCredentialId = slave.getCloud().getAuthTokenCredentialId();
    }

    public Droplet updateInstanceDescription() throws RequestUnsuccessfulException, DigitalOceanException {
        String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(this.authTokenCredentialId);
        DigitalOceanClient apiClient = new DigitalOceanClient(authToken);
        return apiClient.getDropletInfo(this.dropletId);
    }

    protected void onRemoved() {
        super.onRemoved();
        String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(this.authTokenCredentialId);
        LOGGER.info("Agent removed, deleting droplet " + this.dropletId);
        DigitalOcean.tryDestroyDropletAsync(authToken, this.dropletId);
    }

    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="I don't know what else to do in case this is null.")
    public DigitalOceanCloud getCloud() {
        return ((Slave)this.getNode()).getCloud();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="I don't know what else to do in case this is null.")
    public int getSshPort() {
        return ((Slave)this.getNode()).getSshPort();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="I don't know what else to do in case this is null.")
    public String getRemoteAdmin() {
        return ((Slave)this.getNode()).getRemoteAdmin();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="I don't know what else to do in case this is null.")
    public long getStartTimeMillis() {
        return ((Slave)this.getNode()).getStartTimeMillis();
    }
}

