/*
 * Decompiled with CFR 0.152.
 */
package com.dubture.jenkins.digitalocean;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.dubture.jenkins.digitalocean.DigitalOcean;
import com.dubture.jenkins.digitalocean.DropletName;
import com.dubture.jenkins.digitalocean.Slave;
import com.dubture.jenkins.digitalocean.SlaveTemplate;
import com.google.common.base.Strings;
import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.impl.DigitalOceanClient;
import com.myjeeva.digitalocean.pojo.Droplet;
import com.myjeeva.digitalocean.pojo.Key;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedPlannedNode;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.plaincredentials.impl.StringCredentialsImpl;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DigitalOceanCloud
extends Cloud {
    @Deprecated
    private transient String authToken;
    private String authTokenCredentialId;
    private final Integer sshKeyId;
    @Deprecated
    private transient String privateKey;
    private String privateKeyCredentialId;
    private final Integer instanceCap;
    private Boolean usePrivateNetworking;
    private final Integer timeoutMinutes;
    private Integer connectionRetryWait;
    private final List<? extends SlaveTemplate> templates;
    private static final Logger LOGGER = Logger.getLogger(DigitalOceanCloud.class.getName());
    private static final Object provisionSynchronizor = new Object();

    @Deprecated
    public DigitalOceanCloud(String name, String authToken, String privateKey, String sshKeyId, String instanceCap, Boolean usePrivateNetworking, String timeoutMinutes, String connectionRetryWait, List<? extends SlaveTemplate> templates) {
        this(name, sshKeyId, instanceCap, usePrivateNetworking, timeoutMinutes, connectionRetryWait, templates);
    }

    @DataBoundConstructor
    public DigitalOceanCloud(String name, String sshKeyId, String instanceCap, Boolean usePrivateNetworking, String timeoutMinutes, String connectionRetryWait, List<? extends SlaveTemplate> templates) {
        super(name);
        LOGGER.log(Level.INFO, "Constructing new DigitalOceanCloud(name = {0}, <token>, <privateKey>, <keyId>, instanceCap = {1}, ...)", new Object[]{name, instanceCap});
        this.sshKeyId = sshKeyId == null ? 0 : Integer.parseInt(sshKeyId);
        this.instanceCap = instanceCap == null ? 0 : Integer.parseInt(instanceCap);
        this.usePrivateNetworking = usePrivateNetworking;
        this.timeoutMinutes = timeoutMinutes == null || timeoutMinutes.isEmpty() ? 5 : Integer.parseInt(timeoutMinutes);
        this.connectionRetryWait = connectionRetryWait == null || connectionRetryWait.isEmpty() ? 10 : Integer.parseInt(connectionRetryWait);
        this.templates = templates == null ? Collections.emptyList() : templates;
        LOGGER.info("Creating DigitalOcean cloud with " + this.templates.size() + " templates");
    }

    @DataBoundSetter
    public void setPrivateKeyCredentialId(String credentialId) {
        this.privateKeyCredentialId = credentialId;
    }

    @DataBoundSetter
    @Deprecated
    public void setPrivateKey(String credential) {
        this.privateKeyCredentialId = DigitalOceanCloud.migratePrivateSshKeyToCredential(this.getDisplayName(), credential);
    }

    @Deprecated
    public String getPrivateKey() {
        return "";
    }

    public String getPrivateKeyCredentialId() {
        return this.privateKeyCredentialId;
    }

    @DataBoundSetter
    @Deprecated
    public void setAuthToken(String credential) {
        this.authTokenCredentialId = DigitalOceanCloud.migrateAuthTokenToCredential(this.getDisplayName(), credential);
    }

    @DataBoundSetter
    public void setAuthTokenCredentialId(String credentialId) {
        this.authTokenCredentialId = credentialId;
    }

    public String getAuthTokenCredentialId() {
        return this.authTokenCredentialId;
    }

    @Deprecated
    public String getAuthToken() {
        return "";
    }

    public String getDisplayName() {
        return this.name;
    }

    private boolean isInstanceCapReachedLocal() {
        if (this.instanceCap == 0) {
            return false;
        }
        int count = 0;
        LOGGER.log(Level.INFO, "cloud limit check");
        List nodes = Jenkins.get().getNodes();
        for (Node n : nodes) {
            if (!DropletName.isDropletInstanceOfCloud(n.getDisplayName(), this.name)) continue;
            ++count;
        }
        return count >= Math.min(this.instanceCap, this.getSlaveInstanceCap());
    }

    private boolean isInstanceCapReachedRemote(List<Droplet> droplets) {
        int count = 0;
        LOGGER.log(Level.INFO, "cloud limit check");
        for (Droplet droplet : droplets) {
            if (!droplet.isActive() && !droplet.isNew() || !DropletName.isDropletInstanceOfCloud(droplet.getName(), this.name)) continue;
            ++count;
        }
        return count >= Math.min(this.instanceCap, this.getSlaveInstanceCap());
    }

    private int getSlaveInstanceCap() {
        int slaveTotalInstanceCap = 0;
        for (SlaveTemplate slaveTemplate : this.templates) {
            int slaveInstanceCap = slaveTemplate.getInstanceCap();
            if (slaveInstanceCap == 0) {
                slaveTotalInstanceCap = Integer.MAX_VALUE;
                break;
            }
            slaveTotalInstanceCap += slaveTemplate.getInstanceCap();
        }
        return slaveTotalInstanceCap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        Object object = provisionSynchronizor;
        synchronized (object) {
            String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(this.authTokenCredentialId);
            String privateKey = DigitalOceanCloud.getPrivateKeyFromCredentialId(this.privateKeyCredentialId);
            ArrayList<NodeProvisioner.PlannedNode> provisioningNodes = new ArrayList<NodeProvisioner.PlannedNode>();
            try {
                while (excessWorkload > 0) {
                    List<Droplet> droplets = DigitalOcean.getDroplets(authToken);
                    if (this.isInstanceCapReachedLocal() || this.isInstanceCapReachedRemote(droplets)) {
                        LOGGER.log(Level.INFO, "Instance cap reached, not provisioning.");
                        break;
                    }
                    SlaveTemplate template = this.getTemplateBelowInstanceCap(droplets, label);
                    if (template == null) break;
                    String dropletName = DropletName.generateDropletName(this.name, template.getName());
                    ProvisioningActivity.Id provisioningId = new ProvisioningActivity.Id(this.name, template.getName(), dropletName);
                    provisioningNodes.add((NodeProvisioner.PlannedNode)new TrackedPlannedNode(provisioningId, template.getNumExecutors(), Computer.threadPoolForRemoting.submit(() -> {
                        Slave slave;
                        Object object = provisionSynchronizor;
                        synchronized (object) {
                            List<Droplet> droplets1 = DigitalOcean.getDroplets(authToken);
                            if (this.isInstanceCapReachedLocal() || this.isInstanceCapReachedRemote(droplets1)) {
                                LOGGER.log(Level.INFO, "Instance cap reached, not provisioning.");
                                return null;
                            }
                            slave = template.provision(provisioningId, dropletName, this.name, authToken, privateKey, this.sshKeyId, droplets1, this.usePrivateNetworking);
                            Jenkins.get().addNode((Node)slave);
                        }
                        slave.toComputer().connect(false).get();
                        return slave;
                    })));
                    excessWorkload -= template.getNumExecutors();
                }
                LOGGER.info("Provisioning " + provisioningNodes.size() + " DigitalOcean nodes");
                return provisioningNodes;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
                return Collections.emptyList();
            }
        }
    }

    public boolean canProvision(Label label) {
        boolean can = !this.getTemplates(label).isEmpty();
        LOGGER.log(Level.INFO, "canProvision " + String.valueOf(label) + " :: " + can);
        return can;
    }

    private List<SlaveTemplate> getTemplates(Label label) {
        ArrayList<SlaveTemplate> matchingTemplates = new ArrayList<SlaveTemplate>();
        for (SlaveTemplate slaveTemplate : this.templates) {
            if (!(label == null && slaveTemplate.getLabelSet().size() == 0 || label == null && slaveTemplate.isLabellessJobsAllowed()) && (label == null || !label.matches(slaveTemplate.getLabelSet()))) continue;
            matchingTemplates.add(slaveTemplate);
        }
        return matchingTemplates;
    }

    private SlaveTemplate getTemplateBelowInstanceCap(List<Droplet> droplets, Label label) {
        List<SlaveTemplate> matchingTemplates = this.getTemplates(label);
        try {
            for (SlaveTemplate t : matchingTemplates) {
                if (t.isInstanceCapReachedLocal(this.name) || t.isInstanceCapReachedRemote(droplets, this.name)) continue;
                return t;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return null;
    }

    private SlaveTemplate getTemplateBelowInstanceCapLocal(Label label) {
        List<SlaveTemplate> matchingTemplates = this.getTemplates(label);
        try {
            for (SlaveTemplate t : matchingTemplates) {
                if (t.isInstanceCapReachedLocal(this.name)) continue;
                return t;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public static String getAuthTokenFromCredentialId(String credentialId) {
        if (StringUtils.isBlank((CharSequence)credentialId)) {
            return null;
        }
        StringCredentials cred = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        if (cred == null) {
            return null;
        }
        return cred.getSecret().getPlainText();
    }

    public static String getPrivateKeyFromCredentialId(String credentialId) {
        if (StringUtils.isBlank((CharSequence)credentialId)) {
            return null;
        }
        SSHUserPrivateKey cred = (SSHUserPrivateKey)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(SSHUserPrivateKey.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        if (cred == null) {
            return null;
        }
        return (String)cred.getPrivateKeys().stream().findFirst().get();
    }

    public int getSshKeyId() {
        return this.sshKeyId;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public DigitalOceanClient getApiClient() {
        String authToken = DigitalOceanCloud.getAuthTokenFromCredentialId(this.authTokenCredentialId);
        return new DigitalOceanClient(authToken);
    }

    public List<SlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public Integer getTimeoutMinutes() {
        return this.timeoutMinutes;
    }

    public Integer getConnectionRetryWait() {
        return this.connectionRetryWait;
    }

    public Boolean getUsePrivateNetworking() {
        return this.usePrivateNetworking;
    }

    public static String migratePrivateSshKeyToCredential(String displayName, final String privateKey) {
        Optional<SSHUserPrivateKey> keyCredential = SystemCredentialsProvider.getInstance().getCredentials().stream().filter(cred -> cred instanceof SSHUserPrivateKey).filter(cred -> ((SSHUserPrivateKey)cred).getPrivateKeys().contains(privateKey.trim())).map(cred -> (SSHUserPrivateKey)cred).findFirst();
        if (keyCredential.isPresent()) {
            return keyCredential.get().getId();
        }
        String credsId = UUID.randomUUID().toString();
        BasicSSHUserPrivateKey sshKeyCredentials = new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, credsId, "key", new BasicSSHUserPrivateKey.PrivateKeySource(){

            @NonNull
            public List<String> getPrivateKeys() {
                return Collections.singletonList(privateKey.trim());
            }
        }, "", "DigitalOcean Cloud Private Key - " + displayName);
        DigitalOceanCloud.addNewGlobalCredential((Credentials)sshKeyCredentials);
        return credsId;
    }

    public static String migrateAuthTokenToCredential(String displayName, String authToken) {
        SystemCredentialsProvider systemCredentialsProvider = SystemCredentialsProvider.getInstance();
        for (Credentials credentials : systemCredentialsProvider.getCredentials()) {
            StringCredentials doCreds;
            if (!(credentials instanceof StringCredentials) || !authToken.equals(Secret.toString((Secret)(doCreds = (StringCredentials)credentials).getSecret()))) continue;
            return doCreds.getId();
        }
        String credsId = UUID.randomUUID().toString();
        DigitalOceanCloud.addNewGlobalCredential((Credentials)new StringCredentialsImpl(CredentialsScope.SYSTEM, credsId, "Digitalocean Auth Token - " + displayName, Secret.fromString((String)authToken)));
        return credsId;
    }

    protected Object readResolve() {
        if (this.privateKey != null) {
            this.privateKeyCredentialId = DigitalOceanCloud.migratePrivateSshKeyToCredential(this.getDisplayName(), this.privateKey);
        }
        this.privateKey = null;
        if (this.authToken != null) {
            this.authTokenCredentialId = DigitalOceanCloud.migrateAuthTokenToCredential(this.getDisplayName(), this.authToken);
        }
        this.authToken = null;
        return this;
    }

    private static void addNewGlobalCredential(Credentials credentials) {
        for (CredentialsStore credentialsStore : CredentialsProvider.lookupStores((ModelObject)Jenkins.get())) {
            if (!(credentialsStore instanceof SystemCredentialsProvider.StoreImpl)) continue;
            try {
                credentialsStore.addCredentials(Domain.global(), credentials);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Exception converting legacy configuration to the new credentials API", e);
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<Cloud> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Digital Ocean";
        }

        public FormValidation doTestConnection(@QueryParameter String authTokenCredentialId) {
            try {
                DigitalOceanClient client = new DigitalOceanClient(DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId));
                client.getAvailableDroplets(Integer.valueOf(1), Integer.valueOf(10));
                return FormValidation.ok((String)"Digital Ocean API request succeeded.");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to connect to DigitalOcean API", e);
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (Strings.isNullOrEmpty((String)name)) {
                return FormValidation.error((String)"Must be set");
            }
            if (!DropletName.isValidCloudName(name)) {
                return FormValidation.error((String)"Must consist of A-Z, a-z, 0-9 and . symbols");
            }
            return FormValidation.ok();
        }

        public static FormValidation doCheckAuthToken(@QueryParameter String authToken) {
            if (Strings.isNullOrEmpty((String)authToken)) {
                return FormValidation.error((String)"Auth token must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPrivateKey(@QueryParameter String value) throws IOException {
            String line;
            boolean hasStart = false;
            boolean hasEnd = false;
            BufferedReader br = new BufferedReader(new StringReader(value));
            while ((line = br.readLine()) != null) {
                if (line.equals("-----BEGIN RSA PRIVATE KEY-----")) {
                    hasStart = true;
                }
                if (!line.equals("-----END RSA PRIVATE KEY-----")) continue;
                hasEnd = true;
            }
            if (!hasStart) {
                return FormValidation.error((String)"This doesn't look like a private key at all");
            }
            if (!hasEnd) {
                return FormValidation.error((String)"The private key is missing the trailing 'END RSA PRIVATE KEY' marker. Copy&paste error?");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckSshKeyId(@QueryParameter String authTokenCredentialId) {
            return DescriptorImpl.doCheckAuthToken(DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId));
        }

        public FormValidation doCheckInstanceCap(@QueryParameter String instanceCap) {
            int instanceCapNumber;
            if (Strings.isNullOrEmpty((String)instanceCap)) {
                return FormValidation.error((String)"Instance cap must be set");
            }
            try {
                instanceCapNumber = Integer.parseInt(instanceCap);
            }
            catch (Exception e) {
                return FormValidation.error((String)"Instance cap must be a number");
            }
            if (instanceCapNumber < 0) {
                return FormValidation.error((String)"Instance cap must be a positive number");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillSshKeyIdItems(@QueryParameter String authTokenCredentialId) throws RequestUnsuccessfulException, DigitalOceanException {
            ListBoxModel model = new ListBoxModel();
            if (Strings.isNullOrEmpty((String)authTokenCredentialId)) {
                return model;
            }
            List<Key> availableSizes = DigitalOcean.getAvailableKeys(DigitalOceanCloud.getAuthTokenFromCredentialId(authTokenCredentialId));
            for (Key key : availableSizes) {
                model.add(key.getName() + " (" + key.getFingerprint() + ")", key.getId().toString());
            }
            return model;
        }

        public ListBoxModel doFillPrivateKeyCredentialIdItems(@QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(Jenkins.getAuthentication2(), (ItemGroup)Jenkins.get(), SSHUserPrivateKey.class, Collections.emptyList(), CredentialsMatchers.always()).includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), SSHUserPrivateKey.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }

        public ListBoxModel doFillAuthTokenCredentialIdItems(@QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue().includeMatchingAs(Jenkins.getAuthentication2(), (ItemGroup)Jenkins.get(), StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StringCredentials.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(credentialsId);
        }
    }

    public static final class ConverterImpl
    extends XStream2.PassthruConverter<DigitalOceanCloud> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        public boolean canConvert(Class type) {
            return type == DigitalOceanCloud.class;
        }

        protected void callback(DigitalOceanCloud obj, UnmarshallingContext context) {
            if (null == obj.connectionRetryWait) {
                obj.connectionRetryWait = 10;
            }
            if (null == obj.usePrivateNetworking) {
                obj.usePrivateNetworking = false;
            }
        }
    }
}

