/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.DockerLabelAssignmentAction;
import com.cloudbees.jenkins.plugins.dockerslaves.DockerSlave;
import com.cloudbees.jenkins.plugins.dockerslaves.DockerSlaves;
import com.cloudbees.jenkins.plugins.dockerslaves.JobBuildsContainersDefinition;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.QueueListener;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class ProvisionQueueListener
extends QueueListener {
    private static final Logger LOGGER = Logger.getLogger(ProvisionQueueListener.class.getName());

    public void onEnterBuildable(Queue.BuildableItem bi) {
        if (bi.task instanceof AbstractProject) {
            AbstractProject job = (AbstractProject)bi.task;
            JobBuildsContainersDefinition def = (JobBuildsContainersDefinition)job.getProperty(JobBuildsContainersDefinition.class);
            if (def == null) {
                return;
            }
            try {
                DockerSlaves cloud = DockerSlaves.get();
                LOGGER.info("Creating a Container slave to host " + job.toString() + "#" + job.getNextBuildNumber());
                DockerLabelAssignmentAction action = cloud.createLabelAssignmentAction(bi);
                bi.addAction((Action)action);
                DockerSlave node = new DockerSlave((Job)job, action.getLabel().toString());
                Computer.threadPoolForRemoting.submit(new Runnable((Node)node){
                    final /* synthetic */ Node val$node;
                    {
                        this.val$node = node;
                    }

                    @Override
                    public void run() {
                        try {
                            Jenkins.getInstance().addNode(this.val$node);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Descriptor.FormException e) {
                e.printStackTrace();
            }
        }
    }
}

