/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.ContainerDefinition;
import com.cloudbees.jenkins.plugins.dockerslaves.SideContainerDefinition;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import java.util.List;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class JobBuildsContainersDefinition
extends JobProperty {
    private final ContainerDefinition buildHostImage;
    private final List<SideContainerDefinition> sideContainers;

    @DataBoundConstructor
    public JobBuildsContainersDefinition(ContainerDefinition buildHostImage, List<SideContainerDefinition> sideContainers) {
        this.buildHostImage = buildHostImage;
        this.sideContainers = sideContainers;
    }

    public ContainerDefinition getBuildHostImage() {
        return this.buildHostImage;
    }

    public List<SideContainerDefinition> getSideContainers() {
        return this.sideContainers;
    }

    @Extension
    public static class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean isApplicable(Class<? extends Job> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Containers to host the build";
        }

        public JobProperty<?> newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.isNullObject()) {
                return null;
            }
            JSONObject containersDefinition = formData.getJSONObject("containersDefinition");
            if (containersDefinition.isNullObject()) {
                return null;
            }
            return (JobProperty)req.bindJSON(JobBuildsContainersDefinition.class, containersDefinition);
        }
    }
}

