/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.ContainerDefinition;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;

public class ImageIdContainerDefinition
extends ContainerDefinition {
    private final String image;
    private final boolean forcePull;

    @DataBoundConstructor
    public ImageIdContainerDefinition(String image, boolean forcePull) {
        this.image = image;
        this.forcePull = forcePull;
    }

    @Override
    public String getImage(Launcher.ProcStarter procStarter, TaskListener listener) throws IOException, InterruptedException {
        if (this.forcePull) {
            Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
            int status = launcher.launch().cmds(new String[]{"docker", "pull", this.image}).join();
            if (status != 0) {
                throw new IOException("Failed to pull image " + this.image);
            }
        }
        return this.image;
    }

    @Extension(ordinal=99.0)
    public static class DescriptorImpl
    extends Descriptor<ContainerDefinition> {
        public String getDisplayName() {
            return "Docker image";
        }
    }
}

