/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.ContainerDefinition;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class DockerfileContainerDefinition
extends ContainerDefinition {
    private final String dockerfile;
    private final String contextPath;
    private transient String image;
    private static MasterToSlaveFileCallable<byte[]> FILECONTENT = new MasterToSlaveFileCallable<byte[]>(){

        public byte[] invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            return FileUtils.readFileToByteArray((File)f);
        }
    };

    @DataBoundConstructor
    public DockerfileContainerDefinition(String contextPath, String dockerfile) {
        this.contextPath = contextPath;
        this.dockerfile = dockerfile;
    }

    public String getDockerfile() {
        return this.dockerfile;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getImage(Launcher.ProcStarter procStarter, TaskListener listener) throws IOException, InterruptedException {
        if (this.image != null) {
            return this.image;
        }
        String tag = Long.toHexString(System.nanoTime());
        FilePath workspace = procStarter.pwd();
        FilePath contextRoot = workspace.child(this.contextPath);
        File context = Util.createTempDir();
        contextRoot.child(this.contextPath).copyRecursiveTo(new FilePath(context));
        contextRoot.child(this.dockerfile).copyTo(new FilePath(new File(context, "Dockerfile")));
        Launcher.LocalLauncher launcher = new Launcher.LocalLauncher(listener);
        int status = launcher.launch().cmds(new String[]{"docker", "build", "-t", tag, context.getAbsolutePath()}).stdout(listener).join();
        if (status != 0) {
            throw new IOException("Failed to build image from Dockerfile " + this.dockerfile);
        }
        Util.deleteRecursive((File)context);
        this.image = tag;
        return tag;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ContainerDefinition> {
        public String getDisplayName() {
            return "Build Dockerfile";
        }
    }
}

