/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.DockerJobContainersProvisioner;
import com.cloudbees.jenkins.plugins.dockerslaves.DockerLabelAssignmentAction;
import hudson.Extension;
import hudson.Plugin;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Queue;
import hudson.model.TaskListener;
import java.io.IOException;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class DockerSlaves
extends Plugin
implements Describable<DockerSlaves> {
    private String defaultBuildContainerImageName;
    private String scmContainerImageName;
    private final String remotingContainerImageName = System.getProperty("com.cloudbees.jenkins.plugins.containerslaves.DockerSlaves.image", "jenkinsci/slave");
    private DockerServerEndpoint dockerHost;

    public void start() throws IOException {
        this.load();
    }

    public void configure(StaplerRequest req, JSONObject formData) throws IOException, ServletException, Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        this.save();
    }

    public String getDefaultBuildContainerImageName() {
        return this.defaultBuildContainerImageName;
    }

    public String getScmContainerImageName() {
        return StringUtils.isBlank((String)this.scmContainerImageName) ? "buildpack-deps:scm" : this.scmContainerImageName;
    }

    public String getRemotingContainerImageName() {
        return StringUtils.isBlank((String)this.remotingContainerImageName) ? "jenkinsci/slave" : this.remotingContainerImageName;
    }

    public DockerServerEndpoint getDockerHost() {
        return this.dockerHost;
    }

    @DataBoundSetter
    public void setDefaultBuildContainerImageName(String defaultBuildContainerImageName) {
        this.defaultBuildContainerImageName = defaultBuildContainerImageName;
    }

    public void setScmContainerImageName(String scmContainerImageName) {
        this.scmContainerImageName = scmContainerImageName;
    }

    @DataBoundSetter
    public void setDockerHost(DockerServerEndpoint dockerHost) {
        this.dockerHost = dockerHost;
    }

    public DockerLabelAssignmentAction createLabelAssignmentAction(Queue.BuildableItem bi) {
        String id = Long.toHexString(System.nanoTime());
        Label label = Label.get((String)("docker_" + id));
        return new DockerLabelAssignmentAction(label);
    }

    public DockerJobContainersProvisioner buildProvisioner(Job job, TaskListener slaveListener) throws IOException, InterruptedException {
        return new DockerJobContainersProvisioner(job, this.dockerHost, slaveListener, this.remotingContainerImageName, this.scmContainerImageName);
    }

    public static DockerSlaves get() {
        return (DockerSlaves)Jenkins.getInstance().getPlugin(DockerSlaves.class);
    }

    public Descriptor<DockerSlaves> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(DockerSlaves.class);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<DockerSlaves> {
        public String getDisplayName() {
            return "Docker Slaves";
        }
    }
}

