/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.DockerComputer;
import com.cloudbees.jenkins.plugins.dockerslaves.DockerComputerLauncher;
import com.cloudbees.jenkins.plugins.dockerslaves.DockerLauncher;
import com.cloudbees.jenkins.plugins.dockerslaves.JobBuildsContainersContext;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Environment;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.remoting.VirtualChannel;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EphemeralNode;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Collections;

public class DockerSlave
extends AbstractCloudSlave
implements EphemeralNode {
    private final Job job;

    public DockerSlave(Job job, String labelString) throws Descriptor.FormException, IOException {
        super("Container for " + job.getName() + "#" + job.getNextBuildNumber(), "Container slave for building " + job.getFullName(), "/home/jenkins", 1, Node.Mode.EXCLUSIVE, labelString, (ComputerLauncher)new DockerComputerLauncher(), RetentionStrategy.NOOP, Collections.emptyList());
        this.job = job;
    }

    public DockerComputer createComputer() {
        return new DockerComputer(this, this.job);
    }

    public Job getJob() {
        return this.job;
    }

    protected void _terminate(TaskListener listener) throws IOException, InterruptedException {
    }

    public Node asNode() {
        return this;
    }

    public Launcher createLauncher(TaskListener listener) {
        SlaveComputer c = this.getComputer();
        if (c == null) {
            listener.error("Issue with creating launcher for slave " + this.name + ".");
            throw new IllegalStateException("Can't create a launcher if computer is gone.");
        }
        DockerComputer dc = (DockerComputer)c;
        return new DockerLauncher(listener, (VirtualChannel)c.getChannel(), c.isUnix(), dc.getProvisioner()).decorateFor((Node)this);
    }

    @Extension
    public static class DockerSlaveSCMListener
    extends SCMListener {
        public void onChangeLogParsed(Run<?, ?> build, SCM scm, TaskListener listener, ChangeLogSet<?> changelog) throws Exception {
            JobBuildsContainersContext action = (JobBuildsContainersContext)build.getAction(JobBuildsContainersContext.class);
            if (action != null) {
                action.onScmChekoutCompleted();
            }
        }
    }

    @Extension
    public static class DockerSlaveRunListener
    extends RunListener<AbstractBuild> {
        public Environment setUpEnvironment(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, Run.RunnerAbortedException {
            Computer c = Computer.currentComputer();
            if (c instanceof DockerComputer) {
                build.addAction((Action)((DockerComputer)c).getProvisioner().getContext());
            }
            return new Environment(){};
        }
    }
}

