/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.DockerJobContainersProvisioner;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.logging.Logger;

public class DockerLauncher
extends Launcher.DecoratedLauncher {
    private static final Logger LOGGER = Logger.getLogger(DockerLauncher.class.getName());
    private final DockerJobContainersProvisioner provisioner;
    private final Launcher localLauncher;

    public DockerLauncher(TaskListener listener, VirtualChannel channel, boolean isUnix, DockerJobContainersProvisioner provisioner) {
        super((Launcher)new Launcher.RemoteLauncher(listener, channel, isUnix));
        this.provisioner = provisioner;
        this.localLauncher = new Launcher.LocalLauncher(listener);
    }

    public Proc launch(Launcher.ProcStarter starter) throws IOException {
        try {
            DockerJobContainersProvisioner.BuildContainer buildContainer = this.provisioner.newBuildContainer(starter, this.listener);
            if (!starter.quiet()) {
                this.listener.getLogger().append("docker: creating build container from image '" + buildContainer.getImageName() + "'\n");
            }
            this.provisioner.createBuildContainer(buildContainer);
            if (!starter.quiet()) {
                this.listener.getLogger().append("docker: starting build container " + buildContainer.getId().substring(0, 11) + "\n");
                this.maskedPrintCommandLine(starter.cmds(), starter.masks(), starter.pwd());
            }
            return this.provisioner.startBuildContainer(buildContainer);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

