/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.ContainerInstance;
import com.cloudbees.jenkins.plugins.dockerslaves.DockerComputer;
import com.cloudbees.jenkins.plugins.dockerslaves.DockerDriver;
import com.cloudbees.jenkins.plugins.dockerslaves.JobBuildsContainersContext;
import com.cloudbees.jenkins.plugins.dockerslaves.JobBuildsContainersDefinition;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.slaves.CommandLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;

public class DockerJobContainersProvisioner {
    private final JobBuildsContainersContext context;
    private final TaskListener slaveListener;
    private final DockerDriver driver;
    private final Launcher localLauncher;
    private final JobBuildsContainersDefinition spec;
    private final String remotingImage;
    private final String scmImage;
    private String buildImage;

    public DockerJobContainersProvisioner(Job job, DockerServerEndpoint dockerHost, TaskListener slaveListener, String remotingImage, String scmImage) throws IOException, InterruptedException {
        JobBuildsContainersContext previousContext;
        this.slaveListener = slaveListener;
        this.driver = new DockerDriver(dockerHost, (Item)job);
        this.localLauncher = new Launcher.LocalLauncher(slaveListener);
        this.spec = (JobBuildsContainersDefinition)job.getProperty(JobBuildsContainersDefinition.class);
        this.remotingImage = remotingImage;
        this.scmImage = scmImage;
        this.context = new JobBuildsContainersContext();
        Run lastBuild = job.getBuilds().getLastBuild();
        if (lastBuild != null && (previousContext = (JobBuildsContainersContext)lastBuild.getAction(JobBuildsContainersContext.class)) != null && previousContext.getRemotingContainer() != null) {
            this.context.setRemotingContainer(previousContext.getRemotingContainer());
        }
    }

    public JobBuildsContainersContext getContext() {
        return this.context;
    }

    public void prepareRemotingContainer() throws IOException, InterruptedException {
        if (this.context.getRemotingContainer() != null && this.driver.hasContainer(this.localLauncher, this.context.getRemotingContainer().getId())) {
            return;
        }
        ContainerInstance remotingContainer = this.driver.createRemotingContainer(this.localLauncher, this.remotingImage);
        this.context.setRemotingContainer(remotingContainer);
    }

    public void launchRemotingContainer(SlaveComputer computer, TaskListener listener) {
        CommandLauncher launcher = new CommandLauncher("docker start -ia " + this.context.getRemotingContainer().getId());
        launcher.launch(computer, listener);
    }

    public BuildContainer newBuildContainer(Launcher.ProcStarter procStarter, TaskListener listener) throws IOException, InterruptedException {
        if (this.context.isPreScm()) {
            return this.newBuildContainer(procStarter, this.scmImage);
        }
        if (this.buildImage == null) {
            this.buildImage = this.spec.getBuildHostImage().getImage(procStarter, listener);
        }
        return this.newBuildContainer(procStarter, this.buildImage);
    }

    private BuildContainer newBuildContainer(Launcher.ProcStarter procStarter, String buildImage) {
        ContainerInstance c = new ContainerInstance(this.context.isPreScm() ? this.scmImage : buildImage);
        this.context.getBuildContainers().add(c);
        return new BuildContainer(c, procStarter);
    }

    public void createBuildContainer(BuildContainer buildContainer) throws IOException, InterruptedException {
        this.driver.createBuildContainer(this.localLauncher, buildContainer.instance, this.context.getRemotingContainer(), buildContainer.procStarter);
    }

    public Proc startBuildContainer(BuildContainer buildContainer) throws IOException, InterruptedException {
        return this.driver.startContainer(this.localLauncher, buildContainer.instance.getId(), buildContainer.procStarter.stdout());
    }

    public void launchSideContainers(DockerComputer computer, TaskListener listener) throws IOException, InterruptedException {
        for (ContainerInstance instance : this.context.getSideContainers()) {
            this.driver.launchSideContainer(this.localLauncher, instance, this.context.getRemotingContainer());
        }
    }

    public void clean() throws IOException, InterruptedException {
        for (ContainerInstance instance : this.context.getSideContainers()) {
            this.driver.removeContainer(this.localLauncher, instance);
        }
        for (ContainerInstance instance : this.context.getBuildContainers()) {
            this.driver.removeContainer(this.localLauncher, instance);
        }
        this.driver.close();
    }

    public class BuildContainer {
        final ContainerInstance instance;
        final Launcher.ProcStarter procStarter;

        protected BuildContainer(ContainerInstance instance, Launcher.ProcStarter procStarter) {
            this.instance = instance;
            this.procStarter = procStarter;
        }

        public String getId() {
            return this.instance.getId();
        }

        public String getImageName() {
            return this.instance.getImageName();
        }
    }
}

