/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.ContainerInstance;
import com.cloudbees.jenkins.plugins.dockerslaves.ProvisionQueueListener;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Item;
import hudson.model.Slave;
import hudson.org.apache.tools.tar.TarOutputStream;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;

public class DockerDriver
implements Closeable {
    private final boolean verbose;
    final DockerServerEndpoint dockerHost;
    final KeyMaterial dockerEnv;
    private static final Logger LOGGER = Logger.getLogger(ProvisionQueueListener.class.getName());

    public DockerDriver(DockerServerEndpoint dockerHost, Item context) throws IOException, InterruptedException {
        this.dockerHost = dockerHost;
        this.dockerEnv = dockerHost.newKeyMaterialFactory(context, Jenkins.getInstance().getChannel()).materialize();
        this.verbose = true;
    }

    @Override
    public void close() throws IOException {
        this.dockerEnv.close();
    }

    public boolean hasContainer(Launcher launcher, String id) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)id)) {
            return false;
        }
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"inspect", "-f", "'{{.Id}}'", id});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int status = this.launchDockerCLI(launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        return status == 0;
    }

    public ContainerInstance createRemotingContainer(Launcher launcher, String image) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"create", "--interactive"}).add("--log-driver=none").add(new String[]{"--env", "TMPDIR=/home/jenkins/.tmp"}).add(image).add("java").add("-Djava.io.tmpdir=/home/jenkins/.tmp").add("-jar").add("/home/jenkins/slave.jar");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int status = this.launchDockerCLI(launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        String containerId = out.toString("UTF-8").trim();
        if (status != 0) {
            throw new IOException("Failed to run docker image");
        }
        this.putFileContent(launcher, containerId, "/home/jenkins", "slave.jar", new Slave.JnlpJar("slave.jar").readFully());
        return new ContainerInstance(image, containerId);
    }

    public void createBuildContainer(Launcher launcher, ContainerInstance buildContainer, ContainerInstance remotingContainer, Launcher.ProcStarter starter) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add("create").add(new String[]{"--env", "TMPDIR=/home/jenkins/.tmp"}).add(new String[]{"--workdir", starter.pwd().getRemote()}).add(new String[]{"--volumes-from", remotingContainer.getId()}).add("--net=container:" + remotingContainer.getId()).add(new String[]{"--user", "10000:10000"});
        for (String env : starter.envs()) {
            args.add(new String[]{"--env", env});
        }
        args.add(buildContainer.getImageName());
        List originalCmds = starter.cmds();
        boolean[] originalMask = starter.masks();
        for (int i = 0; i < originalCmds.size(); ++i) {
            boolean masked = originalMask == null ? false : (i < originalMask.length ? originalMask[i] : false);
            args.add((String)originalCmds.get(i), masked);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int status = this.launchDockerCLI(launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        String containerId = out.toString("UTF-8").trim();
        buildContainer.setId(containerId);
        if (status != 0) {
            throw new IOException("Failed to run docker image");
        }
        this.injectJenkinsUnixGroup(launcher, containerId);
        this.injectJenkinsUnixUser(launcher, containerId);
    }

    protected void injectJenkinsUnixGroup(Launcher launcher, String containerId) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getFileContent(launcher, containerId, "/etc/group", out);
        out.write("jenkins:x:10000:\n".getBytes());
        this.putFileContent(launcher, containerId, "/etc", "group", out.toByteArray());
    }

    protected void injectJenkinsUnixUser(Launcher launcher, String containerId) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getFileContent(launcher, containerId, "/etc/passwd", out);
        out.write("jenkins:x:10000:10000::/home/jenkins:/bin/false\n".getBytes());
        this.putFileContent(launcher, containerId, "/etc", "passwd", out.toByteArray());
    }

    protected void getFileContent(Launcher launcher, String containerId, String filename, OutputStream outputStream) throws IOException, InterruptedException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"cp", containerId + ":" + filename, "-"});
        int status = this.launchDockerCLI(launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        if (status != 0) {
            throw new IOException("Failed to get file");
        }
        TarInputStream tar = new TarInputStream((InputStream)new ByteArrayInputStream(out.toByteArray()));
        TarEntry entry = tar.getNextEntry();
        tar.copyEntryContents(outputStream);
        tar.close();
    }

    protected int putFileContent(Launcher launcher, String containerId, String path, String filename, byte[] content) throws IOException, InterruptedException {
        TarEntry entry = new TarEntry(filename);
        entry.setUserId(0);
        entry.setGroupId(0);
        entry.setSize((long)content.length);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TarOutputStream tar = new TarOutputStream((OutputStream)out);
        tar.putNextEntry(entry);
        tar.write(content);
        tar.closeEntry();
        tar.close();
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"cp", "-", containerId + ":" + path});
        return this.launchDockerCLI(launcher, args).stdin((InputStream)new ByteArrayInputStream(out.toByteArray())).stderr((OutputStream)launcher.getListener().getLogger()).join();
    }

    public Proc startContainer(Launcher launcher, String containerId, OutputStream outputStream) throws IOException, InterruptedException {
        return this.launchDockerCLI(launcher, new ArgumentListBuilder().add(new String[]{"start", "-ia", containerId})).stdout(outputStream).start();
    }

    public int removeContainer(Launcher launcher, ContainerInstance instance) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add(new String[]{"rm", "-f", instance.getId()});
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int status = this.launchDockerCLI(launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        return status;
    }

    public void launchSideContainer(Launcher launcher, ContainerInstance instance, ContainerInstance remotingContainer) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder().add("create").add(new String[]{"--volumes-from", remotingContainer.getId()}).add("--net=container:" + remotingContainer.getId()).add(instance.getImageName());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int status = this.launchDockerCLI(launcher, args).stdout((OutputStream)out).stderr((OutputStream)launcher.getListener().getLogger()).join();
        String containerId = out.toString("UTF-8").trim();
        instance.setId(containerId);
        if (status != 0) {
            throw new IOException("Failed to run docker image");
        }
        this.launchDockerCLI(launcher, new ArgumentListBuilder().add(new String[]{"start", containerId})).start();
    }

    private Launcher.ProcStarter launchDockerCLI(Launcher launcher, ArgumentListBuilder args) {
        if (this.dockerHost.getUri() != null) {
            args.prepend(new String[]{"-H", this.dockerHost.getUri()});
        }
        args.prepend(new String[]{"docker"});
        return launcher.launch().envs((Map)this.dockerEnv.env()).cmds(args).quiet(!this.verbose);
    }
}

