/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.dockerslaves;

import com.cloudbees.jenkins.plugins.dockerslaves.DockerJobContainersProvisioner;
import com.cloudbees.jenkins.plugins.dockerslaves.DockerSlave;
import com.cloudbees.jenkins.plugins.dockerslaves.DockerSlaves;
import hudson.model.Executor;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import java.io.IOException;
import java.util.logging.Logger;

public class DockerComputer
extends AbstractCloudComputer<DockerSlave> {
    private final Job job;
    private DockerJobContainersProvisioner provisioner;
    private static final Logger LOGGER = Logger.getLogger(DockerComputer.class.getName());

    public DockerComputer(DockerSlave dockerSlave, Job job) {
        super((AbstractCloudSlave)dockerSlave);
        this.job = job;
    }

    public DockerJobContainersProvisioner createProvisioner(TaskListener slaveListener) throws IOException, InterruptedException {
        this.provisioner = DockerSlaves.get().buildProvisioner(this.job, slaveListener);
        return this.provisioner;
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        super.taskCompleted(executor, task, durationMS);
        this.terminate();
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        super.taskCompletedWithProblems(executor, task, durationMS, problems);
        this.terminate();
    }

    private void terminate() {
        LOGGER.info("Stopping Docker Slave after build completion");
        this.setAcceptingTasks(false);
        try {
            if (!Boolean.getBoolean("com.cloudbees.jenkins.plugins.containerslaves.DockerComputer.keepContainer")) {
                this.provisioner.clean();
                ((DockerSlave)this.getNode()).terminate();
            }
        }
        catch (InterruptedException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Job getJob() {
        return this.job;
    }

    public DockerJobContainersProvisioner getProvisioner() {
        return this.provisioner;
    }
}

