/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.AbstractGroovyCpsTest;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.impl.FunctionCallBlock;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class TryCatchBlockTest
extends AbstractGroovyCpsTest {
    @Test
    public void stackTraceFixup() throws Throwable {
        List<StackTraceElement> elements = List.of((StackTraceElement[])this.evalCPSonly("\n\ndef x() {\n  y();\n}\n\ndef y() {\n  throw new javax.naming.NamingException();\n}\ntry {\n  x();\n} catch (Exception e) {\n  return e.stackTrace;\n}\n"));
        MatcherAssert.assertThat(elements.subList(0, 3).stream().map(Object::toString).collect(Collectors.toList()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"Script1.y(Script1.groovy:8)", "Script1.x(Script1.groovy:4)", "Script1.run(Script1.groovy:11)"}));
        MatcherAssert.assertThat((Object)elements.get(3), (Matcher)CoreMatchers.equalTo((Object)Continuable.SEPARATOR_STACK_ELEMENT));
        List rest = elements.subList(4, elements.size()).stream().map(Object::toString).collect(Collectors.toList());
        MatcherAssert.assertThat(rest, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.containsString((String)FunctionCallBlock.class.getName())));
        MatcherAssert.assertThat(rest, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.containsString((String)"java.lang.reflect.Constructor.newInstance")));
    }

    @Test
    public void tryAndFinally_NormalCompletion() throws Throwable {
        this.assertEvaluate("13", "a = '';\ntry {\n    a += '1';\n} catch (Exception e) {\n    a += '2';\n} finally {\n    a += '3';\n}\nreturn a;\n");
    }

    @Test
    public void tryWithoutFinally_NormalCompletion() throws Throwable {
        this.assertEvaluate("1", "a = '';\ntry {\n    a += '1';\n} catch (Exception e) {\n    a += '2';\n}\nreturn a;\n");
    }

    @Test
    public void tryAndFinally_AbnormalTermination() throws Throwable {
        this.assertEvaluate("1foo23", "a = '';\ntry {\n    a += '1';\n    throw new Exception('foo');\n    a += '2';\n} catch (Exception e) {\n    a += e.message + '2';\n} finally {\n    a += '3';\n}\nreturn a;\n");
    }

    @Test
    public void tryAndFinally_BreakInside() throws Throwable {
        this.assertEvaluate("014", "a = '';\nwhile (true) {\n    a += '0'\n    try {\n        a += '1';\n        break;\n        a += '2';\n    } catch (Exception e) {\n        a += '3';\n    } finally {\n        a += '4';\n    }\n    a += '5';\n}\nreturn a;\n");
    }

    @Test
    public void tryAndFinally_ContinueInside() throws Throwable {
        this.assertEvaluate("0125125", "a = '';\na += '0'\nfor (int i=0; i<2; i++) {\n    a += '1'\n    try {\n        a += '2';\n        continue;\n        a += '3';\n    } catch (Exception e) {\n        a += '4';\n    } finally {\n        a += '5';\n    }\n    a += '6';\n}\nreturn a;\n");
    }

    @Test
    public void tryAndFinally_RethrowAndFinallyBlock() throws Throwable {
        this.assertEvaluate("135", "a = '';\ntry {\n    try {\n        a += '1';\n        throw new Exception('foo');\n        a += '2';\n    } catch (Exception e) {\n        a += '3';\n        throw new RuntimeException();\n        a += '4';\n    } catch (RuntimeException e) {\n        a += '6';\n    } finally {\n        a += '5';\n    }\n} catch (Exception e) {\n    ;\n}\nreturn a;\n");
    }

    @Test
    public void tryAndFinally_returnFromFinally() throws Throwable {
        this.assertEvaluate("13", "a = '';\ntry {\n    a += '1';\n    throw new Exception('foo');\n    a += '2';\n} finally {\n    a += '3';\n    return a;\n}\n");
    }

    @Test
    public void tryAndFinally_returnFromCatch() throws Throwable {
        this.assertEvaluate("13", "a = '';\ntry {\n    a += '1';\n    throw new Exception('foo');\n    a += '2';\n} catch (Exception e) {\n    a += '3';\n    return a;\n} finally {\n    a += '4';\n}\n");
    }

    @Test
    public void tryAndFinally_returnFromCatch2() throws Throwable {
        Assert.assertEquals((Object)"134", (Object)this.evalCPSonly("a = new StringBuilder();\ntry {\n    a.append('1');\n    throw new Exception('foo');\n    a.append('2');\n} catch (Exception e) {\n    a.append('3');\n    return a;\n} finally {\n    a.append('4');\n}\n").toString());
    }
}

