/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.AbstractGroovyCpsTest;
import javax.naming.NamingException;
import org.junit.Ignore;
import org.junit.Test;

public class SwitchBlockTest
extends AbstractGroovyCpsTest {
    @Test
    public void basic() throws Throwable {
        this.assertEvaluate("two", "def x = 2\ndef y\nswitch (x) {\ncase 1:\n    y = 'one'\n    break\ncase 2:\n    y = 'two'\n    break\ncase 3:\n    y = 'three'\n    break\n}\nreturn y\n");
    }

    @Test
    public void nullSwitchExp() throws Throwable {
        this.assertEvaluate("zero", "def x = null\ndef y = 'zero'\nswitch (x) {\ncase 1:\n    y = 'one'\n    break\ncase 2:\n    y = 'two'\n    break\ncase 3:\n    y = 'three'\n    break\n}\nreturn y\n");
    }

    @Test
    public void nullInCaseExp() throws Throwable {
        this.assertEvaluate("null!", "def x = null\ndef y = 'zero'\nswitch (x) {\ncase 1:\n    y = 'one'\n    break\ncase null:\n    y = 'null!'\n    break\ncase 3:\n    y = 'three'\n    break\n}\nreturn y\n");
    }

    @Test
    public void exceptionInSwitchExp() throws Throwable {
        this.assertEvaluate(NamingException.class, "def foo() {\n    throw new javax.naming.NamingException();\n}\ntry {\n    switch (foo()) {\n    case 1:\n        y = 'one';\n        break;\n    case 2:\n        y = 'two!';\n        break;\n    }\n    return null;\n} catch (e) {\n    return e.class;\n}\n");
    }

    @Test
    public void exceptionInCaseExp() throws Throwable {
        this.assertEvaluate(NamingException.class, "def foo() {\n    throw new javax.naming.NamingException();\n}\ntry {\n    switch (5) {\n    case 1:\n        y = 'one';\n        break;\n    case foo():\n        y = 'two';\n        break;\n    case 3:\n        y = 'three';\n        break;\n    }\n    return null;\n} catch (e) {\n    return e.class;\n}\n");
    }

    @Test
    public void isCase() throws Throwable {
        this.assertEvaluate("odd", "def x = 5;\nswitch (x) {\ncase 1:\n    y = 'one';\n    break;\ncase [2,4,6,8]:\n    y = 'even';\n    break;\ncase [3,5,7,9]:\n    y = 'odd';\n    break;\n}\nreturn y;\n");
    }

    @Test
    public void twoMatchingCases() throws Throwable {
        this.assertEvaluate("two", "def x = 2;\ndef y;\nswitch (x) {\ncase 1:\n    y = 'one';\n    break;\ncase 2:\n    y = 'two';\n    break;\ncase 2:\n    y = 'TWO';\n    break;\ncase 3:\n    y = 'three';\n    break;\n}\nreturn y;\n");
    }

    @Test
    public void defaultClause() throws Throwable {
        this.assertEvaluate("other", "def x = 5;\ndef y;\nswitch (x) {\ncase 1:\n    y = 'one';\n    break;\ndefault:\n    y = 'other';\n    break;\ncase 2:\n    y = 'two';\n    break;\ncase 3:\n    y = 'three';\n    break;\n}\nreturn y;\n");
    }

    @Test
    public void noMatch() throws Throwable {
        this.assertEvaluate("initial", "def x = 5;\ndef y = 'initial';\nswitch (x) {\ncase 1:\n    y = 'one';\n    break;\ncase 2:\n    y = 'two';\n    break;\ncase 3:\n    y = 'three';\n    break;\n}\nreturn y;\n");
    }

    @Test
    public void fallthrough() throws Throwable {
        this.assertEvaluate("onetwothree", "def x = 1;\ndef y = '';\nswitch (x) {\ncase 1:\n    y += 'one';\n    // fall through\ncase 2:\n    y += 'two';\n    // fall through\ncase 3:\n    y += 'three';\n    // fall through\n}\nreturn y;\n");
    }

    @Test
    @Ignore(value="Groovy doesn't handle this correctly")
    public void fallthroughWithDefault() throws Throwable {
        this.assertEvaluate("otheronetwothree", "def x = 9;\ndef y = '';\nswitch (x) {\ndefault:\n    y += 'other';\n    // fall through\ncase 1:\n    y += 'one';\n    // fall through\ncase 2:\n    y += 'two';\n    // fall through\ncase 3:\n    y += 'three';\n    // fall through\n}\nreturn y;\n");
    }
}

