/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.tool;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JTypeVar;
import com.sun.codemodel.JVar;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.processing.Generated;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementScanner7;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.lang.model.util.Types;
import javax.tools.JavaCompiler;

public class Translator {
    private static final Set<String> translatable;
    private final Types types;
    private final Elements elements;
    private final Trees trees;
    private final JavacTask javac;
    private final JCodeModel codeModel = new JCodeModel();
    private final JClass $Caller;
    private final JClass $CpsFunction;
    private final JClass $CpsCallableInvocation;
    private final JClass $Builder;
    private final JClass $CatchExpression;
    private final DeclaredType closureType;
    private final Map<String, JClass> otherTranslated = new HashMap<String, JClass>();
    private final Map<String, ExecutableElement> overloadsResolved = new TreeMap<String, ExecutableElement>();
    private final Iterable<? extends CompilationUnitTree> parsed;

    public Translator(JavaCompiler.CompilationTask task) throws IOException {
        this.javac = (JavacTask)task;
        this.$Caller = this.codeModel.ref("com.cloudbees.groovy.cps.impl.Caller");
        this.$CpsFunction = this.codeModel.ref("com.cloudbees.groovy.cps.impl.CpsFunction");
        this.$CpsCallableInvocation = this.codeModel.ref("com.cloudbees.groovy.cps.impl.CpsCallableInvocation");
        this.$Builder = this.codeModel.ref("com.cloudbees.groovy.cps.Builder");
        this.$CatchExpression = this.codeModel.ref("com.cloudbees.groovy.cps.CatchExpression");
        this.parsed = this.javac.parse();
        this.trees = Trees.instance(this.javac);
        this.elements = this.javac.getElements();
        this.types = this.javac.getTypes();
        this.closureType = this.types.getDeclaredType(this.elements.getTypeElement(Closure.class.getName()), new TypeMirror[0]);
        this.javac.analyze();
    }

    private String mangledName(ExecutableElement e) {
        StringBuilder overloadResolved = new StringBuilder("$").append(this.n(e));
        e.getParameters().forEach(ve -> overloadResolved.append("__").append(this.types.erasure(ve.asType()).toString().replace("[]", "_array").replaceAll("[^\\p{javaJavaIdentifierPart}]+", "_")));
        return overloadResolved.toString();
    }

    public void translate(final String fqcn, String outfqcn, String sourceJarName) throws JClassAlreadyExistsException {
        JDefinedClass $output = this.codeModel._class(outfqcn);
        $output.annotate(Generated.class).param("value", Translator.class.getName()).param("comments", "based on " + sourceJarName);
        $output.annotate(SuppressWarnings.class).param("value", "rawtypes");
        $output.constructor(4);
        CompilationUnitTree dgmCut = this.getDefaultGroovyMethodCompilationUnitTree(this.parsed, fqcn);
        this.overloadsResolved.clear();
        TypeElement dgm = this.elements.getTypeElement(fqcn);
        new ElementScanner7<Void, Void>(){

            @Override
            public Void visitExecutable(ExecutableElement e, Void __) {
                if (translatable.contains(fqcn + "." + String.valueOf(e))) {
                    Translator.this.overloadsResolved.put(Translator.this.mangledName(e), e);
                }
                return null;
            }
        }.visitType(dgm, null);
        this.overloadsResolved.forEach((overloadResolved, e) -> {
            try {
                this.translateMethod(dgmCut, (ExecutableElement)e, $output, fqcn, (String)overloadResolved);
            }
            catch (Exception x) {
                throw new RuntimeException("Unable to transform " + fqcn + "." + String.valueOf(e), x);
            }
        });
        JClass $MethodLocation = this.codeModel.ref("com.cloudbees.groovy.cps.MethodLocation");
        $output.method(20, (JType)$MethodLocation, "loc").tap(m -> {
            JVar $methodName = m.param(String.class, "methodName");
            m.body()._return((JExpression)JExpr._new((JClass)$MethodLocation).arg($output.dotclass()).arg((JExpression)$methodName));
        });
        this.otherTranslated.put(fqcn, (JClass)$output);
    }

    private void translateMethod(final CompilationUnitTree cut, ExecutableElement e, final JDefinedClass $output, final String fqcn, String overloadResolved) {
        boolean returnsVoid;
        String methodName = this.n(e);
        boolean isPublic = e.getModifiers().contains((Object)Modifier.PUBLIC);
        JMethod delegating = $output.method(isPublic ? 17 : 16, (JType)null, methodName);
        JMethod m = $output.method(20, (JType)null, overloadResolved);
        HashMap<String, JTypeVar> typeVars = new HashMap<String, JTypeVar>();
        e.getTypeParameters().forEach(p -> {
            String name = this.n((Element)p);
            JTypeVar typeVar = delegating.generify(name);
            JTypeVar typeVar2 = m.generify(name);
            p.getBounds().forEach(b -> {
                JClass binding = (JClass)this.t((TypeMirror)b, typeVars);
                typeVar.bound(binding);
                typeVar2.bound(binding);
            });
            typeVars.put(name, typeVar);
        });
        JType type = this.t(e.getReturnType(), typeVars);
        delegating.type(type);
        m.type(type);
        ArrayList delegatingParams = new ArrayList();
        ArrayList params = new ArrayList();
        e.getParameters().forEach(p -> {
            JType paramType = this.t(p.asType(), typeVars);
            delegatingParams.add(e.isVarArgs() && p == e.getParameters().get(e.getParameters().size() - 1) ? delegating.varParam(paramType.elementType(), this.n((Element)p)) : delegating.param(paramType, this.n((Element)p)));
            params.add(m.param(paramType, this.n((Element)p)));
        });
        e.getThrownTypes().forEach(ex -> {
            delegating._throws((JClass)this.t((TypeMirror)ex));
            m._throws((JClass)this.t((TypeMirror)ex));
        });
        boolean bl = returnsVoid = e.getReturnType().getKind() == TypeKind.VOID;
        if (isPublic) {
            delegating.body()._if(JOp.cand((JExpression)JOp.not((JExpression)this.$Caller.staticInvoke("isAsynchronous").tap(inv -> {
                inv.arg((JExpression)delegatingParams.get(0));
                inv.arg(methodName);
                for (int i = 1; i < delegatingParams.size(); ++i) {
                    inv.arg((JExpression)delegatingParams.get(i));
                }
            })), (JExpression)JOp.not((JExpression)this.$Caller.staticInvoke("isAsynchronous").arg($output.dotclass()).arg(methodName).args(params))))._then().tap(blk -> {
                JClass $WhateverGroovyMethods = this.codeModel.ref(fqcn);
                JInvocation forward = $WhateverGroovyMethods.staticInvoke(methodName).args((Collection)delegatingParams);
                if (returnsVoid) {
                    blk.add((JStatement)forward);
                    blk._return();
                } else {
                    blk._return((JExpression)forward);
                }
            });
        }
        JInvocation delegateCall = $output.staticInvoke(overloadResolved);
        if (returnsVoid) {
            delegating.body().add((JStatement)delegateCall);
        } else {
            delegating.body()._return((JExpression)delegateCall);
        }
        delegatingParams.forEach(arg_0 -> ((JInvocation)delegateCall).arg(arg_0));
        final JVar $b = m.body().decl((JType)this.$Builder, "b", (JExpression)JExpr._new((JClass)this.$Builder).arg((JExpression)JExpr.invoke((String)"loc").arg(methodName)).invoke("contextualize").arg((JExpression)this.codeModel.ref("com.cloudbees.groovy.cps.sandbox.Trusted").staticRef("INSTANCE")));
        JInvocation f = JExpr._new((JClass)this.$CpsFunction);
        f.arg((JExpression)this.codeModel.ref(Arrays.class).staticInvoke("asList").tap(inv -> e.getParameters().forEach(p -> inv.arg(this.n((Element)p)))));
        f.arg(this.trees.getTree(e).getBody().accept(new SimpleTreeVisitor<JExpression, Void>(){

            private JExpression visit(Tree t) {
                if (t == null) {
                    return JExpr._null();
                }
                return (JExpression)this.visit(t, null);
            }

            private JExpression loc(Tree t) {
                long pos = Translator.this.trees.getSourcePositions().getStartPosition(cut, t);
                return JExpr.lit((int)((int)cut.getLineMap().getLineNumber(pos)));
            }

            @Override
            public JExpression visitWhileLoop(WhileLoopTree wt, Void __) {
                return $b.invoke("while_").arg(JExpr._null()).arg(this.visit(wt.getCondition())).arg(this.visit(wt.getStatement()));
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public JExpression visitMethodInvocation(MethodInvocationTree mt, Void __) {
                JInvocation inv;
                ExpressionTree ms = mt.getMethodSelect();
                if (ms.getKind() == Tree.Kind.MEMBER_SELECT) {
                    MemberSelectTree mst = (MemberSelectTree)ms;
                    Element mstExpr = this.getElement(mst.getExpression());
                    inv = mst.getExpression().getKind() == Tree.Kind.IDENTIFIER && !mstExpr.toString().equals(fqcn) && Translator.this.otherTranslated.containsKey(mstExpr.toString()) ? $b.invoke("functionCall").arg(this.loc(mt)).arg((JExpression)$b.invoke("constant").arg(Translator.this.otherTranslated.get(mstExpr.toString()).dotclass())).arg(Translator.this.n(mst.getIdentifier())) : $b.invoke("functionCall").arg(this.loc(mt)).arg(this.visit(mst.getExpression())).arg(Translator.this.n(mst.getIdentifier()));
                } else {
                    if (ms.getKind() != Tree.Kind.IDENTIFIER) throw new UnsupportedOperationException(ms.toString());
                    IdentifierTree it = (IdentifierTree)ms;
                    Element mse = this.getElement(ms);
                    Element owner = mse.getEnclosingElement();
                    if (!owner.toString().equals(fqcn)) {
                        inv = Translator.this.otherTranslated.containsKey(owner.toString()) ? $b.invoke("functionCall").arg(this.loc(mt)).arg((JExpression)$b.invoke("constant").arg(Translator.this.otherTranslated.get(owner.toString()).dotclass())).arg(Translator.this.n(it)) : $b.invoke("functionCall").arg(this.loc(mt)).arg((JExpression)$b.invoke("constant").arg(Translator.this.t(owner.asType()).dotclass())).arg(Translator.this.n(it));
                    } else {
                        String overloadResolved = Translator.this.mangledName((ExecutableElement)mse);
                        Optional<Element> callSite = Translator.this.elements.getTypeElement(fqcn).getEnclosedElements().stream().filter(e -> e.getKind() == ElementKind.METHOD && Translator.this.mangledName((ExecutableElement)e).equals(overloadResolved)).findAny();
                        if (!callSite.isPresent()) throw new IllegalStateException("Could not find self-call site " + overloadResolved + " for " + String.valueOf(mt));
                        ExecutableElement e2 = (ExecutableElement)callSite.get();
                        if (e2.getModifiers().contains((Object)Modifier.PUBLIC) && !e2.isVarArgs() && e2.getParameters().stream().noneMatch(p -> Translator.this.types.isAssignable(p.asType(), Translator.this.closureType))) {
                            inv = $b.invoke("staticCall").arg(this.loc(mt)).arg(Translator.this.t(owner.asType()).dotclass()).arg(Translator.this.n(e2));
                        } else {
                            if (!Translator.this.overloadsResolved.containsKey(overloadResolved)) throw new IllegalStateException("Not yet translating a " + String.valueOf(e2.getModifiers()) + " method; translatable.txt might need to include: " + fqcn + "." + String.valueOf(e2));
                            inv = $b.invoke("staticCall").arg(this.loc(mt)).arg($output.dotclass()).arg(overloadResolved);
                        }
                    }
                }
                mt.getArguments().forEach(a -> inv.arg(this.visit((Tree)a)));
                return inv;
            }

            @Override
            public JExpression visitVariable(VariableTree vt, Void __) {
                return $b.invoke("declareVariable").arg(this.loc(vt)).arg(Translator.this.cpsTypeTranslation(Translator.this.erasure(this.getPath(vt)))).arg(Translator.this.n(vt)).arg(this.visit(vt.getInitializer()));
            }

            @Override
            public JExpression visitIdentifier(IdentifierTree it, Void __) {
                Element ite = this.getElement(it);
                switch (ite.getKind()) {
                    case CLASS: 
                    case INTERFACE: {
                        return $b.invoke("constant").arg(Translator.this.t(ite.asType()).dotclass());
                    }
                    case EXCEPTION_PARAMETER: 
                    case LOCAL_VARIABLE: 
                    case PARAMETER: {
                        return $b.invoke("localVariable").arg(Translator.this.n(it.getName()));
                    }
                }
                throw new UnsupportedOperationException(String.valueOf(it) + " (kind " + String.valueOf((Object)ite.getKind()) + ")");
            }

            @Override
            public JExpression visitBlock(BlockTree bt, Void __) {
                JInvocation inv = $b.invoke("block");
                bt.getStatements().forEach(s -> inv.arg(this.visit((Tree)s)));
                return inv;
            }

            @Override
            public JExpression visitReturn(ReturnTree rt, Void __) {
                return $b.invoke("return_").arg(this.visit(rt.getExpression()));
            }

            @Override
            public JExpression visitMemberSelect(MemberSelectTree mt, Void __) {
                return $b.invoke("property").arg(this.loc(mt)).arg(this.visit(mt.getExpression())).arg(Translator.this.n(mt.getIdentifier()));
            }

            @Override
            public JExpression visitTypeCast(TypeCastTree tt, Void __) {
                return $b.invoke("cast").arg(this.loc(tt)).arg(this.visit(tt.getExpression())).arg(Translator.this.erasure(this.getPath(tt.getType())).dotclass()).arg(JExpr.lit((boolean)false));
            }

            @Override
            public JExpression visitIf(IfTree it, Void __) {
                JInvocation inv = $b.invoke("if_").arg(this.visit(it.getCondition())).arg(this.visit(it.getThenStatement()));
                if (it.getElseStatement() != null) {
                    inv.arg(this.visit(it.getElseStatement()));
                }
                return inv;
            }

            @Override
            public JExpression visitNewClass(NewClassTree nt, Void __) {
                if (nt.getEnclosingExpression() != null) {
                    throw new UnsupportedOperationException();
                }
                return $b.invoke("new_").tap(inv -> {
                    inv.arg(this.loc(nt));
                    inv.arg(Translator.this.cpsTypeTranslation(Translator.this.t(this.getElement(nt.getIdentifier()).asType())));
                    nt.getArguments().forEach(et -> inv.arg(this.visit((Tree)et)));
                });
            }

            @Override
            public JExpression visitExpressionStatement(ExpressionStatementTree et, Void __) {
                return this.visit(et.getExpression());
            }

            @Override
            public JExpression visitLiteral(LiteralTree lt, Void __) {
                return $b.invoke("constant").arg(JExpr.literal((Object)lt.getValue()));
            }

            @Override
            public JExpression visitParenthesized(ParenthesizedTree pt, Void __) {
                return this.visit(pt.getExpression());
            }

            @Override
            public JExpression visitBinary(BinaryTree bt, Void __) {
                return $b.invoke(this.opName(bt.getKind())).arg(this.loc(bt)).arg(this.visit(bt.getLeftOperand())).arg(this.visit(bt.getRightOperand()));
            }

            @Override
            public JExpression visitUnary(UnaryTree ut, Void __) {
                return $b.invoke(this.opName(ut.getKind())).arg(this.loc(ut)).arg(this.visit(ut.getExpression()));
            }

            @Override
            public JExpression visitCompoundAssignment(CompoundAssignmentTree ct, Void __) {
                return $b.invoke(this.opName(ct.getKind())).arg(this.loc(ct)).arg(this.visit(ct.getVariable())).arg(this.visit(ct.getExpression()));
            }

            private String opName(Tree.Kind kind) {
                switch (kind) {
                    case EQUAL_TO: {
                        return "compareEqual";
                    }
                    case NOT_EQUAL_TO: {
                        return "compareNotEqual";
                    }
                    case LESS_THAN_EQUAL: {
                        return "lessThanEqual";
                    }
                    case LESS_THAN: {
                        return "lessThan";
                    }
                    case GREATER_THAN_EQUAL: {
                        return "greaterThanEqual";
                    }
                    case GREATER_THAN: {
                        return "greaterThan";
                    }
                    case PREFIX_INCREMENT: {
                        return "prefixInc";
                    }
                    case POSTFIX_INCREMENT: {
                        return "postfixInc";
                    }
                    case POSTFIX_DECREMENT: {
                        return "postfixDec";
                    }
                    case LOGICAL_COMPLEMENT: {
                        return "not";
                    }
                    case CONDITIONAL_OR: {
                        return "logicalOr";
                    }
                    case CONDITIONAL_AND: {
                        return "logicalAnd";
                    }
                    case PLUS: {
                        return "plus";
                    }
                    case PLUS_ASSIGNMENT: {
                        return "plusEqual";
                    }
                    case MINUS: {
                        return "minus";
                    }
                    case MINUS_ASSIGNMENT: {
                        return "minusEqual";
                    }
                }
                throw new UnsupportedOperationException(kind.toString());
            }

            @Override
            public JExpression visitAssignment(AssignmentTree at, Void __) {
                return $b.invoke("assign").arg(this.loc(at)).arg(this.visit(at.getVariable())).arg(this.visit(at.getExpression()));
            }

            @Override
            public JExpression visitArrayType(ArrayTypeTree at, Void __) {
                if (at.getType().getKind() == Tree.Kind.IDENTIFIER) {
                    return this.visitIdentifier((IdentifierTree)at.getType(), __);
                }
                return this.defaultAction((Tree)at, __);
            }

            @Override
            public JExpression visitNewArray(NewArrayTree nt, Void __) {
                if (nt.getInitializers() != null) {
                    return $b.invoke("newArrayFromInitializers").tap(inv -> nt.getInitializers().forEach(d -> inv.arg(this.visit((Tree)d))));
                }
                return $b.invoke("newArray").tap(inv -> {
                    inv.arg(this.loc(nt));
                    inv.arg(Translator.this.t(this.getPath(nt.getType())).dotclass());
                    nt.getDimensions().forEach(d -> inv.arg(this.visit((Tree)d)));
                });
            }

            @Override
            public JExpression visitForLoop(ForLoopTree ft, Void __) {
                return $b.invoke("forLoop").arg(JExpr._null()).arg((JExpression)$b.invoke("sequence").tap(inv -> ft.getInitializer().forEach(i -> inv.arg(this.visit((Tree)i))))).arg(this.visit(ft.getCondition())).arg((JExpression)$b.invoke("sequence").tap(inv -> ft.getUpdate().forEach(i -> inv.arg(this.visit((Tree)i))))).arg(this.visit(ft.getStatement()));
            }

            @Override
            public JExpression visitEnhancedForLoop(EnhancedForLoopTree et, Void __) {
                return $b.invoke("forInLoop").arg(this.loc(et)).arg(JExpr._null()).arg(Translator.this.erasure(this.getPath(et.getVariable())).dotclass()).arg(Translator.this.n(et.getVariable())).arg(this.visit(et.getExpression())).arg(this.visit(et.getStatement()));
            }

            @Override
            public JExpression visitArrayAccess(ArrayAccessTree at, Void __) {
                return $b.invoke("array").arg(this.loc(at)).arg(this.visit(at.getExpression())).arg(this.visit(at.getIndex()));
            }

            @Override
            public JExpression visitBreak(BreakTree node, Void __) {
                if (node.getLabel() != null) {
                    throw new UnsupportedOperationException();
                }
                return $b.invoke("break_").arg(JExpr._null());
            }

            @Override
            public JExpression visitContinue(ContinueTree node, Void aVoid) {
                if (node.getLabel() != null) {
                    throw new UnsupportedOperationException();
                }
                return $b.invoke("continue_").arg(JExpr._null());
            }

            @Override
            public JExpression visitInstanceOf(InstanceOfTree it, Void __) {
                return $b.invoke("instanceOf").arg(this.loc(it)).arg(this.visit(it.getExpression())).arg((JExpression)$b.invoke("constant").arg(Translator.this.t(this.getPath(it.getType())).dotclass()));
            }

            @Override
            public JExpression visitThrow(ThrowTree tt, Void __) {
                return $b.invoke("throw_").arg(this.loc(tt)).arg(this.visit(tt.getExpression()));
            }

            @Override
            public JExpression visitDoWhileLoop(DoWhileLoopTree dt, Void __) {
                return $b.invoke("doWhile").arg(JExpr._null()).arg(this.visit(dt.getStatement())).arg(this.visit(dt.getCondition()));
            }

            @Override
            public JExpression visitConditionalExpression(ConditionalExpressionTree ct, Void __) {
                return $b.invoke("ternaryOp").arg(this.visit(ct.getCondition())).arg(this.visit(ct.getTrueExpression())).arg(this.visit(ct.getFalseExpression()));
            }

            @Override
            public JExpression visitTry(TryTree tt, Void __) {
                return $b.invoke("tryCatch").arg(this.visit(tt.getBlock())).arg(this.visit(tt.getFinallyBlock())).tap(inv -> tt.getCatches().forEach(ct -> JExpr._new((JClass)Translator.this.$CatchExpression).arg(Translator.this.t(Translator.this.trees.getPath(cut, ct.getParameter())).dotclass()).arg(Translator.this.n(ct.getParameter())).arg(this.visit(ct.getBlock()))));
            }

            @Override
            protected JExpression defaultAction(Tree node, Void aVoid) {
                throw new UnsupportedOperationException(node.toString());
            }

            private TreePath getPath(Tree node) {
                return Translator.this.trees.getPath(cut, node);
            }

            private Element getElement(Tree node) {
                return Translator.this.trees.getElement(this.getPath(node));
            }
        }, null));
        JVar $f = m.body().decl((JType)this.$CpsFunction, "f", (JExpression)f);
        m.body()._throw((JExpression)JExpr._new((JClass)this.$CpsCallableInvocation).arg(JExpr.lit((String)methodName)).arg((JExpression)$f).arg(JExpr._null()).args(params));
    }

    private CompilationUnitTree getDefaultGroovyMethodCompilationUnitTree(Iterable<? extends CompilationUnitTree> parsed, String fqcn) {
        for (CompilationUnitTree compilationUnitTree : parsed) {
            for (Tree tree : compilationUnitTree.getTypeDecls()) {
                ClassTree ct;
                if (tree.getKind() != Tree.Kind.CLASS || !(ct = (ClassTree)tree).getSimpleName().toString().equals(fqcn.replaceFirst("^.+[.]", ""))) continue;
                return compilationUnitTree;
            }
        }
        throw new IllegalStateException(fqcn + " wasn't parsed");
    }

    private JType t(TreePath t) {
        return t.getLeaf().accept(new TypeTranslator(t.getCompilationUnit()), null);
    }

    private JType erasure(final TreePath t) {
        return t.getLeaf().accept(new TypeTranslator(t.getCompilationUnit()){

            @Override
            public JType visitParameterizedType(ParameterizedTypeTree pt, Void __) {
                return this.visit(pt.getType());
            }

            @Override
            public JType visitWildcard(WildcardTree wt, Void __) {
                Tree b = wt.getBound();
                if (b == null) {
                    return Translator.this.codeModel.ref(Object.class);
                }
                return this.visit(b);
            }

            @Override
            public JType visitIdentifier(IdentifierTree it, Void __) {
                Element ite = Translator.this.trees.getElement(Translator.this.trees.getPath(t.getCompilationUnit(), it));
                switch (ite.getKind()) {
                    case CLASS: 
                    case INTERFACE: {
                        return Translator.this.codeModel.ref(ite.toString());
                    }
                    case TYPE_PARAMETER: {
                        TypeMirror type = ite.asType();
                        if (type.getKind() == TypeKind.TYPEVAR) {
                            return Translator.this.t(((TypeVariable)type).getUpperBound());
                        }
                        return Translator.this.codeModel.ref(Object.class);
                    }
                }
                throw new UnsupportedOperationException(String.valueOf(it) + " (kind " + String.valueOf((Object)ite.getKind()) + ")");
            }
        }, null);
    }

    private JType t(TypeMirror m) {
        return this.t(m, Collections.emptyMap());
    }

    private JType t(TypeMirror m, final Map<String, JTypeVar> typeVars) {
        if (m.getKind().isPrimitive()) {
            return JType.parse((JCodeModel)this.codeModel, (String)m.toString());
        }
        return m.accept(new SimpleTypeVisitor8<JType, Void>(){

            @Override
            public JType visitPrimitive(PrimitiveType t, Void __) {
                return Translator.this.primitive(t, t.getKind());
            }

            @Override
            public JType visitDeclared(DeclaredType t, Void __) {
                String name = Translator.this.n(((TypeElement)t.asElement()).getQualifiedName());
                if (name.isEmpty()) {
                    throw new UnsupportedOperationException("Anonymous class: " + String.valueOf(t));
                }
                JClass base = Translator.this.codeModel.ref(name);
                if (t.getTypeArguments().isEmpty()) {
                    return base;
                }
                ArrayList typeArgs = new ArrayList();
                t.getTypeArguments().forEach(a -> typeArgs.add((JClass)Translator.this.t((TypeMirror)a, typeVars)));
                return base.narrow(typeArgs);
            }

            @Override
            public JType visitTypeVariable(TypeVariable t, Void __) {
                String name = t.asElement().getSimpleName().toString();
                JTypeVar var = (JTypeVar)typeVars.get(name);
                if (var != null) {
                    return var;
                }
                return Translator.this.t(t.getUpperBound(), typeVars);
            }

            @Override
            public JType visitNoType(NoType t, Void __) {
                return Translator.this.primitive(t, t.getKind());
            }

            @Override
            public JType visitArray(ArrayType t, Void __) {
                return Translator.this.t(t.getComponentType(), typeVars).array();
            }

            @Override
            public JType visitWildcard(WildcardType t, Void aVoid) {
                if (t.getExtendsBound() != null) {
                    return Translator.this.t(t.getExtendsBound(), typeVars).boxify().wildcard();
                }
                if (t.getSuperBound() != null) {
                    throw new UnsupportedOperationException();
                }
                return Translator.this.codeModel.wildcard();
            }

            @Override
            protected JType defaultAction(TypeMirror e, Void __) {
                throw new UnsupportedOperationException(e.toString());
            }
        }, null);
    }

    private String n(Element e) {
        return e.getSimpleName().toString();
    }

    private String n(Name n) {
        return n.toString();
    }

    private String n(VariableTree v) {
        return this.n(v.getName());
    }

    private String n(IdentifierTree v) {
        return this.n(v.getName());
    }

    private JType primitive(Object src, TypeKind k) {
        switch (k) {
            case BOOLEAN: {
                return this.codeModel.BOOLEAN;
            }
            case BYTE: {
                return this.codeModel.BYTE;
            }
            case SHORT: {
                return this.codeModel.SHORT;
            }
            case INT: {
                return this.codeModel.INT;
            }
            case LONG: {
                return this.codeModel.LONG;
            }
            case CHAR: {
                return this.codeModel.CHAR;
            }
            case FLOAT: {
                return this.codeModel.FLOAT;
            }
            case DOUBLE: {
                return this.codeModel.DOUBLE;
            }
            case VOID: {
                return this.codeModel.VOID;
            }
        }
        throw new UnsupportedOperationException(src.toString());
    }

    private JExpression cpsTypeTranslation(JType original) {
        if (original.fullName().equals("org.codehaus.groovy.runtime.callsite.BooleanClosureWrapper")) {
            return this.codeModel.ref("com.cloudbees.groovy.cps.impl.CpsBooleanClosureWrapper").dotclass();
        }
        return original.dotclass();
    }

    public void generateTo(CodeWriter cw) throws IOException {
        this.codeModel.build(cw);
    }

    static {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Translator.class.getResourceAsStream("translatable.txt"), StandardCharsets.UTF_8));){
            translatable = new HashSet<String>(reader.lines().collect(Collectors.toSet()));
        }
        catch (IOException x) {
            throw new ExceptionInInitializerError(x);
        }
    }

    private class TypeTranslator
    extends SimpleTreeVisitor<JType, Void> {
        private final CompilationUnitTree cut;

        private TypeTranslator(CompilationUnitTree cut) {
            this.cut = cut;
        }

        protected JType visit(Tree t) {
            return (JType)this.visit(t, null);
        }

        @Override
        public JType visitVariable(VariableTree node, Void __) {
            return this.visit(node.getType());
        }

        @Override
        public JType visitParameterizedType(ParameterizedTypeTree pt, Void __) {
            JClass base = (JClass)this.visit(pt.getType());
            ArrayList<JClass> args = new ArrayList<JClass>();
            for (Tree tree : pt.getTypeArguments()) {
                args.add((JClass)this.visit(tree));
            }
            return base.narrow(args);
        }

        @Override
        public JType visitIdentifier(IdentifierTree it, Void __) {
            return Translator.this.codeModel.ref(this.getElement(it).toString());
        }

        @Override
        public JType visitPrimitiveType(PrimitiveTypeTree pt, Void aVoid) {
            return Translator.this.primitive(pt, pt.getPrimitiveTypeKind());
        }

        @Override
        public JType visitArrayType(ArrayTypeTree at, Void __) {
            return this.visit(at.getType()).array();
        }

        @Override
        public JType visitMemberSelect(MemberSelectTree mt, Void __) {
            return Translator.this.t(this.getElement(mt).asType());
        }

        @Override
        public JType visitWildcard(WildcardTree wt, Void __) {
            Tree b = wt.getBound();
            if (b == null) {
                return Translator.this.codeModel.wildcard();
            }
            return this.visit(b).boxify().wildcard();
        }

        @Override
        protected JType defaultAction(Tree node, Void __) {
            throw new UnsupportedOperationException(node.toString());
        }

        private Element getElement(Tree node) {
            return Translator.this.trees.getElement(Translator.this.trees.getPath(this.cut, node));
        }
    }
}

