/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.service.strategy;

import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import com.blackduck.integration.log.LogLevel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;

public class RemoteJavaService {
    public static final String DETECT_JAVA_PATH = "DETECT_JAVA_PATH";
    public static final String JAVA_HOME = "JAVA_HOME";
    private final JenkinsIntLogger logger;
    private final String remoteJdkHome;
    private final Map<String, String> environmentVariables;

    public RemoteJavaService(JenkinsIntLogger logger, String remoteJdkHome, Map<String, String> environmentVariables) {
        this.logger = logger;
        this.remoteJdkHome = remoteJdkHome;
        this.environmentVariables = environmentVariables;
    }

    public String getJavaExecutablePath() {
        String javaExecutableName = "java";
        if (SystemUtils.IS_OS_WINDOWS) {
            javaExecutableName = "java.exe";
        }
        String javaExecutablePath = this.calculateJavaExecutablePath(javaExecutableName);
        this.logger.info("Running with JAVA: " + javaExecutablePath);
        this.logDebugData(javaExecutablePath);
        return javaExecutablePath;
    }

    private String calculateJavaExecutablePath(String javaExecutableName) {
        String fullPathToJava = null;
        String javaPathSourceLogging = "";
        File javaExecutablePath = null;
        if (this.remoteJdkHome != null) {
            javaExecutablePath = new File(this.remoteJdkHome, "bin");
            javaExecutablePath = new File(javaExecutablePath, javaExecutableName);
            javaPathSourceLogging = "Node environment";
        } else if (this.environmentVariables.containsKey(DETECT_JAVA_PATH)) {
            javaExecutablePath = new File(this.environmentVariables.get(DETECT_JAVA_PATH));
            javaPathSourceLogging = "DETECT_JAVA_PATH environment variable";
        } else if (this.environmentVariables.containsKey(JAVA_HOME)) {
            javaExecutablePath = new File(this.environmentVariables.get(JAVA_HOME), "bin");
            javaExecutablePath = new File(javaExecutablePath, javaExecutableName);
            javaPathSourceLogging = "JAVA_HOME environment variable";
        }
        try {
            fullPathToJava = Objects.requireNonNull(javaExecutablePath).getCanonicalPath();
            this.logger.debug("Path to Java executable is set based on: " + javaPathSourceLogging);
        }
        catch (IOException | NullPointerException e) {
            this.logger.warn("Could not set path to Java executable, falling back to PATH.");
        }
        return null != fullPathToJava ? fullPathToJava : javaExecutableName;
    }

    private void logDebugData(String javaExecutablePath) {
        if (this.logger.getLogLevel().isLoggable(LogLevel.DEBUG)) {
            this.logger.debug("PATH: " + this.environmentVariables.get("PATH"));
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(Arrays.asList(javaExecutablePath, "-version"));
                processBuilder.environment().putAll(this.environmentVariables);
                Process process = processBuilder.start();
                process.waitFor();
                this.logJavaVersion(process);
            }
            catch (IOException e) {
                this.logger.debug("Error starting process to get Java version: " + e.getMessage(), (Throwable)e);
            }
            catch (InterruptedException e) {
                this.logger.debug("Error running process to get Java version: " + e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void logJavaVersion(Process process) {
        try (InputStream errorStream = Objects.requireNonNull(process).getErrorStream();
             InputStream inputSteam = Objects.requireNonNull(process).getInputStream();){
            this.logger.debug("Java version: ");
            IOUtils.copy((InputStream)errorStream, (OutputStream)this.logger.getTaskListener().getLogger());
            IOUtils.copy((InputStream)inputSteam, (OutputStream)this.logger.getTaskListener().getLogger());
        }
        catch (IOException e) {
            this.logger.debug("Error printing the JAVA version: " + e.getMessage(), (Throwable)e);
        }
    }
}

