/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.service;

import com.blackduck.integration.blackduck.configuration.BlackDuckServerConfigBuilder;
import com.blackduck.integration.jenkins.detect.extensions.global.DetectGlobalConfig;
import com.blackduck.integration.jenkins.extensions.JenkinsIntLogger;
import com.blackduck.integration.jenkins.service.JenkinsConfigService;
import com.blackduck.integration.jenkins.wrapper.BlackduckCredentialsHelper;
import com.blackduck.integration.jenkins.wrapper.JenkinsProxyHelper;
import com.blackduck.integration.jenkins.wrapper.JenkinsVersionHelper;
import com.blackduck.integration.util.IntEnvironmentVariables;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

public class DetectEnvironmentService {
    public static final String TIMEOUT = "DETECT_TIMEOUT";
    private final JenkinsIntLogger logger;
    private final JenkinsProxyHelper jenkinsProxyHelper;
    private final JenkinsVersionHelper jenkinsVersionHelper;
    private final BlackduckCredentialsHelper blackduckCredentialsHelper;
    private final Map<String, String> environmentVariables;
    private final JenkinsConfigService jenkinsConfigService;

    public DetectEnvironmentService(JenkinsIntLogger logger, JenkinsProxyHelper jenkinsProxyHelper, JenkinsVersionHelper jenkinsVersionHelper, BlackduckCredentialsHelper blackduckCredentialsHelper, JenkinsConfigService jenkinsConfigService, Map<String, String> environmentVariables) {
        this.logger = logger;
        this.jenkinsProxyHelper = jenkinsProxyHelper;
        this.jenkinsVersionHelper = jenkinsVersionHelper;
        this.jenkinsConfigService = jenkinsConfigService;
        this.blackduckCredentialsHelper = blackduckCredentialsHelper;
        this.environmentVariables = environmentVariables;
    }

    public IntEnvironmentVariables createDetectEnvironment() {
        IntEnvironmentVariables intEnvironmentVariables = IntEnvironmentVariables.empty();
        intEnvironmentVariables.putAll(this.environmentVariables);
        this.logger.setLogLevel(intEnvironmentVariables);
        this.populateAllBlackDuckEnvironmentVariables((arg_0, arg_1) -> ((IntEnvironmentVariables)intEnvironmentVariables).put(arg_0, arg_1));
        Optional pluginVersion = this.jenkinsVersionHelper.getPluginVersion("blackduck-detect");
        if (pluginVersion.isPresent()) {
            this.logger.info("Running Black Duck Detect Jenkins Plugin version: " + (String)pluginVersion.get());
        } else {
            this.logger.info("Running Black Duck Detect Jenkins Plugin");
        }
        return intEnvironmentVariables;
    }

    private void populateAllBlackDuckEnvironmentVariables(BiConsumer<String, String> environmentPutter) {
        Optional detectGlobalConfig = this.jenkinsConfigService.getGlobalConfiguration(DetectGlobalConfig.class);
        if (!detectGlobalConfig.isPresent()) {
            return;
        }
        BlackDuckServerConfigBuilder blackDuckServerConfigBuilder = ((DetectGlobalConfig)detectGlobalConfig.get()).getBlackDuckServerConfigBuilder(this.jenkinsProxyHelper, this.blackduckCredentialsHelper);
        blackDuckServerConfigBuilder.getProperties().forEach((builderPropertyKey, propertyValue) -> this.updateAndFilterVariables(environmentPutter, builderPropertyKey.getKey(), (String)propertyValue));
    }

    private void updateAndFilterVariables(BiConsumer<String, String> environmentPutter, String key, String value) {
        String filteredKey;
        String string = filteredKey = BlackDuckServerConfigBuilder.TIMEOUT_KEY.getKey().equals(key) ? TIMEOUT : key;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{filteredKey, value})) {
            environmentPutter.accept(filteredKey, value);
        }
    }
}

