/*
 * Decompiled with CFR 0.152.
 */
package com.blackduck.integration.jenkins.detect.extensions.global;

import com.blackduck.integration.blackduck.configuration.BlackDuckServerConfig;
import com.blackduck.integration.blackduck.configuration.BlackDuckServerConfigBuilder;
import com.blackduck.integration.exception.IntegrationException;
import com.blackduck.integration.jenkins.detect.extensions.AirGapDownloadStrategy;
import com.blackduck.integration.jenkins.detect.extensions.DetectDownloadStrategy;
import com.blackduck.integration.jenkins.detect.extensions.ScriptOrJarDownloadStrategy;
import com.blackduck.integration.jenkins.wrapper.BlackduckCredentialsHelper;
import com.blackduck.integration.jenkins.wrapper.JenkinsProxyHelper;
import com.blackduck.integration.jenkins.wrapper.JenkinsWrapper;
import com.blackduck.integration.log.IntLogger;
import com.blackduck.integration.log.LogLevel;
import com.blackduck.integration.log.PrintStreamIntLogger;
import com.blackduck.integration.rest.proxy.ProxyInfo;
import com.blackduck.integration.rest.response.Response;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.FormValidation;
import hudson.util.IOUtils;
import hudson.util.ListBoxModel;
import hudson.util.Messages;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import jenkins.util.xml.XMLUtils;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.POST;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Extension
public class DetectGlobalConfig
extends GlobalConfiguration
implements Serializable {
    private static final long serialVersionUID = -7629542889827231313L;
    private String blackDuckUrl;
    private String blackDuckCredentialsId;
    private boolean trustBlackDuckCertificates;
    private int blackDuckTimeout = 120;
    @Nullable
    private DetectDownloadStrategy downloadStrategy;

    @DataBoundConstructor
    public DetectGlobalConfig() {
        this.load();
    }

    public String getBlackDuckUrl() {
        return this.blackDuckUrl;
    }

    @DataBoundSetter
    public void setBlackDuckUrl(String blackDuckUrl) {
        this.blackDuckUrl = blackDuckUrl;
        this.save();
    }

    public int getBlackDuckTimeout() {
        return this.blackDuckTimeout;
    }

    @DataBoundSetter
    public void setBlackDuckTimeout(int blackDuckTimeout) {
        this.blackDuckTimeout = blackDuckTimeout;
        this.save();
    }

    public String getBlackDuckCredentialsId() {
        return this.blackDuckCredentialsId;
    }

    @DataBoundSetter
    public void setBlackDuckCredentialsId(String blackDuckCredentialsId) {
        this.blackDuckCredentialsId = blackDuckCredentialsId;
        this.save();
    }

    public boolean getTrustBlackDuckCertificates() {
        return this.trustBlackDuckCertificates;
    }

    @DataBoundSetter
    public void setTrustBlackDuckCertificates(boolean trustBlackDuckCertificates) {
        this.trustBlackDuckCertificates = trustBlackDuckCertificates;
        this.save();
    }

    public DetectDownloadStrategy getDownloadStrategy() {
        return this.downloadStrategy;
    }

    @DataBoundSetter
    public void setDownloadStrategy(DetectDownloadStrategy downloadStrategy) {
        this.downloadStrategy = downloadStrategy;
    }

    public DetectDownloadStrategy getDefaultDownloadStrategy() {
        return new ScriptOrJarDownloadStrategy();
    }

    public Collection<Descriptor<DetectDownloadStrategy>> getAllowedDownloadStrategyDescriptors() {
        Jenkins jenkins = Jenkins.get();
        return Arrays.asList(jenkins.getDescriptor(AirGapDownloadStrategy.class), jenkins.getDescriptor(ScriptOrJarDownloadStrategy.class));
    }

    public BlackDuckServerConfig getBlackDuckServerConfig(JenkinsProxyHelper jenkinsProxyHelper, BlackduckCredentialsHelper blackduckCredentialsHelper) {
        return (BlackDuckServerConfig)this.getBlackDuckServerConfigBuilder(jenkinsProxyHelper, blackduckCredentialsHelper).build();
    }

    public BlackDuckServerConfigBuilder getBlackDuckServerConfigBuilder(JenkinsProxyHelper jenkinsProxyHelper, BlackduckCredentialsHelper blackduckCredentialsHelper) {
        return this.createBlackDuckServerConfigBuilder(jenkinsProxyHelper, blackduckCredentialsHelper, this.blackDuckUrl, this.blackDuckCredentialsId, this.blackDuckTimeout, this.trustBlackDuckCertificates);
    }

    public ListBoxModel doFillBlackDuckCredentialsIdItems() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return new StandardListBoxModel().includeEmptyValue();
        }
        jenkins.checkPermission(Jenkins.ADMINISTER);
        return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, BaseStandardCredentials.class, Collections.emptyList(), BlackduckCredentialsHelper.API_TOKEN_CREDENTIALS);
    }

    @POST
    public FormValidation doTestBlackDuckConnection(@QueryParameter(value="blackDuckUrl") String blackDuckUrl, @QueryParameter(value="blackDuckCredentialsId") String blackDuckCredentialsId, @QueryParameter(value="blackDuckTimeout") String blackDuckTimeout, @QueryParameter(value="trustBlackDuckCertificates") boolean trustBlackDuckCertificates) {
        JenkinsWrapper jenkinsWrapper = JenkinsWrapper.initializeFromJenkinsJVM();
        if (!jenkinsWrapper.getJenkins().isPresent()) {
            return FormValidation.warning((String)"Connection validation could not be completed: Validation couldn't retrieve the instance of Jenkins from the JVM. This may happen if Jenkins is still starting up or if this code is running on a different JVM than your Jenkins server.");
        }
        ((Jenkins)jenkinsWrapper.getJenkins().get()).checkPermission(Jenkins.ADMINISTER);
        BlackduckCredentialsHelper blackduckCredentialsHelper = jenkinsWrapper.getCredentialsHelper();
        JenkinsProxyHelper jenkinsProxyHelper = jenkinsWrapper.getProxyHelper();
        try {
            BlackDuckServerConfig blackDuckServerConfig = (BlackDuckServerConfig)this.createBlackDuckServerConfigBuilder(jenkinsProxyHelper, blackduckCredentialsHelper, blackDuckUrl, blackDuckCredentialsId, Integer.parseInt(blackDuckTimeout), trustBlackDuckCertificates).build();
            Response response = blackDuckServerConfig.createBlackDuckHttpClient((IntLogger)new PrintStreamIntLogger(System.out, LogLevel.DEBUG)).attemptAuthentication();
            if (response.isStatusCodeError()) {
                int statusCode = response.getStatusCode();
                String validationMessage = this.determineValidationMessage(statusCode);
                String moreDetailsHtml = Optional.ofNullable(response.getContentString()).map(Util::escape).map(msg -> String.format("<a href='#' class='showDetails'>%s</a><pre style='display:none'>%s</pre>", Messages.FormValidation_Error_Details(), msg)).orElse("");
                return FormValidation.errorWithMarkup((String)String.join((CharSequence)" ", validationMessage, moreDetailsHtml));
            }
        }
        catch (IntegrationException | IllegalArgumentException e) {
            return FormValidation.error((String)e.getMessage());
        }
        return FormValidation.ok((String)"Connection successful.");
    }

    private String determineValidationMessage(int statusCode) {
        String validationMessage;
        try {
            String statusPhrase = EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, Locale.ENGLISH);
            validationMessage = String.format("ERROR: Connection attempt returned %s %s", statusCode, statusPhrase);
        }
        catch (IllegalArgumentException ignored) {
            validationMessage = "ERROR: Connection could not be established.";
        }
        return validationMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WebMethod(name={"config.xml"})
    public void doConfigDotXml(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, ParserConfigurationException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        boolean changed = false;
        try {
            if (this.getClass().getClassLoader() != originalClassLoader) {
                changed = true;
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            }
            Functions.checkPermission((Permission)Jenkins.ADMINISTER);
            if (req.getMethod().equals("GET")) {
                rsp.setContentType("application/xml");
                IOUtils.copy((File)this.getConfigFile().getFile(), (OutputStream)rsp.getOutputStream());
                return;
            }
            Functions.checkPermission((Permission)Jenkins.ADMINISTER);
            if (req.getMethod().equals("POST")) {
                this.updateByXml(new StreamSource(req.getReader()));
                return;
            }
            rsp.sendError(400);
        }
        finally {
            if (changed) {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    private void updateByXml(Source source) throws IOException, ParserConfigurationException {
        Document doc;
        try (StringWriter out = new StringWriter();){
            XMLUtils.safeTransform((Source)source, (Result)new StreamResult(out));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new StringReader(out.toString()));
            doc = builder.parse(is);
        }
        catch (TransformerException | SAXException e) {
            throw new IOException("Failed to persist configuration.xml", e);
        }
        String url = this.getNodeValue(doc, "blackDuckUrl").orElse("");
        String credentialsId = this.getNodeValue(doc, "blackDuckCredentialsId").orElse("");
        int timeout = this.getNodeIntegerValue(doc, "blackDuckTimeout").orElse(120);
        boolean trustCerts = this.getNodeBooleanValue(doc, "trustBlackDuckCertificates").orElse(false);
        this.setBlackDuckUrl(url);
        this.setBlackDuckCredentialsId(credentialsId);
        this.setBlackDuckTimeout(timeout);
        this.setTrustBlackDuckCertificates(trustCerts);
        this.save();
    }

    private Optional<String> getNodeValue(Document doc, String tagName) {
        return Optional.ofNullable(doc.getElementsByTagName(tagName).item(0)).map(Node::getFirstChild).map(Node::getNodeValue).map(String::trim);
    }

    private Optional<Integer> getNodeIntegerValue(Document doc, String tagName) {
        try {
            return this.getNodeValue(doc, tagName).map(Integer::valueOf);
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }

    private Optional<Boolean> getNodeBooleanValue(Document doc, String tagName) {
        return this.getNodeValue(doc, tagName).map(Boolean::valueOf);
    }

    private BlackDuckServerConfigBuilder createBlackDuckServerConfigBuilder(JenkinsProxyHelper jenkinsProxyHelper, BlackduckCredentialsHelper blackduckCredentialsHelper, String blackDuckUrl, String credentialsId, int timeout, boolean alwaysTrust) {
        ProxyInfo proxyInfo = jenkinsProxyHelper.getProxyInfo(blackDuckUrl);
        String apiToken = blackduckCredentialsHelper.getApiTokenByCredentialsId(credentialsId).orElse(null);
        return BlackDuckServerConfig.newApiTokenBuilder().setUrl(blackDuckUrl).setTimeoutInSeconds(timeout).setTrustCert(alwaysTrust).setProxyInfo(proxyInfo).setApiToken(apiToken);
    }
}

