/*
 * Decompiled with CFR 0.152.
 */
package sp.sd.fileoperations;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.util.Secret;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.DataBoundConstructor;
import sp.sd.fileoperations.FileOperation;
import sp.sd.fileoperations.FileOperationDescriptor;

public class FileDownloadOperation
extends FileOperation
implements Serializable {
    private final String url;
    private final String userName;
    private final String targetLocation;
    private final String targetFileName;
    private final String password;
    private final String proxyHost;
    private final String proxyPort;

    @DataBoundConstructor
    public FileDownloadOperation(String url, String userName, String password, String targetLocation, String targetFileName, String proxyHost, String proxyPort) {
        this.url = url;
        this.userName = userName;
        this.targetLocation = targetLocation;
        this.targetFileName = targetFileName;
        this.password = Secret.fromString((String)password).getEncryptedValue();
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getTargetLocation() {
        return this.targetLocation;
    }

    public String getTargetFileName() {
        return this.targetFileName;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public String getPassword() {
        return Secret.decrypt((String)this.password).getPlainText();
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean runOperation(Run<?, ?> run, FilePath buildWorkspace, Launcher launcher, TaskListener listener) {
        boolean result = false;
        try {
            listener.getLogger().println("File Download Operation:");
            EnvVars envVars = run.getEnvironment(listener);
            try {
                FilePath ws = new FilePath(buildWorkspace, ".");
                result = (Boolean)ws.act((FilePath.FileCallable)new TargetFileCallable(listener, envVars.expand(this.url), envVars.expand(this.userName), envVars.expand(Secret.decrypt((String)this.password).getPlainText()), envVars.expand(this.targetLocation), envVars.expand(this.targetFileName), envVars.expand(this.proxyHost), envVars.expand(this.proxyPort)));
            }
            catch (Exception e) {
                listener.fatalError(e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            listener.fatalError(e.getMessage());
        }
        return result;
    }

    private static final class TargetFileCallable
    implements FilePath.FileCallable<Boolean> {
        private static final long serialVersionUID = 1L;
        private final TaskListener listener;
        private final String resolvedUrl;
        private final String resolvedUserName;
        private final String resolvedTargetLocation;
        private final String resolvedTargetFileName;
        private final String resolvedPassword;
        private final String proxyHost;
        private final String proxyPort;

        public TargetFileCallable(TaskListener Listener, String ResolvedUrl, String ResolvedUserName, String ResolvedPassword, String ResolvedTargetLocation, String ResolvedTargetFileName, String proxyHost, String proxyPort) {
            this.listener = Listener;
            this.resolvedUrl = ResolvedUrl;
            this.resolvedUserName = ResolvedUserName;
            this.resolvedTargetLocation = ResolvedTargetLocation;
            this.resolvedTargetFileName = ResolvedTargetFileName;
            this.resolvedPassword = ResolvedPassword;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
        }

        public Boolean invoke(File ws, VirtualChannel channel) {
            try {
                FilePath fpWS = new FilePath(ws);
                FilePath fpTL = new FilePath(fpWS, this.resolvedTargetLocation);
                FilePath fpTLF = new FilePath(fpTL, this.resolvedTargetFileName);
                File fTarget = new File(fpTLF.toURI());
                URI uri = new URI(this.resolvedUrl);
                this.listener.getLogger().println("Started downloading file from " + this.resolvedUrl);
                HttpHost host = new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(this.resolvedUserName, this.resolvedPassword.toCharArray()));
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(host, (AuthScheme)basicAuth);
                HttpClientBuilder httpClientBuilder = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                if (this.proxyHost != null && !this.proxyHost.isEmpty() && this.proxyPort != null && this.proxyPort.matches("[0-9]+")) {
                    HttpHost proxy = new HttpHost(this.proxyHost, Integer.parseInt(this.proxyPort));
                    httpClientBuilder.setProxy(proxy);
                }
                CloseableHttpClient httpClient = httpClientBuilder.setRedirectStrategy((RedirectStrategy)DefaultRedirectStrategy.INSTANCE).build();
                HttpGet httpGet = new HttpGet(uri);
                HttpClientContext localContext = HttpClientContext.create();
                if (!this.resolvedUserName.isEmpty() && !this.resolvedPassword.isEmpty()) {
                    localContext.setAuthCache((AuthCache)authCache);
                }
                return (Boolean)httpClient.execute(host, (ClassicHttpRequest)httpGet, (HttpContext)localContext, response -> {
                    HttpEntity entity = response.getEntity();
                    try (FileOutputStream fosTarget = new FileOutputStream(fTarget);){
                        if (response.getCode() != 200) {
                            Boolean bl = false;
                            return bl;
                        }
                        entity.writeTo((OutputStream)fosTarget);
                        this.listener.getLogger().println("Completed downloading file.");
                        Boolean bl = true;
                        return bl;
                    }
                });
            }
            catch (RuntimeException e) {
                this.listener.fatalError(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.listener.fatalError(e.getMessage());
                return false;
            }
        }

        public void checkRoles(RoleChecker checker) throws SecurityException {
        }
    }

    @Extension
    @Symbol(value={"fileDownloadOperation"})
    public static class DescriptorImpl
    extends FileOperationDescriptor {
        @NonNull
        public String getDisplayName() {
            return "File Download";
        }
    }
}

