/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import ru.yandex.qatools.allure.jenkins.utils.BuildSummary;
import ru.yandex.qatools.allure.jenkins.utils.ZipUtils;

public final class FilePathUtils {
    private static final String ALLURE_PREFIX = "allure";
    private static final String ALLURE_REPORT_ZIP = "allure-report.zip";
    private static final List<String> BUILD_STATISTICS_KEYS = Arrays.asList("passed", "failed", "broken", "skipped", "unknown");
    public static final String SEPORATOR = "/";

    private FilePathUtils() {
    }

    public static void copyRecursiveTo(FilePath from, FilePath to, AbstractBuild build, PrintStream logger) throws IOException, InterruptedException {
        if (from.isRemote() && to.isRemote()) {
            FilePath tmpMasterFilePath = new FilePath(build.getRootDir()).createTempDir(ALLURE_PREFIX, null);
            from.copyRecursiveTo(tmpMasterFilePath);
            tmpMasterFilePath.copyRecursiveTo(to);
            FilePathUtils.deleteRecursive(tmpMasterFilePath, logger);
        } else {
            from.copyRecursiveTo(to);
        }
    }

    public static void deleteRecursive(FilePath filePath, PrintStream logger) {
        try {
            filePath.deleteContents();
            filePath.deleteRecursive();
        }
        catch (IOException | InterruptedException e) {
            logger.printf("Can't delete directory [%s]%n", filePath);
        }
    }

    public static FilePath getPreviousReportWithHistory(Run<?, ?> run, String reportPath) throws IOException, InterruptedException {
        for (Run current = run; current != null; current = current.getPreviousCompletedBuild()) {
            FilePath previousReport = new FilePath(current.getArtifactsDir()).child(ALLURE_REPORT_ZIP);
            if (!previousReport.exists() || !FilePathUtils.isHistoryNotEmpty(previousReport, reportPath)) continue;
            return previousReport;
        }
        return null;
    }

    private static boolean isHistoryNotEmpty(FilePath previousReport, String reportPath) throws IOException {
        block11: {
            try (ZipFile archive = new ZipFile(previousReport.getRemote());){
                boolean bl;
                block12: {
                    List<ZipEntry> entries = ZipUtils.listEntries(archive, reportPath + "/history/history.json");
                    if (!Integer.valueOf(entries.size()).equals(1)) break block11;
                    ZipEntry historyEntry = entries.get(0);
                    InputStream is = archive.getInputStream(historyEntry);
                    try {
                        ObjectMapper mapper = new ObjectMapper();
                        JsonNode historyJson = mapper.readTree(is);
                        bl = historyJson.elements().hasNext();
                        if (is == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return bl;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static BuildSummary extractSummary(Run<?, ?> run, String reportPath) {
        block16: {
            FilePath report = new FilePath(run.getArtifactsDir()).child(ALLURE_REPORT_ZIP);
            try {
                if (!report.exists()) {
                    return null;
                }
                try (ZipFile archive = new ZipFile(report.getRemote());){
                    BuildSummary buildSummary;
                    block17: {
                        Optional<ZipEntry> summary = FilePathUtils.getSummary(archive, reportPath, "export");
                        if (!summary.isPresent()) {
                            summary = FilePathUtils.getSummary(archive, reportPath, "widgets");
                        }
                        if (!summary.isPresent()) break block16;
                        InputStream is = archive.getInputStream(summary.get());
                        try {
                            ObjectMapper mapper = new ObjectMapper();
                            JsonNode summaryJson = mapper.readTree(is);
                            JsonNode statisticJson = summaryJson.get("statistic");
                            HashMap<String, Integer> statisticsMap = new HashMap<String, Integer>();
                            for (String key : BUILD_STATISTICS_KEYS) {
                                statisticsMap.put(key, statisticJson.get(key).intValue());
                            }
                            buildSummary = new BuildSummary().withStatistics(statisticsMap);
                            if (is == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        is.close();
                    }
                    return buildSummary;
                }
            }
            catch (IOException | InterruptedException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Optional<ZipEntry> getSummary(ZipFile archive, String reportPath, String location) {
        List<ZipEntry> entries = ZipUtils.listEntries(archive, reportPath.concat(SEPORATOR).concat(location));
        String toSearch = reportPath.concat(SEPORATOR).concat(location).concat("/summary.json");
        return entries.stream().filter(Objects::nonNull).filter(input -> input.getName().equals(toSearch)).findFirst();
    }
}

