/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.utils;

import hudson.EnvVars;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolInstallation;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;

public final class BuildUtils {
    private BuildUtils() {
    }

    public static <T extends ToolInstallation & NodeSpecific<T>> T setUpTool(@Nullable T tool, @Nonnull Launcher launcher, @Nonnull TaskListener listener, @Nonnull EnvVars env) throws IOException, InterruptedException {
        if (tool == null) {
            return null;
        }
        tool.buildEnvVars(env);
        Computer computer = BuildUtils.getComputer(launcher);
        if (computer != null && computer.getNode() != null) {
            tool = (ToolInstallation)((EnvironmentSpecific)((ToolInstallation)((NodeSpecific<T>)tool).forNode(computer.getNode(), listener))).forEnvironment(env);
            BuildUtils.setEnvVarsForNode(tool, env, launcher);
        }
        return tool;
    }

    private static <T extends ToolInstallation & NodeSpecific<T>> void setEnvVarsForNode(final T tool, final EnvVars envVars, Launcher launcher) throws IOException, InterruptedException {
        launcher.getChannel().call((Callable)new MasterToSlaveCallable<Void, RuntimeException>(){

            public Void call() {
                if (tool != null) {
                    tool.buildEnvVars(envVars);
                }
                return null;
            }
        });
    }

    public static Computer getComputer(Launcher launcher) {
        for (Computer computer : Jenkins.get().getComputers()) {
            if (!Objects.equals(computer.getChannel(), launcher.getChannel())) continue;
            return computer;
        }
        return null;
    }

    public static EnvVars getBuildEnvVars(Run<?, ?> run, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = run.getEnvironment(listener);
        if (run instanceof AbstractBuild) {
            env.overrideAll(((AbstractBuild)run).getBuildVariables());
        }
        return env;
    }
}

