/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import ru.yandex.qatools.allure.jenkins.config.PropertyConfig;
import ru.yandex.qatools.allure.jenkins.config.ReportBuildPolicy;
import ru.yandex.qatools.allure.jenkins.config.ResultsConfig;

public class AllureReportConfig
implements Serializable {
    private String jdk;
    private String commandline;
    @Deprecated
    private String resultsPattern;
    private List<PropertyConfig> properties = new ArrayList<PropertyConfig>();
    private List<ResultsConfig> results;
    private ReportBuildPolicy reportBuildPolicy = ReportBuildPolicy.ALWAYS;
    private Boolean includeProperties = Boolean.TRUE;
    private String configPath = "";

    @DataBoundConstructor
    public AllureReportConfig(List<ResultsConfig> results) {
        this.results = results == null ? Collections.emptyList() : results;
    }

    @DataBoundSetter
    public void setJdk(String jdk) {
        this.jdk = jdk;
    }

    public String getJdk() {
        return this.jdk;
    }

    @DataBoundSetter
    public void setCommandline(String commandline) {
        this.commandline = commandline;
    }

    public String getCommandline() {
        return this.commandline;
    }

    @Nonnull
    public List<ResultsConfig> getResults() {
        if (StringUtils.isNotBlank((String)this.resultsPattern)) {
            this.results = AllureReportConfig.convertPaths(this.resultsPattern);
            this.resultsPattern = null;
        }
        return this.results;
    }

    public List<PropertyConfig> getProperties() {
        return this.properties;
    }

    @DataBoundSetter
    public void setProperties(List<PropertyConfig> properties) {
        this.properties = properties;
    }

    public ReportBuildPolicy getReportBuildPolicy() {
        return this.reportBuildPolicy;
    }

    @DataBoundSetter
    public void setReportBuildPolicy(ReportBuildPolicy reportBuildPolicy) {
        this.reportBuildPolicy = reportBuildPolicy;
    }

    @DataBoundSetter
    public void setIncludeProperties(Boolean includeProperties) {
        this.includeProperties = includeProperties;
    }

    @DataBoundSetter
    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    public Boolean getIncludeProperties() {
        return this.includeProperties;
    }

    public static AllureReportConfig newInstance(List<String> results) {
        return AllureReportConfig.newInstance(null, null, null, results.toArray(new String[0]));
    }

    public static AllureReportConfig newInstance(String jdk, String commandline, String configPath, String ... paths) {
        return AllureReportConfig.newInstance(jdk, commandline, configPath, Arrays.asList(paths));
    }

    private static AllureReportConfig newInstance(String jdk, String commandline, String configPath, List<String> paths) {
        List<ResultsConfig> results = AllureReportConfig.convertPaths(paths);
        AllureReportConfig config = new AllureReportConfig(results);
        config.setJdk(jdk);
        config.setCommandline(commandline);
        config.setIncludeProperties(true);
        config.setConfigPath(configPath);
        return config;
    }

    private static List<ResultsConfig> convertPaths(String paths) {
        return AllureReportConfig.convertPaths(Arrays.asList(paths.split("\\n")));
    }

    private static List<ResultsConfig> convertPaths(List<String> paths) {
        return paths.stream().map(ResultsConfig::new).collect(Collectors.toList());
    }
}

