/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tools.ToolDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest;
import ru.yandex.qatools.allure.jenkins.AllureReportPublisher;
import ru.yandex.qatools.allure.jenkins.Messages;
import ru.yandex.qatools.allure.jenkins.config.PropertyConfig;
import ru.yandex.qatools.allure.jenkins.config.ReportBuildPolicy;
import ru.yandex.qatools.allure.jenkins.tools.AllureCommandlineInstallation;

@Extension
@Symbol(value={"allure"})
public class AllureReportPublisherDescriptor
extends BuildStepDescriptor<Publisher> {
    private static final String PROPERTIES = "properties";
    private List<PropertyConfig> properties;

    public AllureReportPublisherDescriptor() {
        super(AllureReportPublisher.class);
        this.load();
    }

    public List<PropertyConfig> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyConfig>();
        }
        return this.properties;
    }

    public void setProperties(List<PropertyConfig> properties) {
        this.properties = properties;
    }

    @Nonnull
    public String getDisplayName() {
        return Messages.AllureReportPublisher_DisplayName();
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return true;
    }

    public ReportBuildPolicy[] getReportBuildPolicies() {
        return ReportBuildPolicy.values();
    }

    @Nonnull
    public AutoCompletionCandidates doAutoCompletePropertyKey() {
        AutoCompletionCandidates candidates = new AutoCompletionCandidates();
        candidates.add("allure.issues.tracker.pattern");
        candidates.add("allure.tests.management.pattern");
        return candidates;
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        try {
            if (json.has(PROPERTIES)) {
                String jsonProperties = JSONObject.fromObject((Object)json).get(PROPERTIES).toString();
                ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
                List properties = (List)mapper.readValue(jsonProperties, (TypeReference)new TypeReference<List<PropertyConfig>>(){});
                this.setProperties(properties);
                this.save();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Nonnull
    public List<AllureCommandlineInstallation> getCommandlineInstallations() {
        return Optional.of(Jenkins.get()).map(j -> (AllureCommandlineInstallation.DescriptorImpl)j.getDescriptorByType(AllureCommandlineInstallation.DescriptorImpl.class)).map(ToolDescriptor::getInstallations).map(Arrays::asList).orElse(Collections.emptyList());
    }

    public AllureCommandlineInstallation getCommandlineInstallation(String name) {
        List<AllureCommandlineInstallation> installations = this.getCommandlineInstallations();
        if (CollectionUtils.isEmpty(installations)) {
            return null;
        }
        return installations.stream().filter(installation -> installation.getName().equals(name)).findFirst().orElse(installations.get(0));
    }
}

