/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.allure.jenkins;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import ru.yandex.qatools.allure.jenkins.AllureReportBuildAction;
import ru.yandex.qatools.allure.jenkins.AllureReportProjectAction;
import ru.yandex.qatools.allure.jenkins.AllureReportPublisherDescriptor;
import ru.yandex.qatools.allure.jenkins.ReportBuilder;
import ru.yandex.qatools.allure.jenkins.callables.AddExecutorInfo;
import ru.yandex.qatools.allure.jenkins.callables.AddTestRunInfo;
import ru.yandex.qatools.allure.jenkins.callables.FindByGlob;
import ru.yandex.qatools.allure.jenkins.config.AllureReportConfig;
import ru.yandex.qatools.allure.jenkins.config.PropertyConfig;
import ru.yandex.qatools.allure.jenkins.config.ReportBuildPolicy;
import ru.yandex.qatools.allure.jenkins.config.ResultsConfig;
import ru.yandex.qatools.allure.jenkins.exception.AllurePluginException;
import ru.yandex.qatools.allure.jenkins.tools.AllureCommandlineInstallation;
import ru.yandex.qatools.allure.jenkins.utils.BuildUtils;
import ru.yandex.qatools.allure.jenkins.utils.FilePathUtils;
import ru.yandex.qatools.allure.jenkins.utils.TrueZipArchiver;
import ru.yandex.qatools.allure.jenkins.utils.ZipUtils;

public class AllureReportPublisher
extends Recorder
implements SimpleBuildStep,
Serializable,
MatrixAggregatable {
    private static final String ALLURE_PREFIX = "allure";
    private static final String ALLURE_SUFFIX = "results";
    private static final String REPORT_ARCHIVE_NAME = "allure-report.zip";
    private AllureReportConfig config;
    private String configPath;
    private String jdk;
    private String commandline;
    private List<PropertyConfig> properties = new ArrayList<PropertyConfig>();
    private List<ResultsConfig> results;
    private ReportBuildPolicy reportBuildPolicy;
    private Boolean includeProperties;
    private Boolean disabled;
    private String report;

    @DataBoundConstructor
    public AllureReportPublisher(@Nonnull List<ResultsConfig> results) {
        this.results = results;
    }

    public List<ResultsConfig> getResults() {
        if (this.results == null && this.config != null) {
            this.results = this.config.getResults();
        }
        return this.results;
    }

    public boolean isDisabled() {
        return this.disabled == null ? Boolean.FALSE : this.disabled;
    }

    @DataBoundSetter
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @DataBoundSetter
    public void setConfig(AllureReportConfig config) {
        this.config = config;
    }

    @DataBoundSetter
    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    @DataBoundSetter
    public void setJdk(String jdk) {
        this.jdk = jdk;
    }

    public String getJdk() {
        if (this.jdk == null && this.config != null) {
            this.jdk = this.config.getJdk();
        }
        return this.jdk;
    }

    @DataBoundSetter
    public void setCommandline(String commandline) {
        this.commandline = commandline;
    }

    public String getCommandline() {
        if (this.commandline == null && this.config != null) {
            this.commandline = this.config.getCommandline();
        }
        return this.commandline;
    }

    private AllureCommandlineInstallation getCommandline(@Nonnull Launcher launcher, @Nonnull TaskListener listener, @Nonnull EnvVars env) throws IOException, InterruptedException {
        AllureCommandlineInstallation installation = this.getDescriptor().getCommandlineInstallation(this.getCommandline());
        if (installation == null) {
            throw new AllurePluginException("Can not find any allure commandline installation.");
        }
        AllureCommandlineInstallation tool = BuildUtils.setUpTool(installation, launcher, listener, env);
        if (tool == null) {
            throw new AllurePluginException("Can not find any allure commandline installation for given environment.");
        }
        return tool;
    }

    @DataBoundSetter
    public void setProperties(List<PropertyConfig> properties) {
        this.properties = properties;
    }

    public List<PropertyConfig> getProperties() {
        if (this.config != null) {
            this.properties = this.config.getProperties();
        }
        return this.properties == null ? Collections.emptyList() : this.properties;
    }

    @DataBoundSetter
    public void setReportBuildPolicy(ReportBuildPolicy reportBuildPolicy) {
        this.reportBuildPolicy = reportBuildPolicy;
    }

    public ReportBuildPolicy getReportBuildPolicy() {
        if (this.reportBuildPolicy == null && this.config != null) {
            this.reportBuildPolicy = this.config.getReportBuildPolicy();
        }
        return this.reportBuildPolicy == null ? ReportBuildPolicy.ALWAYS : this.reportBuildPolicy;
    }

    @DataBoundSetter
    public void setIncludeProperties(Boolean includeProperties) {
        this.includeProperties = includeProperties;
    }

    public Boolean getIncludeProperties() {
        if (this.includeProperties == null && this.config != null) {
            this.includeProperties = this.config.getIncludeProperties();
        }
        return this.includeProperties == null ? Boolean.TRUE : this.includeProperties;
    }

    @DataBoundSetter
    public void setReport(String report) {
        this.report = report;
    }

    public String getReport() {
        return this.report == null ? "allure-report" : this.report;
    }

    public String getConfigPath() {
        return StringUtils.isNotBlank((String)this.configPath) ? this.configPath : null;
    }

    @Nonnull
    public AllureReportConfig getConfig() {
        return this.config;
    }

    @Nonnull
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Nonnull
    public AllureReportPublisherDescriptor getDescriptor() {
        return (AllureReportPublisherDescriptor)super.getDescriptor();
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        if (this.isDisabled()) {
            listener.getLogger().println("Allure report is disabled.");
            return;
        }
        List<ResultsConfig> resultsConfigs = this.getResults();
        if (resultsConfigs == null) {
            throw new AllurePluginException("The property 'Results' have to be specified! Check your job's configuration.");
        }
        ArrayList<FilePath> results = new ArrayList<FilePath>();
        EnvVars buildEnvVars = BuildUtils.getBuildEnvVars(run, listener);
        for (ResultsConfig resultsConfig : resultsConfigs) {
            String expandedPath = buildEnvVars.expand(resultsConfig.getPath());
            results.addAll((Collection)workspace.act((FilePath.FileCallable)new FindByGlob(expandedPath)));
        }
        this.prepareResults(results, run, workspace, listener);
        this.generateReport(results, run, workspace, launcher, listener);
        this.copyResultsToParentIfNeeded(results, run, listener);
    }

    private void copyResultsToParentIfNeeded(@Nonnull List<FilePath> results, @Nonnull Run<?, ?> run, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        if (run instanceof MatrixRun) {
            MatrixBuild parentBuild = ((MatrixRun)run).getParentBuild();
            FilePath workspace = parentBuild.getWorkspace();
            if (workspace == null) {
                listener.getLogger().format("Can not find workspace for parent build %s", parentBuild.getDisplayName());
                return;
            }
            FilePath aggregationDir = workspace.createTempDir(ALLURE_PREFIX, ALLURE_SUFFIX);
            listener.getLogger().format("Copy matrix build results to directory [%s]", aggregationDir);
            for (FilePath resultsPath : results) {
                FilePathUtils.copyRecursiveTo(resultsPath, aggregationDir, (AbstractBuild)parentBuild, listener.getLogger());
            }
        }
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        final FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            return null;
        }
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                ArrayList<FilePath> resultsPaths = new ArrayList<FilePath>();
                for (FilePath directory : workspace.listDirectories()) {
                    if (!directory.getName().startsWith(AllureReportPublisher.ALLURE_PREFIX) || !directory.getName().contains(AllureReportPublisher.ALLURE_SUFFIX)) continue;
                    resultsPaths.add(directory);
                }
                AllureReportPublisher.this.generateReport((List<FilePath>)resultsPaths, (Run<?, ?>)this.build, workspace, this.launcher, (TaskListener)this.listener);
                for (FilePath resultsPath : resultsPaths) {
                    FilePathUtils.deleteRecursive(resultsPath, this.listener.getLogger());
                }
                return true;
            }
        };
    }

    private void generateReport(@Nonnull List<FilePath> resultsPaths, @Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        int exitCode;
        ReportBuildPolicy reportBuildPolicy = this.getReportBuildPolicy();
        if (!reportBuildPolicy.isNeedToBuildReport(run)) {
            listener.getLogger().printf("Allure report generation reject by policy [%s]%n", reportBuildPolicy.getTitle());
            return;
        }
        EnvVars buildEnvVars = BuildUtils.getBuildEnvVars(run, listener);
        this.setAllureProperties(buildEnvVars);
        this.configureJdk(launcher, listener, buildEnvVars);
        AllureCommandlineInstallation commandline = this.getCommandline(launcher, listener, buildEnvVars);
        FilePath reportPath = workspace.child(this.getReport());
        ReportBuilder builder = new ReportBuilder(launcher, listener, workspace, buildEnvVars, commandline);
        if (this.getConfigPath() != null && workspace.child(this.getConfigPath()).exists()) {
            FilePath configFilePath = workspace.child(this.getConfigPath()).absolutize();
            listener.getLogger().println("Allure config file: " + configFilePath.absolutize());
            builder.setConfigFilePath(configFilePath);
        }
        if ((exitCode = builder.build(resultsPaths, reportPath)) != 0) {
            throw new AllurePluginException("Can not generate Allure Report, exit code: " + exitCode);
        }
        listener.getLogger().println("Allure report was successfully generated.");
        this.saveAllureArtifact(run, workspace, listener);
        AllureReportBuildAction buildAction = new AllureReportBuildAction(FilePathUtils.extractSummary(run, reportPath.getName()));
        buildAction.setReportPath(reportPath);
        run.addAction((Action)buildAction);
        run.setResult(buildAction.getBuildSummary().getResult());
    }

    private void saveAllureArtifact(Run<?, ?> run, FilePath workspace, TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println("Creating artifact for the build.");
        File artifactsDir = run.getArtifactsDir();
        Files.createDirectories(artifactsDir.toPath(), new FileAttribute[0]);
        File archive = new File(artifactsDir, REPORT_ARCHIVE_NAME);
        File tempArchive = new File(archive.getAbsolutePath() + ".writing.zip");
        FilePath reportPath = workspace.child(this.getReport());
        try (OutputStream os = Files.newOutputStream(tempArchive.toPath(), new OpenOption[0]);){
            Objects.requireNonNull(reportPath.getParent()).archive(TrueZipArchiver.FACTORY, os, reportPath.getName() + "/**");
        }
        Files.move(tempArchive.toPath(), archive.toPath(), new CopyOption[0]);
        listener.getLogger().println("Artifact was added to the build.");
    }

    private void setAllureProperties(EnvVars envVars) {
        StringBuilder options = new StringBuilder();
        HashMap<String, String> properties = new HashMap<String, String>();
        for (PropertyConfig propertyConfig : this.getDescriptor().getProperties()) {
            properties.put(propertyConfig.getKey(), propertyConfig.getValue());
        }
        for (PropertyConfig propertyConfig : this.getProperties()) {
            properties.put(propertyConfig.getKey(), propertyConfig.getValue());
        }
        for (Map.Entry entry : properties.entrySet()) {
            String value = envVars.expand((String)entry.getValue());
            options.append(String.format("\"-D%s=%s\" ", entry.getKey(), value));
        }
        envVars.put("ALLURE_OPTS", options.toString());
    }

    @Nonnull
    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singleton(new AllureReportProjectAction((Job<?, ?>)project));
    }

    private void prepareResults(@Nonnull List<FilePath> resultsPaths, @Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        this.addHistory(resultsPaths, run, workspace, listener);
        this.addTestRunInfo(resultsPaths, run);
        this.addExecutorInfo(resultsPaths, run);
    }

    private void addTestRunInfo(@Nonnull List<FilePath> resultsPaths, @Nonnull Run<?, ?> run) throws IOException, InterruptedException {
        long start = run.getStartTimeInMillis();
        long stop = run.getTimeInMillis();
        for (FilePath path : resultsPaths) {
            path.act((FilePath.FileCallable)new AddTestRunInfo(run.getFullDisplayName(), start, stop));
        }
    }

    private void addExecutorInfo(@Nonnull List<FilePath> resultsPaths, @Nonnull Run<?, ?> run) throws IOException, InterruptedException {
        String rootUrl = Jenkins.get().getRootUrl();
        String buildUrl = rootUrl + run.getUrl();
        String reportUrl = buildUrl + ALLURE_PREFIX;
        String buildId = run.getId();
        AddExecutorInfo callable = new AddExecutorInfo(rootUrl, run.getFullDisplayName(), buildUrl, reportUrl, buildId);
        for (FilePath path : resultsPaths) {
            path.act((FilePath.FileCallable)callable);
        }
    }

    private void addHistory(@Nonnull List<FilePath> resultsPaths, @Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull TaskListener listener) {
        try {
            String reportPath = workspace.child(this.getReport()).getName();
            FilePath previousReport = FilePathUtils.getPreviousReportWithHistory(run, reportPath);
            if (previousReport == null) {
                return;
            }
            this.copyHistoryToResultsPaths(resultsPaths, previousReport, workspace);
        }
        catch (Exception e) {
            listener.getLogger().println("Cannot find a history information about previous builds.");
            listener.getLogger().println(e);
        }
    }

    private void copyHistoryToResultsPaths(@Nonnull List<FilePath> resultsPaths, @Nonnull FilePath previousReport, @Nonnull FilePath workspace) throws IOException, InterruptedException {
        try (ZipFile archive = new ZipFile(previousReport.getRemote());){
            for (FilePath resultsPath : resultsPaths) {
                this.copyHistoryToResultsPath(archive, resultsPath, workspace);
            }
        }
    }

    private void copyHistoryToResultsPath(ZipFile archive, @Nonnull FilePath resultsPath, @Nonnull FilePath workspace) throws IOException, InterruptedException {
        FilePath reportPath = workspace.child(this.getReport());
        for (ZipEntry historyEntry : ZipUtils.listEntries(archive, reportPath.getName() + "/history")) {
            String historyFile = historyEntry.getName().replace(reportPath.getName() + "/", "");
            InputStream entryStream = archive.getInputStream(historyEntry);
            try {
                FilePath historyCopy = resultsPath.child(historyFile);
                historyCopy.copyFrom(entryStream);
            }
            finally {
                if (entryStream == null) continue;
                entryStream.close();
            }
        }
    }

    @Nullable
    private JDK getJdkInstallation() {
        return Jenkins.get().getJDK(this.getJdk());
    }

    private void configureJdk(Launcher launcher, TaskListener listener, EnvVars env) throws IOException, InterruptedException {
        JDK jdk = BuildUtils.setUpTool(this.getJdkInstallation(), launcher, listener, env);
        if (jdk != null) {
            jdk.buildEnvVars(env);
        }
    }
}

