/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jenkins.plugins.debuilder;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildBadgeAction;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.git.GitSCM;
import hudson.remoting.Callable;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ComboBoxModel;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import ru.yandex.jenkins.plugins.debuilder.DebUtils;
import ru.yandex.jenkins.plugins.debuilder.DebianBadge;
import ru.yandex.jenkins.plugins.debuilder.DebianPackageBuilder;
import ru.yandex.jenkins.plugins.debuilder.DebianPackageRepo;
import ru.yandex.jenkins.plugins.debuilder.DebianizingException;
import ru.yandex.jenkins.plugins.debuilder.GitCommitHelper;
import ru.yandex.jenkins.plugins.debuilder.SVNCommitHelper;

public class DebianPackagePublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PREFIX = "debian-package-publisher";
    private String repoId;
    private String commitMessage;
    private final boolean commitChanges;

    @DataBoundConstructor
    public DebianPackagePublisher(String repoId, String commitMessage, boolean commitChanges) {
        this.commitChanges = commitChanges;
        this.commitMessage = commitMessage;
        this.repoId = repoId;
    }

    private DebianPackageRepo getRepo(AbstractBuild<?, ?> build, DebUtils.Runner runner) throws IOException, InterruptedException {
        String expandedRepo = build.getEnvironment((TaskListener)runner.getListener()).expand(this.repoId);
        for (DebianPackageRepo repo : this.getDescriptor().getRepositories()) {
            if (!repo.getName().equals(expandedRepo)) continue;
            return repo;
        }
        throw new IllegalArgumentException(MessageFormat.format("Repo {0} is not found in global configuration", expandedRepo));
    }

    public static String getUsedCommitMessage(AbstractBuild build) {
        DescribableList publishersList = ((Project)build.getProject()).getPublishersList();
        for (Publisher publisher : publishersList) {
            if (!(publisher instanceof DebianPackagePublisher)) continue;
            return ((DebianPackagePublisher)publisher).commitMessage;
        }
        return "";
    }

    private FilePath getRemoteKeyPath(AbstractBuild<?, ?> build, DebUtils.Runner runner) throws IOException, InterruptedException {
        String keysDir = "debian-package-builder-keys";
        String relativeKeyPath = new File(keysDir, this.getRepo(build, runner).getKeypath()).getPath();
        File absoluteKeyPath = new File(Jenkins.getInstance().getRootDir(), relativeKeyPath);
        FilePath localKey = new FilePath(absoluteKeyPath);
        FilePath remoteKey = build.getWorkspace().createTextTempFile("private", "key", localKey.readToString());
        remoteKey.chmod(384);
        return remoteKey;
    }

    private FilePath[] generateDuploadConf(AbstractBuild<?, ?> build, DebUtils.Runner runner) throws IOException, InterruptedException, DebianizingException {
        String confTemplate = "package config;\n\n$default_host = '${name}';\n\n$cfg{'${name}'} = {\n\tlogin => '${login}',\n\tfqdn => '${fqdn}',\n\tmethod => '${method}',\n\tincoming => '${incoming}',\n\tdinstall_runs => 0,\n\toptions => '${options}',\n};\n\n1;\n";
        HashMap<String, String> values = new HashMap<String, String>();
        DebianPackageRepo repo = this.getRepo(build, runner);
        FilePath keyPath = this.getRemoteKeyPath(build, runner);
        values.put("name", repo.getName());
        values.put("method", repo.getMethod());
        values.put("fqdn", repo.getFqdn());
        values.put("incoming", repo.getIncoming());
        values.put("login", repo.getLogin());
        values.put("options", MessageFormat.format("-i {0} ", keyPath.getRemote()) + repo.getOptions());
        StrSubstitutor substitutor = new StrSubstitutor(values);
        String conf = substitutor.replace(confTemplate);
        FilePath duploadConf = build.getWorkspace().createTempFile("dupload", "conf");
        duploadConf.touch(System.currentTimeMillis() / 1000L);
        duploadConf.write(conf, "UTF-8");
        return new FilePath[]{duploadConf, keyPath};
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException {
        block25: {
            PrintStream logger = listener.getLogger();
            if (build.getResult().isWorseThan(Result.SUCCESS)) {
                logger.println(MessageFormat.format("[{0}] Aborting: {1} ", PREFIX, "Build is not success, will not execute debrelease"));
                return true;
            }
            DebUtils.Runner runner = new DebUtils.Runner(build, launcher, listener, PREFIX);
            FilePath[] tempFiles = null;
            try {
                runner.runCommand("sudo apt-get -y install dupload devscripts");
                tempFiles = this.generateDuploadConf(build, runner);
                String duploadConf = tempFiles[0].getRemote();
                ArrayList<String> builtModules = new ArrayList<String>();
                for (BuildBadgeAction action : build.getBadgeActions()) {
                    if (!(action instanceof DebianBadge)) continue;
                    builtModules.add(((DebianBadge)action).getModule());
                }
                boolean wereBuilds = false;
                for (String module : DebianPackageBuilder.getRemoteModules(build, runner)) {
                    if (!builtModules.contains(new FilePath(build.getWorkspace().getChannel(), module).child("debian").getRemote())) {
                        runner.announce("Module in {0} was not built - not releasing", module);
                        continue;
                    }
                    if (!runner.runCommandForResult("cd ''{0}'' && cp ''{1}'' dupload.conf && trap ''rm -f dupload.conf'' EXIT && debrelease -c", module, duploadConf)) {
                        throw new DebianizingException("Debrelease failed");
                    }
                    wereBuilds = true;
                }
                if (wereBuilds && this.commitChanges) {
                    String expandedCommitMessage = this.getExpandedCommitMessage(build, listener);
                    this.commitChanges(build, runner, expandedCommitMessage);
                }
                if (tempFiles == null) break block25;
            }
            catch (InterruptedException e) {
                logger.println(MessageFormat.format("[{0}] Aborting: {1} ", PREFIX, e.getMessage()));
                build.setResult(Result.UNSTABLE);
                if (tempFiles == null) break block25;
                for (FilePath tempFile : tempFiles) {
                    try {
                        tempFile.delete();
                    }
                    catch (InterruptedException e2) {
                        logger.println(MessageFormat.format("[{0}] Error deleting {1}: {2}", PREFIX, tempFile.getRemote(), e2.getMessage()));
                    }
                }
            }
            for (FilePath tempFile : tempFiles) {
                try {
                    tempFile.delete();
                }
                catch (InterruptedException e) {
                    logger.println(MessageFormat.format("[{0}] Error deleting {1}: {2}", PREFIX, tempFile.getRemote(), e.getMessage()));
                }
            }
            break block25;
            break block25;
            catch (DebianizingException e) {
                logger.println(MessageFormat.format("[{0}] Aborting: {1} ", PREFIX, e.getMessage()));
                build.setResult(Result.UNSTABLE);
                if (tempFiles == null) break block25;
                for (FilePath tempFile : tempFiles) {
                    try {
                        tempFile.delete();
                    }
                    catch (InterruptedException e3) {
                        logger.println(MessageFormat.format("[{0}] Error deleting {1}: {2}", PREFIX, tempFile.getRemote(), e3.getMessage()));
                    }
                }
                {
                    catch (Throwable throwable) {
                        if (tempFiles != null) {
                            for (FilePath tempFile : tempFiles) {
                                try {
                                    tempFile.delete();
                                }
                                catch (InterruptedException e4) {
                                    logger.println(MessageFormat.format("[{0}] Error deleting {1}: {2}", PREFIX, tempFile.getRemote(), e4.getMessage()));
                                }
                            }
                        }
                        throw throwable;
                    }
                }
            }
        }
        return true;
    }

    private String getExpandedCommitMessage(AbstractBuild<?, ?> build, BuildListener listener) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        return env.expand(this.getCommitMessage());
    }

    private void commitChanges(AbstractBuild<?, ?> build, DebUtils.Runner runner, String commitMessage) throws DebianizingException, IOException, InterruptedException {
        SCM scm = build.getProject().getScm();
        if (scm instanceof SubversionSCM) {
            this.commitToSVN(build, runner, (SubversionSCM)scm, commitMessage);
        } else if (scm instanceof GitSCM) {
            this.commitToGitAndPush(build, runner, (GitSCM)scm, commitMessage);
        } else {
            throw new DebianizingException("SCM used is not a know one but " + scm.getType());
        }
    }

    private void commitToGitAndPush(AbstractBuild<?, ?> build, DebUtils.Runner runner, GitSCM scm, String commitMessage) throws DebianizingException {
        try {
            GitCommitHelper helper = new GitCommitHelper(build, scm, runner, commitMessage, DebianPackageBuilder.getRemoteModules(build, runner));
            if (!((Boolean)build.getWorkspace().act((FilePath.FileCallable)helper)).booleanValue()) {
                throw new DebianizingException("Failed to commit to git");
            }
            runner.announce("Successfully commited to git");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void commitToSVN(AbstractBuild<?, ?> build, DebUtils.Runner runner, SubversionSCM svn, String commitMessage) throws DebianizingException {
        SubversionSCM.DescriptorImpl descriptor = (SubversionSCM.DescriptorImpl)Jenkins.getInstance().getDescriptor(SubversionSCM.class);
        ISVNAuthenticationProvider authenticationProvider = descriptor.createAuthenticationProvider(build.getProject());
        try {
            for (String module : DebianPackageBuilder.getRemoteModules(build, runner)) {
                SVNCommitHelper helper = new SVNCommitHelper(authenticationProvider, module, commitMessage);
                runner.announce("Commited revision <{0}> of <{2}> with message <{1}>", runner.getChannel().call((Callable)helper), commitMessage, module);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DebianizingException("IOException: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new DebianizingException("Interrupted: " + e.getMessage(), e);
        }
    }

    public boolean needsToRunAfterFinalized() {
        return false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean isCommitChanges() {
        return this.commitChanges;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public String getRepoId() {
        return this.repoId;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private List<DebianPackageRepo> repos = new ArrayList<DebianPackageRepo>();

        public DescriptorImpl() {
            this.load();
        }

        public ArrayList<DebianPackageRepo> getRepositories() {
            return new ArrayList<DebianPackageRepo>(this.repos);
        }

        public ComboBoxModel doFillRepoIdItems() {
            ComboBoxModel model = new ComboBoxModel();
            for (DebianPackageRepo repo : this.repos) {
                model.add((Object)repo.getName());
            }
            return model;
        }

        public FormValidation doCheckRepoId(final @Nonnull @QueryParameter String repoId) {
            if (repoId.contains("$")) {
                return FormValidation.warning((String)"The actual repository will be determined at run-time, take care");
            }
            if (Collections2.filter(this.getRepositories(), (Predicate)new Predicate<DebianPackageRepo>(){

                public boolean apply(DebianPackageRepo repo) {
                    return repoId.equals(repo.getName());
                }
            }).size() == 0) {
                return FormValidation.error((String)"There is no such repository configured");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckMethod(@QueryParameter String method) {
            if (method != "scpb") {
                return FormValidation.error((String)"This method is not supported yet");
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.repos = req.bindJSONToList(DebianPackageRepo.class, formData.get("repositories"));
            this.save();
            return super.configure(req, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Publish debian packages";
        }
    }
}

