/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.jenkins.plugins.debuilder;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Environment;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jedi.functional.FunctionalPrimitives;
import jedi.functional.Functor;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;
import ru.yandex.jenkins.plugins.debuilder.ChangesExtractor;
import ru.yandex.jenkins.plugins.debuilder.DebUtils;
import ru.yandex.jenkins.plugins.debuilder.DebianBadge;
import ru.yandex.jenkins.plugins.debuilder.DebianPackagePublisher;
import ru.yandex.jenkins.plugins.debuilder.DebianizingException;
import ru.yandex.jenkins.plugins.debuilder.VersionHelper;

public class DebianPackageBuilder
extends Builder {
    public static final String DEBIAN_SOURCE_PACKAGE = "DEBIAN_SOURCE_PACKAGE";
    public static final String DEBIAN_PACKAGE_VERSION = "DEBIAN_PACKAGE_VERSION";
    public static final String ABORT_MESSAGE = "[{0}] Aborting: {1} ";
    private static final String PREFIX = "debian-package-builder";
    private final String pathToDebian;
    private final String nextVersion;
    private final boolean generateChangelog;
    private final boolean signPackage;
    private final boolean buildEvenWhenThereAreNoChanges;

    @DataBoundConstructor
    public DebianPackageBuilder(String pathToDebian, String nextVersion, Boolean generateChangelog, Boolean signPackage, Boolean buildEvenWhenThereAreNoChanges) {
        this.pathToDebian = pathToDebian;
        this.nextVersion = nextVersion;
        this.generateChangelog = generateChangelog;
        this.signPackage = signPackage;
        this.buildEvenWhenThereAreNoChanges = buildEvenWhenThereAreNoChanges;
    }

    public String getPathToDebian() {
        return this.pathToDebian;
    }

    public String getNextVersion() {
        return this.nextVersion;
    }

    public boolean isGenerateChangelog() {
        return this.generateChangelog;
    }

    public boolean isSignPackage() {
        return this.signPackage;
    }

    public boolean isBuildEvenWhenThereAreNoChanges() {
        return this.buildEvenWhenThereAreNoChanges;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        FilePath workspace = build.getWorkspace();
        DebUtils.Runner runner = this.makeRunner(build, launcher, listener);
        try {
            String remoteDebian = this.getRemoteDebian(build, runner);
            runner.runCommand("sudo apt-get -y update");
            runner.runCommand("sudo apt-get -y install aptitude pbuilder");
            this.importKeys(workspace, runner);
            Map<String, String> changelog = this.parseChangelog(runner, remoteDebian);
            String source = changelog.get("Source");
            String latestVersion = changelog.get("Version");
            String distribution = changelog.get("Distribution");
            runner.announce("Determined latest version to be {0}", latestVersion);
            if (this.generateChangelog) {
                Pair<VersionHelper, List<ChangesExtractor.Change>> changes = this.generateChangelog(latestVersion, runner, build, remoteDebian);
                if (this.isTriggeredAutomatically(build) && ((List)changes.getRight()).isEmpty() && !this.buildEvenWhenThereAreNoChanges) {
                    runner.announce("There are no creditable changes for this build - not building package.");
                    return true;
                }
                latestVersion = ((VersionHelper)changes.getLeft()).toString();
                this.writeChangelog(build, listener, remoteDebian, runner, changes, distribution);
            }
            runner.runCommand("cd ''{0}'' && sudo /usr/lib/pbuilder/pbuilder-satisfydepends --control control", remoteDebian);
            String package_command = String.format("cd '%1$s' && debuild --check-dirname-level 0 --no-tgz-check ", remoteDebian);
            package_command = this.signPackage ? package_command + String.format("-k%1$s -p'gpg --no-tty --passphrase %2$s'", this.getDescriptor().getAccountEmail(), this.getDescriptor().getPassphrase()) : package_command + "-us -uc";
            runner.runCommand(package_command);
            this.archiveArtifacts(build, runner, latestVersion);
            build.addAction((Action)new DebianBadge(latestVersion, remoteDebian));
            EnvVars envVars = new EnvVars(new String[]{DEBIAN_SOURCE_PACKAGE, source, DEBIAN_PACKAGE_VERSION, latestVersion});
            build.getEnvironments().add((Object)Environment.create((EnvVars)envVars));
        }
        catch (InterruptedException e) {
            logger.println(MessageFormat.format(ABORT_MESSAGE, PREFIX, e.getMessage()));
            return false;
        }
        catch (DebianizingException e) {
            logger.println(MessageFormat.format(ABORT_MESSAGE, PREFIX, e.getMessage()));
            return false;
        }
        catch (IOException e) {
            logger.println(MessageFormat.format(ABORT_MESSAGE, PREFIX, e.getMessage()));
            return false;
        }
        return true;
    }

    DebUtils.Runner makeRunner(AbstractBuild build, Launcher launcher, BuildListener listener) {
        DebUtils.Runner runner = new DebUtils.Runner(build, launcher, listener, PREFIX);
        return runner;
    }

    private void archiveArtifacts(AbstractBuild build, DebUtils.Runner runner, String latestVersion) throws IOException, InterruptedException {
        FilePath path = build.getWorkspace().child(this.pathToDebian).child("..");
        String mask = "*" + latestVersion + "*.deb";
        for (FilePath file : path.list(mask)) {
            runner.announce("Archiving file <{0}> as a build artifact", file.getName());
        }
        path.copyRecursiveTo(mask, new FilePath(build.getArtifactsDir()));
    }

    public String getRemoteDebian(AbstractBuild build, DebUtils.Runner runner) throws DebianizingException {
        FilePath workspace = build.getWorkspace();
        try {
            String expanded = build.getEnvironment((TaskListener)runner.getListener()).expand(this.pathToDebian);
            if (expanded.endsWith("debian") || expanded.endsWith("debian/")) {
                return workspace.child(expanded).getRemote();
            }
            return workspace.child(expanded).child("debian").getRemote();
        }
        catch (IOException cause) {
            throw new DebianizingException("Failed to get build environment", cause);
        }
        catch (InterruptedException cause) {
            throw new DebianizingException("Failed to get build environment", cause);
        }
    }

    Pair<VersionHelper, List<ChangesExtractor.Change>> generateChangelog(String latestVersion, DebUtils.Runner runner, AbstractBuild build, String remoteDebian) throws DebianizingException, InterruptedException, IOException {
        VersionHelper helper;
        EnvVars env = build.getEnvironment((TaskListener)runner.getListener());
        String nextVersion = env.expand(this.nextVersion);
        if (nextVersion == null || nextVersion.trim().isEmpty()) {
            helper = new VersionHelper(latestVersion);
            runner.announce("Determined latest revision to be {0}", helper.getRevision());
            helper.setMinorVersion(helper.getMinorVersion() + 1);
        } else {
            helper = new VersionHelper(nextVersion);
        }
        SCM scm = build.getProject().getScm();
        String ourMessage = DebianPackagePublisher.getUsedCommitMessage(build);
        List<ChangesExtractor.Change> changes = ChangesExtractor.getChanges(build, runner, scm, remoteDebian, ourMessage, helper);
        return new ImmutablePair((Object)helper, changes);
    }

    private void writeChangelog(AbstractBuild build, BuildListener listener, String remoteDebian, DebUtils.Runner runner, Pair<VersionHelper, List<ChangesExtractor.Change>> changes, String distribution) throws IOException, InterruptedException, DebianizingException {
        String versionMessage = this.getCausedMessage(build);
        String newVersionMessage = Util.replaceMacro((String)versionMessage, (VariableResolver)new VariableResolver.ByMap((Map)build.getEnvironment((TaskListener)listener)));
        this.startVersion(runner, remoteDebian, (VersionHelper)changes.getLeft(), newVersionMessage, distribution);
        for (ChangesExtractor.Change change : (List)changes.getRight()) {
            this.addChange(runner, remoteDebian, change, distribution);
        }
    }

    private boolean isTriggeredAutomatically(AbstractBuild build) {
        for (Object cause : build.getCauses()) {
            if (!(cause instanceof Cause.UserIdCause)) continue;
            return false;
        }
        return true;
    }

    private String getCausedMessage(AbstractBuild build) {
        String firstPart = "Build #${BUILD_NUMBER}. ";
        List causes = build.getCauses();
        List causeMessages = FunctionalPrimitives.map((List)causes, (Functor)new Functor<Cause, String>(){

            public String execute(Cause value) {
                return value.getShortDescription();
            }
        });
        HashSet uniqueCauses = new HashSet(causeMessages);
        return firstPart + FunctionalPrimitives.join(uniqueCauses, (String)". ") + ".";
    }

    private String clearMessage(String message) {
        return message.replaceAll("\\'", "");
    }

    private void addChange(DebUtils.Runner runner, String remoteDebian, ChangesExtractor.Change change, String distribution) throws InterruptedException, DebianizingException {
        runner.announce("Got changeset entry: {0} by {1}", this.clearMessage(change.getMessage()), change.getAuthor());
        runner.runCommand("export DEBEMAIL={0} && export DEBFULLNAME=''{1}'' && cd ''{2}'' && dch --check-dirname-level 0 --distribution ''{4}'' --append -- ''{3}''", this.getDescriptor().getAccountEmail(), change.getAuthor(), remoteDebian, this.clearMessage(change.getMessage()), distribution);
    }

    private void startVersion(DebUtils.Runner runner, String remoteDebian, VersionHelper helper, String message, String distribution) throws InterruptedException, DebianizingException {
        runner.announce("Starting version <{0}> with message <{1}>", helper, this.clearMessage(message));
        runner.runCommand("export DEBEMAIL={0} && export DEBFULLNAME=''{1}'' && cd ''{2}'' && dch --check-dirname-level 0 -b --distribution ''{5}'' --newVersion {3} -- ''{4}''", this.getDescriptor().getAccountEmail(), this.getDescriptor().getAccountName(), remoteDebian, helper, this.clearMessage(message), distribution);
    }

    Map<String, String> parseChangelog(DebUtils.Runner runner, String remoteDebian) throws DebianizingException {
        String changelogOutput = runner.runCommandForOutput("cd \"{0}\" && dpkg-parsechangelog -lchangelog", remoteDebian);
        HashMap<String, String> changelog = new HashMap<String, String>();
        Pattern changelogFormat = Pattern.compile("(\\w+):\\s*(.*)");
        for (String row : changelogOutput.split("\n")) {
            Matcher matcher = changelogFormat.matcher(row);
            if (!matcher.matches()) continue;
            changelog.put(matcher.group(1), matcher.group(2));
        }
        return changelog;
    }

    private void importKeys(FilePath workspace, DebUtils.Runner runner) throws InterruptedException, DebianizingException, IOException {
        if (!runner.runCommandForResult("gpg --list-key {0}", this.getDescriptor().getAccountEmail())) {
            FilePath publicKey = workspace.createTextTempFile("public", "key", this.getDescriptor().getPublicKey());
            runner.runCommand("gpg --import ''{0}''", publicKey.getRemote());
            publicKey.delete();
        }
        if (!runner.runCommandForResult("gpg --list-secret-key {0}", this.getDescriptor().getAccountEmail())) {
            FilePath privateKey = workspace.createTextTempFile("private", "key", this.getDescriptor().getPrivateKey());
            runner.runCommand("gpg --import ''{0}''", privateKey.getRemote());
            privateKey.delete();
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static Collection<String> getRemoteModules(AbstractBuild<?, ?> build, DebUtils.Runner runner) throws DebianizingException {
        ArrayList<String> result = new ArrayList<String>();
        for (DebianPackageBuilder builder : DebianPackageBuilder.getDPBuilders(build)) {
            result.add(new FilePath(build.getWorkspace().getChannel(), builder.getRemoteDebian(build, runner)).child("..").getRemote());
        }
        return result;
    }

    public static Collection<DebianPackageBuilder> getDPBuilders(AbstractBuild<?, ?> build) {
        ArrayList<DebianPackageBuilder> result = new ArrayList<DebianPackageBuilder>();
        if (build.getProject() instanceof Project) {
            DescribableList builders = ((Project)build.getProject()).getBuildersList();
            for (Builder builder : builders) {
                if (!(builder instanceof DebianPackageBuilder)) continue;
                result.add((DebianPackageBuilder)builder);
            }
        }
        return result;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String publicKey;
        private String privateKey;
        private String accountName;
        private String accountEmail;
        private String passphrase;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Build debian package";
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
            this.setPrivateKey(json.getString("privateKey"));
            this.setPublicKey(json.getString("publicKey"));
            this.setAccountName("Jenkins");
            this.setAccountEmail(json.getString("accountEmail"));
            this.setPassphrase(json.getString("passphrase"));
            this.save();
            return true;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }

        public void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getAccountEmail() {
            return this.accountEmail;
        }

        public void setAccountEmail(String accountEmail) {
            this.accountEmail = accountEmail;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public void setPassphrase(String passphrase) {
            this.passphrase = passphrase;
        }
    }
}

