/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.SecurityUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.User;
import hudson.model.View;
import hudson.scm.SCM;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import hudson.security.ProjectMatrixAuthorizationStrategy;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.PluginServletFilter;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.openshift.jenkins.plugins.openshiftlogin.OAuthSession;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftPermissionFilter;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftProviderInfo;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftSubjectAccessReviewRequest;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftSubjectAccessReviewResponse;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftUserInfo;

public class OpenShiftOAuth2SecurityRealm
extends SecurityRealm {
    static final Logger LOGGER = Logger.getLogger(OpenShiftOAuth2SecurityRealm.class.getName());
    private static final String SCOPE_INFO = "user:info";
    private static final String SCOPE_CHECK_ACCESS = "user:check-access";
    static final String DEFAULT_SVC_ACCT_DIR = "/run/secrets/kubernetes.io/serviceaccount";
    static final String DEFAULT_SVR_PREFIX = "https://openshift.default.svc";
    static final String NAMESPACE = "namespace";
    private static final String TOKEN = "token";
    private static final String CA_CRT = "ca.crt";
    private static final String FINISH_METHOD = "doFinishLogin";
    private static final String START_METHOD = "doCommenceLogin";
    private static final String DISPLAY_NAME = "Login with OpenShift";
    private static final String LOGIN_URL = "securityRealm/commenceLogin";
    private static final String[] ROLES = new String[]{"admin", "edit", "view"};
    private static final String USER_URI = "/oapi/v1/users/~";
    private static final String SAR_URI = "/oapi/v1/subjectaccessreviews";
    private static final String OAUTH_PROVIDER_URI = "/.well-known/oauth-authorization-server";
    private static final String K8S_HOST_ENV_VAR = "KUBERNETES_SERVICE_HOST";
    private static final String K8S_PORT_ENV_VAR = "KUBERNETES_SERVICE_PORT";
    private static final String LOGOUT = "logout";
    static final String LOGGING_OUT = "loggingOut";
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    static final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    private static final Object USER_UPDATE_LOCK = new Object();
    static String redirectUrl;
    static HttpTransport testTransport;
    private HttpTransport transport;
    private final String serviceAccountDirectory;
    private String defaultedServiceAccountDirectory;
    private final String serviceAccountName;
    private String defaultedServiceAccountName;
    private final String serverPrefix;
    private String defaultedServerPrefix;
    private final String redirectURL;
    private String defaultedRedirectURL;
    private final String clientId;
    private String defaultedClientId;
    private final Secret clientSecret;
    private String defaultedClientSecret;
    private String namespace;
    private OpenShiftProviderInfo provider;
    private OpenShiftPermissionFilter filter;

    @DataBoundConstructor
    public OpenShiftOAuth2SecurityRealm(String serviceAccountDirectory, String serviceAccountName, String serverPrefix, String clientId, String clientSecret, String redirectURL) throws IOException, GeneralSecurityException {
        HttpTransport transport = HTTP_TRANSPORT;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("ctor: incoming args sa dir %s sa name %s svr prefix %s client id %s client secret %s redirectURL %s", serviceAccountDirectory, serviceAccountName, serverPrefix, clientId, clientSecret, redirectURL));
        }
        String fixedServiceAccountDirectory = Util.fixEmpty((String)serviceAccountDirectory);
        this.clientId = Util.fixEmpty((String)clientId);
        this.clientSecret = Util.fixEmpty((String)clientSecret) != null ? Secret.fromString((String)clientSecret) : null;
        this.defaultedServerPrefix = DEFAULT_SVR_PREFIX;
        this.serverPrefix = Util.fixEmpty((String)serverPrefix);
        this.redirectURL = Util.fixEmpty((String)redirectURL);
        this.defaultedServiceAccountDirectory = DEFAULT_SVC_ACCT_DIR;
        this.serviceAccountDirectory = fixedServiceAccountDirectory;
        this.serviceAccountName = Util.fixEmpty((String)serviceAccountName);
        this.transport = transport;
        if (testTransport != null) {
            this.transport = testTransport;
        } else {
            this.populateDefaults();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("ctor: derived default client id %s client secret %s sa dir %s transport %s", this.defaultedClientId, this.defaultedClientSecret, this.defaultedServiceAccountDirectory, transport));
        }
    }

    synchronized void createFilter() {
        if (this.filter == null || !this.filter.initCalled) {
            try {
                this.filter = new OpenShiftPermissionFilter();
                PluginServletFilter.addFilter((Filter)this.filter);
            }
            catch (ServletException e) {
                LOGGER.log(Level.SEVERE, "createFilter", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean populateDefaults() throws IOException, GeneralSecurityException {
        boolean withinAPod;
        boolean runningInOpenShiftPodWithRequiredOAuthFeatures;
        block21: {
            this.createFilter();
            runningInOpenShiftPodWithRequiredOAuthFeatures = EnvVars.masterEnvVars.get(K8S_HOST_ENV_VAR) != null && EnvVars.masterEnvVars.get(K8S_PORT_ENV_VAR) != null;
            withinAPod = runningInOpenShiftPodWithRequiredOAuthFeatures || new File(this.getDefaultedServiceAccountDirectory()).exists();
            FileInputStream fis = null;
            BufferedReader br = null;
            try {
                br = new BufferedReader(new FileReader(new File(this.getDefaultedServiceAccountDirectory(), NAMESPACE)));
                this.namespace = br.readLine();
                runningInOpenShiftPodWithRequiredOAuthFeatures = runningInOpenShiftPodWithRequiredOAuthFeatures && this.namespace != null && this.namespace.length() > 0;
                br = new BufferedReader(new FileReader(new File(this.getDefaultedServiceAccountDirectory(), TOKEN)));
                this.defaultedClientSecret = br.readLine();
                runningInOpenShiftPodWithRequiredOAuthFeatures = runningInOpenShiftPodWithRequiredOAuthFeatures && this.defaultedClientSecret != null && this.defaultedClientSecret.length() > 0;
                fis = new FileInputStream(new File(this.getDefaultedServiceAccountDirectory(), CA_CRT));
                KeyStore keyStore = SecurityUtils.getDefaultKeyStore();
                try {
                    keyStore.size();
                }
                catch (KeyStoreException e) {
                    keyStore.load(null);
                }
                SecurityUtils.loadKeyStoreFromCertificates((KeyStore)keyStore, (CertificateFactory)SecurityUtils.getX509CertificateFactory(), (InputStream)fis);
                this.transport = new NetHttpTransport.Builder().trustCertificates(keyStore).build();
            }
            catch (FileNotFoundException e) {
                runningInOpenShiftPodWithRequiredOAuthFeatures = false;
                if (LOGGER.isLoggable(Level.FINE) || withinAPod) {
                    LOGGER.log(Level.FINE, "populatateDefaults", e);
                }
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (br != null) {
                    br.close();
                }
            }
            Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setAccessToken(this.getDefaultedClientSecret().getPlainText());
            try {
                OpenShiftUserInfo user = this.getOpenShiftUserInfo(credential, this.transport);
                String[] userNameParts = user.getName().split(":");
                if (userNameParts != null && userNameParts.length == 4) {
                    this.defaultedServiceAccountName = userNameParts[3];
                }
                runningInOpenShiftPodWithRequiredOAuthFeatures = runningInOpenShiftPodWithRequiredOAuthFeatures && this.defaultedServiceAccountName != null && this.defaultedServiceAccountName.length() > 0;
                this.defaultedClientId = "system:serviceaccount:" + this.namespace + ":" + this.getDefaultedServiceAccountName();
                this.provider = this.getOpenShiftOAuthProvider(credential, this.transport);
                if (withinAPod) {
                    LOGGER.info(String.format("OpenShift OAuth: provider: %s", this.provider));
                }
                if (this.provider != null) {
                    this.defaultedRedirectURL = this.provider.issuer;
                } else {
                    runningInOpenShiftPodWithRequiredOAuthFeatures = false;
                }
            }
            catch (Throwable t) {
                runningInOpenShiftPodWithRequiredOAuthFeatures = false;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "populateDefaults", t);
                }
                if (!withinAPod) break block21;
                LOGGER.log(Level.INFO, "populateDefaults", t);
            }
        }
        if (!runningInOpenShiftPodWithRequiredOAuthFeatures) {
            boolean hasRedirectURL;
            boolean hasSAName = this.serviceAccountName != null || this.defaultedServiceAccountName != null;
            boolean hasSecret = this.clientSecret != null || this.defaultedClientSecret != null;
            boolean hasClientID = this.clientId != null || this.defaultedClientId != null;
            boolean hasClientSecret = this.clientSecret != null || this.defaultedClientSecret != null;
            boolean bl = hasRedirectURL = this.redirectURL != null || this.defaultedRedirectURL != null;
            if (this.namespace != null && hasSAName && hasSecret && hasClientID && hasClientSecret && hasRedirectURL) {
                runningInOpenShiftPodWithRequiredOAuthFeatures = true;
            }
        }
        if (withinAPod) {
            LOGGER.info(String.format("OpenShift OAuth returning %s with namespace %s SA dir %s default %s SA name %s default %s client ID %s default %s secret %s default %s redirect %s default %s server %s default %s", runningInOpenShiftPodWithRequiredOAuthFeatures, this.namespace, this.serviceAccountDirectory, this.defaultedServiceAccountDirectory, this.serviceAccountName, this.defaultedServiceAccountName, this.clientId, this.defaultedClientId, Secret.toString((Secret)this.clientSecret).length() > 6 ? Secret.toString((Secret)this.clientSecret).substring(0, 5) + "......." : "null", this.defaultedClientSecret != null && this.defaultedClientSecret.length() > 6 ? this.defaultedClientSecret.substring(0, 5) + "......." : "null", this.redirectURL, this.defaultedRedirectURL, this.serverPrefix, this.defaultedServerPrefix));
        }
        return runningInOpenShiftPodWithRequiredOAuthFeatures;
    }

    public String getServiceAccountDirectory() {
        return this.serviceAccountDirectory;
    }

    public String getDefaultedServiceAccountDirectory() {
        if (this.getServiceAccountDirectory() == null) {
            return this.defaultedServiceAccountDirectory;
        }
        return this.getServiceAccountDirectory();
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public String getDefaultedServiceAccountName() {
        if (this.getServiceAccountName() == null) {
            return this.defaultedServiceAccountName;
        }
        return this.getServiceAccountName();
    }

    public String getServerPrefix() {
        return this.serverPrefix;
    }

    public String getDefaultedServerPrefix() {
        if (this.getServerPrefix() == null) {
            return this.defaultedServerPrefix;
        }
        return this.getServerPrefix();
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public String getDefaultedRedirectURL() {
        if (this.getRedirectURL() == null) {
            return this.defaultedRedirectURL;
        }
        return this.getRedirectURL();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getDefaultedClientId() {
        if (this.getClientId() == null) {
            return this.defaultedClientId;
        }
        return this.getClientId();
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public Secret getDefaultedClientSecret() {
        if (this.getClientSecret() == null) {
            return Secret.fromString((String)this.defaultedClientSecret);
        }
        return this.getClientSecret();
    }

    public String getDefaultedNamespace() {
        return this.namespace;
    }

    public String getLoginUrl() {
        return LOGIN_URL;
    }

    private OpenShiftProviderInfo getOpenShiftOAuthProvider(final Credential credential, HttpTransport transport) throws IOException {
        HttpRequestFactory requestFactory = transport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                credential.initialize(request);
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        GenericUrl url = new GenericUrl(this.getDefaultedServerPrefix() + OAUTH_PROVIDER_URI);
        HttpRequest request = requestFactory.buildGetRequest(url);
        OpenShiftProviderInfo info = (OpenShiftProviderInfo)request.execute().parseAs(OpenShiftProviderInfo.class);
        return info;
    }

    private OpenShiftUserInfo getOpenShiftUserInfo(final Credential credential, HttpTransport transport) throws IOException {
        HttpRequestFactory requestFactory = transport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                credential.initialize(request);
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        GenericUrl url = new GenericUrl(this.getDefaultedServerPrefix() + USER_URI);
        HttpRequest request = requestFactory.buildGetRequest(url);
        OpenShiftUserInfo info = (OpenShiftUserInfo)((Object)request.execute().parseAs(OpenShiftUserInfo.class));
        return info;
    }

    private String buildSARJson(String namespace, String verb) throws IOException {
        OpenShiftSubjectAccessReviewRequest request = new OpenShiftSubjectAccessReviewRequest();
        request.namespace = namespace;
        request.verb = verb;
        String json = JSON_FACTORY.toString((Object)request);
        return json;
    }

    private HttpRequest buildPostSARRequest(HttpRequestFactory requestFactory, GenericUrl url, final String json) throws IOException {
        HttpContent contentAdmin = new HttpContent(){

            public long getLength() throws IOException {
                return json.getBytes().length;
            }

            public String getType() {
                return "application/json";
            }

            public boolean retrySupported() {
                return false;
            }

            public void writeTo(OutputStream out) throws IOException {
                out.write(json.getBytes());
                out.flush();
            }
        };
        return requestFactory.buildPostRequest(url, contentAdmin);
    }

    private Set<String> postSAR(final Credential credential, HttpTransport transport) throws IOException {
        HashSet<String> allowedVerbs = new HashSet<String>();
        HttpRequestFactory requestFactory = transport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                credential.initialize(request);
                request.setParser((ObjectParser)new JsonObjectParser(JSON_FACTORY));
            }
        });
        GenericUrl url = new GenericUrl(this.getDefaultedServerPrefix() + SAR_URI);
        for (String verb : ROLES) {
            String json = this.buildSARJson(this.namespace, verb);
            HttpRequest request = this.buildPostSARRequest(requestFactory, url, json);
            OpenShiftSubjectAccessReviewResponse review = (OpenShiftSubjectAccessReviewResponse)request.execute().parseAs(OpenShiftSubjectAccessReviewResponse.class);
            if (review == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("postSAR: response for verb %s hydrated into obj: namespace %s allowed %s reason %s", verb, review.namespace, Boolean.toString(review.allowed), review.reason));
            }
            if (!review.allowed) continue;
            allowedVerbs.add(verb);
        }
        return allowedVerbs;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof AnonymousAuthenticationToken) {
                    return authentication;
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        });
    }

    protected OAuthSession newOAuthSession(String from, final String redirectOnFinish) throws MalformedURLException {
        GenericUrl tokenServerURL = new GenericUrl(this.getDefaultedServerPrefix() + "/oauth/token");
        String authorizationServerURL = this.getDefaultedRedirectURL() + "/oauth/authorize";
        final AuthorizationCodeFlow flow = new AuthorizationCodeFlow.Builder(BearerToken.queryParameterAccessMethod(), this.transport, JSON_FACTORY, tokenServerURL, (HttpExecuteInterceptor)new ClientParametersAuthentication(this.getDefaultedClientId(), this.getDefaultedClientSecret().getPlainText()), this.getDefaultedClientId(), authorizationServerURL).setScopes(Arrays.asList(SCOPE_INFO, SCOPE_CHECK_ACCESS)).build();
        final OpenShiftOAuth2SecurityRealm secRealm = this;
        final String url = this.buildOAuthRedirectUrl(redirectOnFinish);
        return new OAuthSession(flow, from, url){

            @Override
            public HttpResponse onSuccess(String authorizationCode) {
                try {
                    IdTokenResponse response = IdTokenResponse.execute((TokenRequest)flow.newTokenRequest(authorizationCode).setRedirectUri(url));
                    Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setFromTokenResponse((TokenResponse)response);
                    this.setCredential(credential);
                    secRealm.updateAuthorizationStrategy(credential);
                    return new HttpRedirect(redirectOnFinish);
                }
                catch (Throwable e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "onSuccess", e);
                    }
                    return HttpResponses.error((int)500, (Throwable)e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsernamePasswordAuthenticationToken updateAuthorizationStrategy(Credential credential) throws IOException, GeneralSecurityException {
        this.populateDefaults();
        OpenShiftUserInfo info = this.getOpenShiftUserInfo(credential, this.transport);
        Set<String> allowedRoles = this.postSAR(credential, this.transport);
        GrantedAuthority[] authorities = new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY};
        String suffix = null;
        if (allowedRoles.contains("admin")) {
            suffix = "-admin";
        } else if (allowedRoles.contains("edit")) {
            suffix = "-edit";
        } else if (allowedRoles.contains("view")) {
            suffix = "-view";
        }
        UsernamePasswordAuthenticationToken token = null;
        if (suffix != null) {
            String matrixKey = info.getName() + suffix;
            token = new UsernamePasswordAuthenticationToken((Object)matrixKey, (Object)"", authorities);
            SecurityContextHolder.getContext().setAuthentication((Authentication)token);
            User u = User.get((String)token.getName());
            info.updateProfile(u);
            u.setFullName(info.getName());
            u.save();
            Object object = USER_UPDATE_LOCK;
            synchronized (object) {
                GlobalMatrixAuthorizationStrategy existingAuthMgr = (GlobalMatrixAuthorizationStrategy)Jenkins.getInstance().getAuthorizationStrategy();
                Set usersGroups = existingAuthMgr.getGroups();
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine(String.format("updateAuthorizationStrategy: got users %s where this user is %s", usersGroups.toString(), info.getName()));
                }
                if (usersGroups.contains(matrixKey)) {
                    LOGGER.info(String.format("OpenShift OAuth: user %s, stored in the matrix as %s, based on OpenShift roles %s already exists in Jenkins", info.getName(), matrixKey, allowedRoles));
                } else {
                    ArrayList permissionGroups = new ArrayList(PermissionGroup.getAll());
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("updateAuthorizationStrategy: permissions %s", ((Object)permissionGroups).toString()));
                    }
                    Object newAuthMgr = null;
                    newAuthMgr = existingAuthMgr instanceof ProjectMatrixAuthorizationStrategy ? new ProjectMatrixAuthorizationStrategy() : new GlobalMatrixAuthorizationStrategy();
                    for (String userGroup : usersGroups) {
                        for (PermissionGroup pg : permissionGroups) {
                            for (Permission p : pg.getPermissions()) {
                                if (!existingAuthMgr.hasPermission(userGroup, p)) continue;
                                newAuthMgr.add(p, userGroup);
                            }
                        }
                        LOGGER.info(String.format("OpenShift OAuth: adding permissions for user %s, stored in the matrix as %s, based on OpenShift roles %s", info.getName(), matrixKey, allowedRoles));
                        if (allowedRoles.contains("view") || allowedRoles.contains("edit") || allowedRoles.contains("admin")) {
                            newAuthMgr.add(Hudson.READ, matrixKey);
                            newAuthMgr.add(Item.READ, matrixKey);
                            newAuthMgr.add(Item.DISCOVER, matrixKey);
                            newAuthMgr.add(CredentialsProvider.VIEW, matrixKey);
                        }
                        if (allowedRoles.contains("edit") || allowedRoles.contains("admin")) {
                            newAuthMgr.add(Item.BUILD, matrixKey);
                            newAuthMgr.add(Item.CONFIGURE, matrixKey);
                            newAuthMgr.add(Item.CREATE, matrixKey);
                            newAuthMgr.add(Item.DELETE, matrixKey);
                            newAuthMgr.add(Item.WORKSPACE, matrixKey);
                            newAuthMgr.add(SCM.TAG, matrixKey);
                            newAuthMgr.add(Jenkins.RUN_SCRIPTS, matrixKey);
                        }
                        if (!allowedRoles.contains("admin")) continue;
                        newAuthMgr.add(Computer.CONFIGURE, matrixKey);
                        newAuthMgr.add(Computer.DELETE, matrixKey);
                        newAuthMgr.add(Hudson.ADMINISTER, matrixKey);
                        newAuthMgr.add(Hudson.READ, matrixKey);
                        newAuthMgr.add(Run.DELETE, matrixKey);
                        newAuthMgr.add(Run.UPDATE, matrixKey);
                        newAuthMgr.add(View.CONFIGURE, matrixKey);
                        newAuthMgr.add(View.CREATE, matrixKey);
                        newAuthMgr.add(View.DELETE, matrixKey);
                        newAuthMgr.add(CredentialsProvider.CREATE, matrixKey);
                        newAuthMgr.add(CredentialsProvider.UPDATE, matrixKey);
                        newAuthMgr.add(CredentialsProvider.DELETE, matrixKey);
                        newAuthMgr.add(CredentialsProvider.MANAGE_DOMAINS, matrixKey);
                    }
                    if (newAuthMgr != null) {
                        Jenkins.getInstance().setAuthorizationStrategy((AuthorizationStrategy)newAuthMgr);
                        Jenkins.getInstance().save();
                    }
                }
            }
        }
        return token;
    }

    public HttpResponse doCommenceLogin(@QueryParameter String from, @Header(value="Referer") String referer) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.entering(OpenShiftOAuth2SecurityRealm.class.getName(), START_METHOD, new Object[]{from, referer});
        }
        try {
            this.populateDefaults();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
        URL fromURL = null;
        URL refererURL = null;
        try {
            fromURL = new URL(from);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            refererURL = new URL(referer);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String redirectOnFinish = fromURL != null ? from : (refererURL != null ? referer : Jenkins.getInstance().getRootUrl());
        return this.newOAuthSession(from, redirectOnFinish).doCommenceLogin();
    }

    private String buildOAuthRedirectUrl(String redirect) throws MalformedURLException {
        if (redirectUrl != null) {
            return redirectUrl;
        }
        URL url = null;
        url = new URL(redirect);
        if (url != null && (url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https"))) {
            return url.getProtocol() + "://" + url.getHost() + "/securityRealm/finishLogin";
        }
        throw new MalformedURLException("redirect url " + redirect + " insufficient");
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            if (request != null) {
                LOGGER.entering(OpenShiftOAuth2SecurityRealm.class.getName(), FINISH_METHOD, new Object[]{request.getQueryString(), request.getRequestURL()});
            } else {
                LOGGER.entering(OpenShiftOAuth2SecurityRealm.class.getName(), FINISH_METHOD);
            }
        }
        if (OAuthSession.getCurrent() != null) {
            return OAuthSession.getCurrent().doFinishLogin(request);
        }
        return new HttpRedirect(Jenkins.getInstance().getRootUrl());
    }

    protected String getPostLogOutUrl(StaplerRequest req, Authentication auth) {
        if (req.getRequestURL().toString().contains(LOGOUT)) {
            req.getSession().setAttribute(LOGGING_OUT, (Object)LOGGING_OUT);
        }
        return req.getRequestURL().toString().replace(LOGOUT, "");
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return OpenShiftOAuth2SecurityRealm.DISPLAY_NAME;
        }

        private FormValidation paramsWithPodDefaults(@QueryParameter String value) {
            if (value == null || value.length() == 0) {
                return FormValidation.warning((String)"Unless you specify a value here, the assumption will be that Jenkins is running inside an OpenShift pod, where the value is available.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServiceAccountDirectory(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckClientId(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckClientSecret(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckServerPrefix(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckRedirectURL(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }

        public FormValidation doCheckServiceAccountName(@QueryParameter String value) throws IOException, ServletException {
            return this.paramsWithPodDefaults(value);
        }
    }
}

