/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import com.google.api.client.util.Key;
import java.util.logging.Logger;

public class OpenShiftVersionInfo {
    static final Logger LOGGER = Logger.getLogger(OpenShiftVersionInfo.class.getName());
    @Key
    public String major;
    @Key
    public String minor;
    @Key
    public String gitVersion;

    public String toString() {
        return "OpenShiftVersionInfo: major: " + this.major + " minor: " + this.minor + " gitVersion: " + this.gitVersion;
    }

    public boolean isOpenShift3Cluster() {
        return !this.isOpenShift4Cluster();
    }

    public boolean isOpenShift4Cluster() {
        if (this.major != null && this.major.equals("1")) {
            if (this.minor.length() > 1) {
                String minor = this.minor.substring(0, 2);
                int m = Integer.parseInt(minor);
                if (m <= 11) {
                    LOGGER.info("OpenShift OAuth the server is 3.x, specifically " + this.toString());
                    return false;
                }
                LOGGER.info("OpenShift OAuth server is 4.x, specifically " + this.toString());
                return true;
            }
            LOGGER.info("OpenShift OAuth the server is 3.x, specifically " + this.toString());
            return false;
        }
        LOGGER.info("OpenShift OAuth server is 3.x, specifically " + this.toString());
        return false;
    }
}

