/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.TokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.auth.openidconnect.IdTokenResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.HttpResponses;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.openshift.jenkins.plugins.openshiftlogin.OAuthSession;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftOAuth2SecurityRealm;

public final class BearerTokenOAuthSession
extends OAuthSession {
    static final Logger LOGGER = Logger.getLogger(BearerTokenOAuthSession.class.getName());
    private final String redirectOnFinish;
    private final String url;
    @SuppressFBWarnings
    private final AuthorizationCodeFlow flow;
    private final OpenShiftOAuth2SecurityRealm secRealm;

    public BearerTokenOAuthSession(AuthorizationCodeFlow flow, String from, String redirectUrl, String redirectOnFinish, String url, AuthorizationCodeFlow flow2, OpenShiftOAuth2SecurityRealm secRealm) {
        super(flow, from, redirectUrl);
        this.redirectOnFinish = redirectOnFinish;
        this.url = url;
        this.flow = flow2;
        this.secRealm = secRealm;
    }

    @Override
    public HttpResponse onSuccess(String authorizationCode) {
        try {
            LOGGER.info("");
            AuthorizationCodeTokenRequest tokenRequest = this.flow.newTokenRequest(authorizationCode).setRedirectUri(this.url);
            IdTokenResponse response = IdTokenResponse.execute((TokenRequest)tokenRequest);
            Credential credential = new Credential(BearerToken.authorizationHeaderAccessMethod()).setFromTokenResponse((TokenResponse)response);
            this.setCredential(credential);
            this.secRealm.updateAuthorizationStrategy(credential);
            return new HttpRedirect(this.redirectOnFinish);
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "onSuccess", e);
            }
            return HttpResponses.error((int)500, (Throwable)e);
        }
    }
}

