/*
 * Decompiled with CFR 0.152.
 */
package org.openshift.jenkins.plugins.openshiftlogin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.openshift.jenkins.plugins.openshiftlogin.OpenShiftOAuth2SecurityRealm;

public class OpenShiftHttpRedirectWithPrompt
extends RuntimeException
implements HttpResponse {
    private final int statusCode;
    private final String url;
    private ArrayList<String> redirect;
    public static HttpRedirect DOT = new HttpRedirect(".");
    public static HttpResponse CONTEXT_ROOT = OpenShiftHttpRedirectWithPrompt.fromContextPath("");

    public OpenShiftHttpRedirectWithPrompt(@Nonnull String url) {
        this(302, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenShiftHttpRedirectWithPrompt(int statusCode, @Nonnull String url) {
        this.statusCode = statusCode;
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        this.redirect = new ArrayList();
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            is = this.getClass().getResourceAsStream("openshift-jenkins.html");
            isr = new InputStreamReader(is, Charset.forName("UTF-8"));
            br = new BufferedReader(isr);
            String s = null;
            while ((s = br.readLine()) != null) {
                s = s.replace("<a href=\"#", "<a href=\"" + url);
                this.redirect.add(s);
            }
        }
        catch (Throwable t) {
            if (OpenShiftOAuth2SecurityRealm.LOGGER.isLoggable(Level.FINE)) {
                OpenShiftOAuth2SecurityRealm.LOGGER.log(Level.FINE, "ctor", t);
            }
        }
        finally {
            block32: {
                block31: {
                    block30: {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException e) {
                                if (!OpenShiftOAuth2SecurityRealm.LOGGER.isLoggable(Level.FINE)) break block30;
                                OpenShiftOAuth2SecurityRealm.LOGGER.log(Level.FINE, "ctor", e);
                            }
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e) {
                            if (!OpenShiftOAuth2SecurityRealm.LOGGER.isLoggable(Level.FINE)) break block31;
                            OpenShiftOAuth2SecurityRealm.LOGGER.log(Level.FINE, "ctor", e);
                        }
                    }
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        if (!OpenShiftOAuth2SecurityRealm.LOGGER.isLoggable(Level.FINE)) break block32;
                        OpenShiftOAuth2SecurityRealm.LOGGER.log(Level.FINE, "generateResponse", e);
                    }
                }
            }
        }
    }

    public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
        PrintWriter w = rsp.getWriter();
        if (w != null && req.getSession().getAttribute("loggingOut") == null) {
            rsp.setContentType("text/html");
            for (String s : this.redirect) {
                w.println(s);
            }
            w.flush();
        } else {
            rsp.sendRedirect(this.statusCode, this.url);
        }
    }

    public static HttpResponse fromContextPath(String relative) {
        return HttpResponses.redirectViaContextPath((String)relative);
    }
}

