/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot.v2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMConnectionProvider;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.ircbot.IrcPublisher;
import hudson.plugins.ircbot.v2.IRCConnection;

public class IRCConnectionProvider
extends IMConnectionProvider {
    private static final IMConnectionProvider INSTANCE = new IRCConnectionProvider();

    public static final synchronized IMConnectionProvider getInstance() {
        return INSTANCE;
    }

    public static final synchronized void setDesc(IMPublisherDescriptor desc) throws IMException {
        INSTANCE.setDescriptor(desc);
        INSTANCE.releaseConnection();
    }

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="Yes we do generally init() ourselves")
    private IRCConnectionProvider() {
        this.init();
    }

    public synchronized IMConnection createConnection() throws IMException {
        this.releaseConnection();
        if (this.getDescriptor() == null) {
            throw new IMException("Descriptor not set");
        }
        IRCConnection imConnection = new IRCConnection((IrcPublisher.DescriptorImpl)this.getDescriptor(), this.getAuthenticationHolder());
        if (imConnection.connect()) {
            return imConnection;
        }
        imConnection.close();
        throw new IMException("Connection failed");
    }
}

