/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot.v2;

import hudson.plugins.im.IMChat;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageListener;
import hudson.plugins.ircbot.v2.IRCConnection;
import hudson.plugins.ircbot.v2.PircListener;

public class IRCChannel
implements IMChat {
    private final String channelName;
    private final PircListener listener;
    private final IRCConnection connection;
    private final boolean commandsAccepted;

    public IRCChannel(String channelName, IRCConnection connection, PircListener listener, boolean commandsAccepted) {
        this.channelName = channelName;
        this.connection = connection;
        this.listener = listener;
        this.commandsAccepted = commandsAccepted;
    }

    public String getNickName(String senderId) {
        return senderId;
    }

    public String getIMId(String senderId) {
        return senderId;
    }

    public boolean isMultiUserChat() {
        return true;
    }

    public boolean isCommandsAccepted() {
        return this.commandsAccepted;
    }

    public void addMessageListener(IMMessageListener listener) {
        this.listener.addMessageListener(this.channelName, listener);
    }

    public void removeMessageListener(IMMessageListener listener) {
        this.listener.removeMessageListener(this.channelName, listener);
    }

    public void sendMessage(String message) throws IMException {
        this.connection.send(this.channelName, message);
    }
}

