/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ircbot;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.plugins.im.GroupChatIMMessageTarget;
import hudson.plugins.im.IMConnection;
import hudson.plugins.im.IMException;
import hudson.plugins.im.IMMessageTarget;
import hudson.plugins.im.IMMessageTargetConverter;
import hudson.plugins.im.IMPublisher;
import hudson.plugins.im.IMPublisherDescriptor;
import hudson.plugins.im.MatrixJobMultiplier;
import hudson.plugins.im.NotificationStrategy;
import hudson.plugins.im.build_notify.BuildToChatNotifier;
import hudson.plugins.im.config.ParameterNames;
import hudson.plugins.im.tools.ExceptionHelper;
import hudson.plugins.ircbot.IrcUserProperty;
import hudson.plugins.ircbot.v2.IRCConnectionProvider;
import hudson.plugins.ircbot.v2.IRCMessageTargetConverter;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.Scrambler;
import hudson.util.Secret;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest;

public class IrcPublisher
extends IMPublisher {
    private static final Logger LOGGER = Logger.getLogger(IrcPublisher.class.getName());
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();
    private static final IMMessageTargetConverter CONVERTER = new IRCMessageTargetConverter();
    @Deprecated
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"})
    public List<String> channels = new ArrayList<String>();

    public IrcPublisher(List<IMMessageTarget> defaultTargets, String notificationStrategy, boolean notifyGroupChatsOnBuildStart, boolean notifySuspects, boolean notifyCulprits, boolean notifyFixers, boolean notifyUpstreamCommitters, BuildToChatNotifier buildToChatNotifier, MatrixJobMultiplier matrixMultiplier) {
        super(defaultTargets, notificationStrategy, notifyGroupChatsOnBuildStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstreamCommitters, buildToChatNotifier, matrixMultiplier);
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    protected String getConfiguredIMId(User user) {
        IrcUserProperty ircUserProperty = (IrcUserProperty)((Object)user.getProperties().get((Object)IrcUserProperty.DESCRIPTOR));
        if (ircUserProperty != null) {
            return ircUserProperty.getNick();
        }
        return null;
    }

    protected IMConnection getIMConnection() throws IMException {
        return IRCConnectionProvider.getInstance().currentConnection();
    }

    protected String getPluginName() {
        return "IRC notifier plugin";
    }

    protected Object readResolve() {
        super.readResolve();
        if (this.getNotificationTargets() == null) {
            if (this.channels != null) {
                ArrayList<GroupChatIMMessageTarget> targets = new ArrayList<GroupChatIMMessageTarget>(this.channels.size());
                for (String channel : this.channels) {
                    targets.add(new GroupChatIMMessageTarget(channel));
                }
                this.setNotificationTargets(targets);
            } else {
                this.setNotificationTargets(Collections.emptyList());
            }
        }
        this.channels = null;
        if (this.getNotificationStrategy() == null) {
            this.setNotificationStrategy(NotificationStrategy.STATECHANGE_ONLY);
        }
        return this;
    }

    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher>
    implements IMPublisherDescriptor {
        private static final String PREFIX = "irc_publisher.";
        private static final String[] CHARSETS;
        boolean enabled = false;
        String hostname = null;
        Integer port = 194;
        private boolean ssl;
        private boolean disallowPrivateChat;
        private String login = "PircBotx";
        private boolean sslTrustAllCertificates;
        @Deprecated
        transient String password = null;
        Secret secretPassword;
        private boolean sasl;
        String nick = "jenkins";
        @Deprecated
        transient String nickServPassword = null;
        Secret secretNickServPassword;
        private String socksHost = null;
        private Integer socksPort = 1080;
        private Integer messageRate = this.getMessageRateFromSystemProperty();
        @Deprecated
        List<String> channels;
        private List<IMMessageTarget> defaultTargets;
        String commandPrefix = "!jenkins";
        @Deprecated
        private transient String hudsonLogin;
        private String jenkinsLogin;
        private boolean useNotice;
        private String charset;
        private boolean useColors;

        public String[] getCharsets() {
            return CHARSETS;
        }

        DescriptorImpl() {
            super(IrcPublisher.class);
            this.load();
            if (this.isEnabled()) {
                try {
                    IRCConnectionProvider.setDesc(this);
                }
                catch (Exception e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            } else {
                try {
                    IRCConnectionProvider.setDesc(null);
                }
                catch (IMException iMException) {
                    // empty catch block
                }
            }
        }

        @Deprecated
        @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="Here just in case for UI and config loads")
        private static List<JSONObject> fillChannelsFromJSON(JSONObject root) {
            throw new UnsupportedOperationException();
        }

        @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="There are, in fact, side effects")
        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            boolean bl = this.enabled = "on".equals(req.getParameter("irc_publisher.enabled")) || "true".equals(req.getParameter("irc_publisher.enabled"));
            if (this.enabled) {
                JSONObject enabled = formData.getJSONObject("enabled");
                req.bindJSON((Object)this, enabled);
                try {
                    IRCConnectionProvider.setDesc(this);
                    IRCConnectionProvider.getInstance().currentConnection();
                }
                catch (Exception e) {
                    LOGGER.warning(ExceptionHelper.dump((Throwable)e));
                }
            } else {
                IRCConnectionProvider.getInstance().releaseConnection();
                try {
                    IRCConnectionProvider.setDesc(null);
                }
                catch (IMException iMException) {
                    // empty catch block
                }
            }
            this.save();
            return super.configure(req, formData);
        }

        public String getDisplayName() {
            return "IRC Notification";
        }

        public String getHelpFile() {
            return "/plugin/ircbot/help.html";
        }

        public Publisher newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            String n;
            if (req == null) {
                throw new IllegalArgumentException("req must be non null");
            }
            ArrayList<IMMessageTarget> targets = new ArrayList<IMMessageTarget>();
            if (formData.has("notificationTargets")) {
                JSONArray jchans = formData.optJSONArray("notificationTargets");
                if (jchans != null) {
                    for (int i = 0; i < jchans.size(); ++i) {
                        JSONObject channel = jchans.getJSONObject(i);
                        String name = channel.getString("name");
                        if (Util.fixEmptyAndTrim((String)name) == null) {
                            throw new Descriptor.FormException("Channel name must not be empty", "channel.name");
                        }
                        Secret channelPasssword = Secret.fromString((String)channel.getString("secretPassword"));
                        boolean notificationOnly = channel.getBoolean("notificationOnly");
                        targets.add((IMMessageTarget)new GroupChatIMMessageTarget(name, channelPasssword, notificationOnly));
                    }
                } else {
                    JSONObject notificationTarget = formData.getJSONObject("notificationTargets");
                    String name = notificationTarget.getString("name");
                    if (Util.fixEmptyAndTrim((String)name) == null) {
                        throw new Descriptor.FormException("Channel name must not be empty", "channel.name");
                    }
                    Secret channelPasssword = Secret.fromString((String)notificationTarget.getString("secretPassword"));
                    boolean notificationOnly = notificationTarget.getBoolean("notificationOnly");
                    targets.add((IMMessageTarget)new GroupChatIMMessageTarget(name, channelPasssword, notificationOnly));
                }
            }
            if ((n = req.getParameter(this.getParamNames().getStrategy())) == null) {
                n = PARAMETERVALUE_STRATEGY_DEFAULT;
            } else {
                boolean foundStrategyValueMatch = false;
                for (String strategyValue : PARAMETERVALUE_STRATEGY_VALUES) {
                    if (!strategyValue.equals(n)) continue;
                    foundStrategyValueMatch = true;
                    break;
                }
                if (!foundStrategyValueMatch) {
                    n = PARAMETERVALUE_STRATEGY_DEFAULT;
                }
            }
            boolean notifyStart = "on".equals(req.getParameter(this.getParamNames().getNotifyStart()));
            boolean notifySuspects = "on".equals(req.getParameter(this.getParamNames().getNotifySuspects()));
            boolean notifyCulprits = "on".equals(req.getParameter(this.getParamNames().getNotifyCulprits()));
            boolean notifyFixers = "on".equals(req.getParameter(this.getParamNames().getNotifyFixers()));
            boolean notifyUpstream = "on".equals(req.getParameter(this.getParamNames().getNotifyUpstreamCommitters()));
            MatrixJobMultiplier matrixJobMultiplier = MatrixJobMultiplier.ONLY_CONFIGURATIONS;
            if (formData.has("matrixNotifier")) {
                String o = formData.getString("matrixNotifier");
                matrixJobMultiplier = MatrixJobMultiplier.valueOf((String)o);
            }
            return new IrcPublisher(targets, n, notifyStart, notifySuspects, notifyCulprits, notifyFixers, notifyUpstream, (BuildToChatNotifier)req.bindJSON(BuildToChatNotifier.class, formData.getJSONObject("buildToChatNotifier")), matrixJobMultiplier);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getCommandPrefix() {
            return this.commandPrefix;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getJenkinsLogin() {
            return this.jenkinsLogin;
        }

        public void setJenkinsLogin(String jenkinsLogin) {
            this.jenkinsLogin = jenkinsLogin;
        }

        public String getNick() {
            return this.nick;
        }

        @Deprecated
        public String getNickServPassword() {
            return this.getSecretNickServPassword().getPlainText();
        }

        public Secret getSecretNickServPassword() {
            return this.secretNickServPassword;
        }

        public String getLogin() {
            return this.login;
        }

        public Secret getSecretPassword() {
            return this.secretPassword;
        }

        public boolean isSasl() {
            return this.sasl;
        }

        public int getPort() {
            return this.port;
        }

        public String getSocksHost() {
            return this.socksHost;
        }

        public int getSocksPort() {
            return this.socksPort;
        }

        public boolean isSsl() {
            return this.ssl;
        }

        public boolean isTrustAllCertificates() {
            return this.sslTrustAllCertificates;
        }

        public boolean isDisallowPrivateChat() {
            return this.disallowPrivateChat;
        }

        public Integer getMessageRate() {
            return this.messageRate;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDefaultIdSuffix() {
            return null;
        }

        public String getHost() {
            return this.hostname;
        }

        public String getHudsonUserName() {
            return this.jenkinsLogin;
        }

        public String getPluginDescription() {
            return "IRC notifier plugin";
        }

        public String getUserName() {
            return this.nick;
        }

        public boolean isExposePresence() {
            return true;
        }

        public List<IMMessageTarget> getDefaultTargets() {
            if (this.defaultTargets == null) {
                return Collections.emptyList();
            }
            return this.defaultTargets;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void setSsl(boolean ssl) {
            this.ssl = ssl;
        }

        public void setDisallowPrivateChat(boolean disallowPrivateChat) {
            this.disallowPrivateChat = disallowPrivateChat;
        }

        public void setLogin(String login) {
            this.login = login;
        }

        public boolean isSslTrustAllCertificates() {
            return this.sslTrustAllCertificates;
        }

        public void setSslTrustAllCertificates(boolean sslTrustAllCertificates) {
            this.sslTrustAllCertificates = sslTrustAllCertificates;
        }

        public void setSecretPassword(Secret secretPassword) {
            this.secretPassword = secretPassword;
        }

        public void setSasl(boolean sasl) {
            this.sasl = sasl;
        }

        public void setNick(String nick) {
            this.nick = nick;
        }

        public void setSecretNickServPassword(Secret secretNickServPassword) {
            this.secretNickServPassword = secretNickServPassword;
        }

        public void setSocksHost(String socksHost) {
            this.socksHost = socksHost;
        }

        public void setSocksPort(Integer socksPort) {
            this.socksPort = socksPort;
        }

        public void setMessageRate(Integer messageRate) {
            this.messageRate = messageRate;
        }

        public void setDefaultTargets(List<IMMessageTarget> defaultTargets) {
            this.defaultTargets = defaultTargets;
        }

        public void setCommandPrefix(String commandPrefix) {
            this.commandPrefix = commandPrefix;
        }

        public void setUseNotice(boolean useNotice) {
            this.useNotice = useNotice;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        public void setUseColors(boolean useColors) {
            this.useColors = useColors;
        }

        public IMMessageTargetConverter getIMMessageTargetConverter() {
            return CONVERTER;
        }

        public boolean isUseNotice() {
            return this.useNotice;
        }

        public boolean isUseColors() {
            return this.useColors;
        }

        public String getCharset() {
            return this.charset;
        }

        @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="No idea how to solve")
        public ParameterNames getParamNames() {
            return new ParameterNames(){

                protected String getPrefix() {
                    return DescriptorImpl.PREFIX;
                }
            };
        }

        protected Integer getMessageRateFromSystemProperty() {
            try {
                return Integer.parseInt(System.getProperty("hudson.plugins.ircbot.messageRate", "500"));
            }
            catch (NumberFormatException nfe) {
                return 500;
            }
        }

        protected Object readResolve() {
            if (this.defaultTargets == null && this.channels != null) {
                this.defaultTargets = new ArrayList<IMMessageTarget>(this.channels.size());
                for (String channel : this.channels) {
                    this.defaultTargets.add((IMMessageTarget)new GroupChatIMMessageTarget(channel));
                }
                this.channels = null;
            }
            if (this.charset == null) {
                this.charset = "UTF-8";
            }
            if (this.messageRate == null) {
                this.messageRate = this.getMessageRateFromSystemProperty();
            }
            if (StringUtils.isNotBlank((String)this.password)) {
                this.secretPassword = Secret.fromString((String)Scrambler.descramble((String)this.password));
                this.password = null;
            }
            if (StringUtils.isNotBlank((String)this.nickServPassword)) {
                this.secretNickServPassword = Secret.fromString((String)Scrambler.descramble((String)this.nickServPassword));
                this.nickServPassword = null;
            }
            if (StringUtils.isNotBlank((String)this.hudsonLogin)) {
                this.jenkinsLogin = this.hudsonLogin;
                this.hudsonLogin = null;
            }
            return this;
        }

        static {
            SortedMap<String, Charset> availableCharsets = Charset.availableCharsets();
            String[] cs = new String[availableCharsets.size()];
            cs[0] = "UTF-8";
            int i = 1;
            for (String csName : availableCharsets.keySet()) {
                if ("UTF-8".equals(csName)) continue;
                cs[i++] = csName;
            }
            CHARSETS = cs;
        }
    }
}

