/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.im.tools;

import hudson.Util;
import hudson.model.Run;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public class MessageHelper {
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private static final String QUOTE = "\"";

    public static String getBuildURL(Run<?, ?> run) {
        if (run == null) {
            return "?";
        }
        StringBuilder builder = Jenkins.getInstanceOrNull() != null ? new StringBuilder(String.valueOf(Jenkins.get().getRootUrl())) : new StringBuilder("null");
        builder.append(Util.encode((String)run.getUrl()));
        return builder.toString();
    }

    public static String getTestUrl(hudson.tasks.test.TestResult result) {
        String buildUrl = MessageHelper.getBuildURL(result.getOwner());
        AbstractTestResultAction action = result.getTestResultAction();
        TestResult testResultRoot = null;
        for (TestObject parent = result.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof TestResult)) continue;
            testResultRoot = (TestResult)parent;
            break;
        }
        String testUrl = action.getUrlName() + (testResultRoot != null ? testResultRoot.getUrl() : "") + result.getUrl();
        String[] pathComponents = testUrl.split("/");
        StringBuilder buf = new StringBuilder();
        for (String c : pathComponents) {
            buf.append(Util.rawEncode((String)c)).append('/');
        }
        buf.deleteCharAt(buf.length() - 1);
        return buildUrl + buf.toString();
    }

    public static String[] extractCommandLine(String message) {
        List<String> parameters = MessageHelper.extractParameters(message);
        return parameters.toArray(new String[parameters.size()]);
    }

    private static List<String> extractParameters(String commandLine) {
        ArrayList<String> parameters = new ArrayList<String>();
        int firstQuote = (commandLine = commandLine.trim()).indexOf(QUOTE);
        if (firstQuote != -1) {
            int endQuoted = commandLine.indexOf(QUOTE, firstQuote + 1);
            if (endQuoted == -1) {
                Collections.addAll(parameters, SPACE_PATTERN.split(commandLine));
            } else if (firstQuote == 0) {
                parameters.add(commandLine.substring(1, endQuoted - 1));
            } else {
                parameters.addAll(MessageHelper.extractParameters(commandLine.substring(0, firstQuote)));
                parameters.add(commandLine.substring(firstQuote + 1, endQuoted));
                if (endQuoted < commandLine.length() - 1) {
                    parameters.addAll(MessageHelper.extractParameters(commandLine.substring(endQuoted + 1)));
                }
            }
        } else {
            Collections.addAll(parameters, SPACE_PATTERN.split(commandLine));
        }
        return parameters;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Class<?> type = original.getClass();
        Object[] copy = type == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(type.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        Class<?> type = original.getClass();
        Object[] copy = type == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(type.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static <T> T[] concat(T[] array1, T[] ... arrays) {
        int resultLength = array1.length;
        for (T[] array : arrays) {
            resultLength += array.length;
        }
        T[] result = MessageHelper.copyOf(array1, resultLength);
        int offset = array1.length;
        for (T[] array : arrays) {
            for (int i = 0; i < array.length; ++i) {
                result[offset + i] = array[i];
            }
            offset += array.length;
        }
        return result;
    }

    public static String join(String[] array, int startIndex) {
        String joined = StringUtils.join((Object[])MessageHelper.copyOfRange(array, startIndex, array.length), (String)" ");
        joined = joined.replaceAll(QUOTE, "");
        return joined;
    }

    public static String getJoinedName(String[] args, int startIndex) {
        String joined = MessageHelper.join(args, startIndex);
        return joined.replaceAll(QUOTE, "");
    }
}

