/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTAxisContainer;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTExcludes;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStageBase;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTStages;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTMatrix
extends ModelASTStageBase {
    private ModelASTAxisContainer axes;
    private ModelASTExcludes excludes;
    private ModelASTStages stages;

    public ModelASTMatrix(Object sourceLocation) {
        super(sourceLocation);
    }

    @Override
    @NonNull
    public JSONObject toJSON() {
        JSONObject o = super.toJSON().elementOpt("axes", ModelASTMatrix.toJSON(this.axes)).elementOpt("excludes", ModelASTMatrix.toJSON(this.excludes)).elementOpt("stages", ModelASTMatrix.toJSON(this.stages));
        return o;
    }

    @Override
    public void validate(ModelValidator validator) {
        super.validate(validator);
        validator.validateElement(this);
        ModelASTMatrix.validate(validator, this.axes, this.excludes);
        if (this.stages != null) {
            this.stages.validate(validator, true);
        }
    }

    @Override
    @NonNull
    public String toGroovy() {
        StringBuilder children = new StringBuilder().append(ModelASTMatrix.toGroovy(this.axes)).append(ModelASTMatrix.toGroovy(this.excludes)).append(super.toGroovy()).append(ModelASTMatrix.toGroovy(this.stages));
        return "matrix {\n" + children.toString() + "}\n";
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        ModelASTMatrix.removeSourceLocationsFrom(this.axes, this.excludes, this.stages);
    }

    @Override
    public String toString() {
        return "ModelASTMatrix{, axes=" + String.valueOf(this.axes) + ", excludes=" + String.valueOf(this.excludes) + ", " + super.toString() + "}";
    }

    public ModelASTAxisContainer getAxes() {
        return this.axes;
    }

    public void setAxes(ModelASTAxisContainer axes) {
        this.axes = axes;
    }

    public ModelASTExcludes getExcludes() {
        return this.excludes;
    }

    public void setExcludes(ModelASTExcludes excludes) {
        this.excludes = excludes;
    }

    public ModelASTStages getStages() {
        return this.stages;
    }

    public void setStages(ModelASTStages stages) {
        this.stages = stages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTMatrix that = (ModelASTMatrix)o;
        return Objects.equals(this.getAxes(), that.getAxes()) && Objects.equals(this.getExcludes(), that.getExcludes()) && Objects.equals(this.getStages(), that.getStages());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAxes(), this.getExcludes(), this.getStages());
    }
}

