/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElementContainer;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTMarkerInterface;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTValue;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTLibraries
extends ModelASTElement
implements ModelASTElementContainer {
    private List<ModelASTValue> libs = new ArrayList<ModelASTValue>();

    public ModelASTLibraries(Object sourceLocation) {
        super(sourceLocation);
    }

    @NonNull
    public JSONObject toJSON() {
        return ModelASTLibraries.toJSONObject("libraries", this.libs);
    }

    @Override
    public void validate(@NonNull ModelValidator validator) {
        validator.validateElement(this);
        ModelASTLibraries.validate(validator, this.libs, new ModelASTMarkerInterface[0]);
    }

    @Override
    @NonNull
    public String toGroovy() {
        StringBuilder result = new StringBuilder("libraries {\n");
        for (ModelASTValue v : this.libs) {
            result.append("lib(").append(v.toGroovy()).append(")\n");
        }
        result.append("}\n");
        return result.toString();
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        ModelASTLibraries.removeSourceLocationsFrom(this.libs);
    }

    @Override
    public boolean isEmpty() {
        return this.libs.isEmpty();
    }

    public List<ModelASTValue> getLibs() {
        return this.libs;
    }

    public void setLibs(List<ModelASTValue> libs) {
        this.libs = libs;
    }

    @Override
    public String toString() {
        return "ModelASTLibraries{libs=" + String.valueOf(this.libs) + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTLibraries that = (ModelASTLibraries)o;
        return this.getLibs() != null ? this.getLibs().equals(that.getLibs()) : that.getLibs() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getLibs() != null ? this.getLibs().hashCode() : 0);
        return result;
    }
}

