package org.jenkinsci.gradle.plugins.jpi

import org.gradle.api.DefaultTask
import org.gradle.api.plugins.JavaPluginExtension
import org.gradle.api.tasks.OutputFile
import org.gradle.api.tasks.SourceSet
import org.gradle.api.tasks.TaskAction

import static org.gradle.api.tasks.SourceSet.MAIN_SOURCE_SET_NAME

/**
 * @deprecated To be removed in 1.0.0
 * @see org.jenkinsci.gradle.plugins.testing.GenerateTestTask
 */
@Deprecated
class TestInsertionTask extends DefaultTask {
    public static final String TASK_NAME = 'insertTest'

    @OutputFile
    File testSuite

    @TaskAction
    void generateInjectedTest() {
        JpiExtension jpiExtension = project.extensions.getByType(JpiExtension)
        JavaPluginExtension javaPluginExtension = project.extensions.getByType(JavaPluginExtension)
        SourceSet mainSourceSet = javaPluginExtension.sourceSets.getByName(MAIN_SOURCE_SET_NAME)

        testSuite.parentFile.mkdirs()
        testSuite.text = """import java.util.*;

/**
 * Entry point to auto-generated tests (generated by gradle-jpi-plugin).
 */
public class ${jpiExtension.injectedTestName} extends junit.framework.TestCase {
    public static junit.framework.Test suite() throws Exception {
        Map<String, String> parameters = new HashMap<String, String>();
        parameters.put("basedir", ${quote(project.projectDir.absolutePath)});
        parameters.put("artifactId", ${quote(jpiExtension.shortName)});
        parameters.put("outputDirectory", ${quote(mainSourceSet.output.resourcesDir.absolutePath)});
        parameters.put("requirePI", ${quote(String.valueOf(jpiExtension.requirePI))});
        return new org.jvnet.hudson.test.PluginAutomaticTestBuilder().build(parameters);
    }
}
"""
    }

    private static String quote(String s) {
        "\"${s.replace('\\', '\\\\')}\""
    }
}
